<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="<?php echo e(url('prints')); ?>/images/favicon.png" rel="icon" />
        <title>General Invoice 3 - Koice</title>
        <meta name="author" content="harnishdesign.net">

        <!-- Web Fonts
======================= -->
        <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900' type='text/css'>

        <!-- Stylesheet
======================= -->
        <link rel="stylesheet" type="text/css" href="<?php echo e(url('prints')); ?>/vendor/bootstrap/css/bootstrap.min.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo e(url('prints')); ?>/vendor/font-awesome/css/all.min.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo e(url('prints')); ?>/css/stylesheet.css" />
    </head>

    <body>
        <!-- Container -->
        <div class="container-fluid invoice-container">
            <!-- Header -->
            <header>
                <div class="row align-items-center gy-3">
                    <div class="col-sm-7 text-center text-sm-start">
                        <img id="logo" src="<?php echo e(url('site/assets/img/logo.png')); ?>" title="<?php echo e(env('APP_EMPRESA')); ?>" alt="<?php echo e(env('APP_EMPRESA')); ?>" width="200px" />
                    </div>
                    <div class="col-sm-5 text-center text-sm-end">
                        <h4 class="text-2 mb-0">Registro <?php echo e($ingresso->registro); ?></h4>
                    </div>
                </div>
            </header>

            <main>
                <div class="table-responsive">
                    <table class="table table-bordered border border-secondary mb-0">
                        <tbody>
                            <tr>
                                <td class="col-7">
                                    <div class="row gx-2 gy-2">
                                        <div class="col-auto">
                                            <strong>
                                                <?php echo e($ingresso->Evento->titulo); ?> <br>
                                                <?php echo e($ingresso->Pacote->nome); ?> - <?php echo e(date('d/m/Y', strtotime($ingresso->Evento->data_inicio))); ?>

                                            </strong>
                                            <br><br>
                                            Local:<br>
                                            <strong><?php echo e($ingresso->Evento->local); ?> - <?php echo e($ingresso->Evento->cidade); ?>-<?php echo e($ingresso->Evento->estado); ?></strong>
                                            Organizador:<br>
                                            <strong><?php echo e($ingresso->Evento->ordanizador); ?></strong>
                                            <br><br>
                                            <?php echo $qr; ?>

                                            <br><br>
                                            Informações do pedido:<br>
                                            <strong>Registro: <?php echo e($ingresso->registro); ?></strong><br>
                                            <strong><?php echo e(date('d/m/Y H:i:s',strtotime($ingresso->created_at))); ?></strong>
                                        </div>
                                    </div>
                                </td>
                                <td class="col-5">
                                    <div class="row gx-2 gy-2">
                                        <div class="col-auto">
                                            <img src="<?php echo e(url("storage/{$ingresso->Evento->banner}")); ?>" style="width: 100px; height: 100px; object-fit: cover; object-position: center;">
                                            <br><br>
                                            Titular:<br>
                                            <strong><?php echo e($ingresso->nome_completo); ?></strong><br>
                                            <strong>CPF: <?php echo e($ingresso->cpf); ?></strong>
                                            <br><br>
                                            <div class=" text-center">
                                                <img src="<?php echo e($barcode); ?>" width="100%" height="75"> <br>
                                                <strong><?php echo e($ingresso->code_barras); ?></strong>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </main>


            <main style="margin-top: 30px">
                <div class="table-responsive">
                    <table class="table table-bordered border border-secondary mb-0">
                        <tbody>
                            <tr>
                                <td class="col-7">
                                    <div class="row gx-2 gy-2">
                                        <div class="col-auto">
                                            <strong>
                                                <?php echo e($ingresso->Evento->titulo); ?> <br>
                                                <?php echo e($ingresso->Pacote->nome); ?> - <?php echo e(date('d/m/Y', strtotime($ingresso->Evento->data_inicio))); ?>

                                            </strong>
                                            <br><br>
                                            Local:<br>
                                            <strong><?php echo e($ingresso->Evento->local); ?> - <?php echo e($ingresso->Evento->cidade); ?>-<?php echo e($ingresso->Evento->estado); ?></strong>
                                        </div>
                                    </div>
                                </td>
                                <td class="col-5">
                                    <div class="row text-center">
                                        <div class="col-auto">
                                            <?php echo e($ingresso->Pacote->nome); ?> - <?php echo e(date('d/m/Y', strtotime($ingresso->Evento->data_inicio))); ?>

                                            <br><br>
                                            <?php echo $qr; ?>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </main>


            <!-- Footer -->
            <footer class="text-center mt-4">
                <p class="text-2">
                    <strong><?php echo e(env('APP_EMPRESA')); ?></strong> <br>
                    Sua passagem para os eventos mais exclusivos começa aqui!
                </p>
            </footer>
        </div>
    </body>

</html>
<?php /**PATH F:\Laravel\Sollares2\resources\views/print/ingresso.blade.php ENDPATH**/ ?>