<!DOCTYPE html>
<html lang="pt-BR">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Musa Ticket</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                display: flex;
                flex-direction: column;
                align-items: center;
                margin: 0;
                padding: 0;
            }

            .ticket {
                width: 380px;
                height: 600px;
                border: 1px solid black;
                padding: 20px;
                text-align: center;
                position: relative;
                background-image: url('<?php echo e(url('site/images/ingresso.jpg')); ?>');
                background-size: contain;
                background-repeat: no-repeat;
                background-position: center;
                margin-bottom: 30px;
            }

            .logo {
                width: 80px;
                margin-bottom: 10px;
            }

            h2,
            h3,
            p {
                margin: 5px 0;
            }

            .price {
                font-size: 24px;
                font-weight: bold;
                margin-top: 20px;
            }

            .info-qr-container {
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: absolute;
                bottom: 20px;
                left: 40px;
                right: 40px;
            }

            .price-info {
                text-align: left;
            }

            .qr-code img {
                width: 100px;
            }

            .person-info {
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                margin-top: 30px;
            }

            .titulo1 {
                font-size: 25px;
                font-weight: bold;
            }

            .evento_titulo {
                font-size: 18px;
                font-weight: bold;
            }

            .text {
                font-size: 16px;
                font-weight: 600;
            }

            .evento {
                margin-top: 20px;
            }

            /* Quebra de página para impressão */
            .ticket {
                page-break-after: always;
            }

            @media print {
                * {
                    -webkit-print-color-adjust: exact;
                    color-adjust: exact;
                    /* Para navegadores que suportam */
                }
            }
        </style>
    </head>

    <body>
        <?php $__currentLoopData = $pedido->Ingressos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ingresso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="ticket">
                <img src="<?php echo e(url('site/images/favicon.png')); ?>" alt="Musa Logo" class="logo">
                <h2>Musa Ticket</h2>
                <p><?php echo e($ingresso->code_barras); ?></p>
                <p>CNPJ: <?php echo e(env('CNPJ')); ?></p>
                <div class="evento">
                    <h3 class="titulo1"><?php echo e($ingresso->Evento->titulo); ?></h3>
                    <p class="text">
                        <?php echo e(substr($semana[date('w', strtotime($ingresso->Evento->data_inicio))], 0, 4)); ?>, <?php echo e(date('d', strtotime($ingresso->Evento->data_inicio))); ?> de <?php echo e($mes[date('m', strtotime($ingresso->Evento->data_inicio))]); ?> de <?php echo e(date('Y', strtotime($ingresso->Evento->data_inicio))); ?> às <?php echo e(date('H:i', strtotime($ingresso->Evento->data_inicio))); ?> <br>
                        <?php echo e($ingresso->Evento->local); ?> <br>
                        
                    </p>
                </div>
                <div class="person-info">
                    <h3 class="evento_titulo"><?php echo e($ingresso->Pacote->nome); ?></h3>
                    <p class="text">
                        <?php echo $ingresso->qr_code; ?>

                        <br>
                    <h3 class="evento_titulo">R$ <?php echo e(moeda($ingresso->preco)); ?></h3>
                    </p>
                </div>
                <div class="info-qr-container">
                    <div class="price-info">
                        <p class="evento_titulo"><?php echo e($ingresso->nome_completo); ?></p>
                        <img src="<?php echo e($ingresso->barcode_img); ?>" alt="Código de Barras" width="100%">
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </body>

</html>
<?php /**PATH F:\Laravel\MusaTicket\resources\views/print/ingressos.blade.php ENDPATH**/ ?>