<?php $__env->startSection('titulo', $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">

                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">PDVs (Pontos de Venda)</h4>
                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modal-novo-colaborador"
                                    class="btn-rounded btn btn-warning mt-10 mt-md-0 btn-sm float-end">Adicionar PDV</a>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Nome do PDV</th>
                                                <th scope="col">Tipo de Ingresso</th>
                                                <th scope="col">Colaborador</th>
                                                <th scope="col">Status</th>
                                                <th scope="col">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_pdv">
                                            <?php $__currentLoopData = $Evento->PDVs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pdv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($pdv->nome); ?></td>
                                                    <td><?php echo e($pdv->Pacote->nome); ?></td>
                                                    <td><?php echo e($pdv->User->name); ?> <?php echo e($pdv->User->sobrenome); ?></td>
                                                    <td>
                                                        <span  class="badge badge-pill badge-<?php echo e($cor_status_pdv[$pdv->status]); ?>"><?php echo e($status_pdv[$pdv->status]); ?></span>
                                                    </td>
                                                    <td>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="modal fade modal-novo-colaborador" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Adicionar PDV</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Nome do PDV</label>
                                <input id="nome" type="text" class="form-control" placeholder="Nome que será exibido nos relatórios." id="pdv_nome">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Filtrar tipos de ingressos</label>
                                <select id="tipos_ingressos" class="form-control select2" multiple="multiple" data-placeholder="Tipos de Ingresso" style="width: 100%;">
                                    <?php $__currentLoopData = $Evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ingresso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($ingresso->id); ?>"><?php echo e($ingresso->nome); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Colaborador</label>
                                <select id="colaboradores" class="form-control select2" multiple="multiple" data-placeholder="Colaborador" style="width: 100%;">
                                    <?php $__currentLoopData = $Evento->Colaboradores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colaborador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($colaborador->user_id); ?>"><?php echo e($colaborador->User->name); ?> <?php echo e($colaborador->User->sobrenome); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button type="button" class="btn btn-danger text-start btn-rounded btn-sm"
                        data-bs-dismiss="modal">Fechar</button>
                    <button onclick="javascript:AddPDV(<?php echo e($Evento->id); ?>)" type="button"
                        class="btn btn-primary float-end btn-rounded btn-sm" data-bs-dismiss="modal">Adicionar</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .select2-container {
            z-index: 9999 !important;
            /* Valor alto para garantir que ficará acima do modal */
        }

        .select2-dropdown {
            z-index: 10000 !important;
            /* Garantir que o dropdown também tenha um z-index alto */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function AddPDV(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pdv.store')); ?>",
                method: 'POST',
                data: {
                    id:                 id,
                    nome:               $("#nome").val(),
                    tipos_ingressos:    $("#tipos_ingressos").val(),
                    colaboradores:      $("#colaboradores").val(),
                },
                success: function(result) {
                    if (result == 'error') {
                        swal("Atenção", "O email informado não foi encontrato", "error");
                    } else {
                        $("#result_pdv").html(result);
                        $(".modal-novo-colaborador").modal('hide');
                    }
                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
    </script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/bootstrap-tagsinput/dist/bootstrap-tagsinput.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/select2/dist/js/select2.full.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/advanced-form-element.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/pdvs.blade.php ENDPATH**/ ?>