<?php $__env->startSection('titulo', 'Entrar na Musa Ticket | Acesse sua Conta e Gerencie seus Ingressos'); ?>
<?php $__env->startSection('description','Faça login na Musa Ticket e acompanhe seus pedidos, baixe seus ingressos e fique por dentro dos próximos eventos. Acesso rápido e seguro.'); ?>
<?php $__env->startSection('url',route('login')); ?>
<?php $__env->startSection('image',url('site/images/favicon.png')); ?>
<?php $__env->startSection('content'); ?>
<div id="wrapper">
    <div class="auth py-5">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-lg-7 col-md-9 col-sm-11 mx-auto">
                    <div class="card">
                        <div class="card-body p-sm-5">
                            <h4><span class="text-primary">Login</span></h4>
                            <p class="fs-6">Informe abaixo seu e-mail e senha.</p>
                            <?php if(session('status')): ?>
                                <div class="alert alert-success">
                                    <strong><?php echo e(session('status')); ?></strong>
                                </div>
                            <?php endif; ?>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul class="mb-0">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><strong><?php echo e($error); ?></strong></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label for="username" class="form-label fw-medium">E-mail</label>
                                    <input name="email" type="text" id="username" class="form-control">
                                </div>
                                <div class="mb-2">
                                    <label for="password" class="form-label fw-medium">Senha</label>
                                    <input name="password" type="password" id="password" class="form-control"></div>
                                <div class="mb-4 text-end">
                                    <a href="<?php echo e(route('password.request')); ?>" class="link-primary fw-medium">Esqueceu a senha?</a>
                                </div>
                                <div class="mb-5">
                                    <input id="btnLogin" type="submit" class="btn btn-primary w-100" value="Login">
                                </div>
                                <p>Não possui uma conta? <br><a href="<?php echo e(route('register')); ?>" class="fw-medium external">Cadastre-se!</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const formDados = document.getElementById('loginForm');
        const botaoDados = document.getElementById('btnLogin');

        formDados.addEventListener('submit', function() {
            botaoDados.disabled = true;
            botaoDados.value = 'Processando...'; // Use `.value` para <input type="submit">
        });
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\DUNNA\Versão O Ingresso\resources\views/auth/login.blade.php ENDPATH**/ ?>