<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('content'); ?>
<div class="content-wrapper" style="min-height: 592px;">
    <div class="container-full">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="d-flex align-items-center">
                <div class="me-auto">
                    <h3 class="page-title">Pacotes evento: <?php echo e($evento->titulo); ?></h3>
                </div>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">

            <div class="row">
                <div class="col-12 col-lg-8">
                    <div class="box">
                        <div class="box-header bg-primary">
                            <h4 class="box-title">Pacotes disponíveis(<?php echo e(count($evento->Pacotes)); ?>)</h4>
                        </div>

                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table product-overview">
                                    <thead>
                                        <tr>
                                            <th>Descrição</th>
                                            <th>Preço</th>
                                            <th>Quantidade</th>
                                            <th>Vendidos</th>
                                            <th style="text-align:center">Total</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_pacotes">
                                        <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="pacote<?php echo e($pacote->id); ?>">
                                            <td>
                                                <h5><?php echo e($pacote->nome); ?></h5>
                                            </td>
                                            <td>R$ <?php echo e(moeda($pacote->preco)); ?></td>
                                            <td><?php echo e($pacote->qtd); ?></td>
                                            <td>0</td>
                                            <td>R$ 0,00</td>
                                            <td align="center">
                                                <a onclick="javascript:Remover(<?php echo e($pacote->id); ?>)" href="javascript:void(0)" class="btn btn-circle btn-danger btn-xs" title="" data-bs-toggle="tooltip" data-bs-original-title="Delete"><i class="ti-trash"></i></a>
                                                <a href="javascript:void(0)" class="btn btn-circle btn-primary btn-xs" title="" data-bs-toggle="tooltip" data-bs-original-title="Delete"><i class="ti-pencil"></i></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <button class="btn btn-success pull-right" data-bs-toggle="modal" data-bs-target="#novo-pacote"><i class="fa fa-plus"></i> Novo Pacote</button>
                                <button class="btn btn-info"><i class="fa fa-arrow-left"></i> </button>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-12 col-lg-4">
                    <div class="box">
                        <div class="box-header bg-success">
                            <h4 class="box-title">Discount</h4>
                        </div>
                        <div class="box-body">
                            <p>If you have any discount vouchers/coupans, apply here. If you don't have any, click <a href="javascript:void(0);" class="text-link">here</a> to get one.</p>
                            <form class="mt-20 form-inline">
                                <div class="input-group w-p100">
                                    <input type="text" class="form-control">
                                    <button type="button" class="btn btn-danger">Apply</button>
                                    <!-- /btn-group -->
                                </div>
                            </form>

                        </div>
                    </div>

                    <div class="box">
                        <div class="box-header bg-info">
                            <h4 class="box-title">Cart Summary</h4>
                        </div>

                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table mb-0 simple">
                                    <tbody>
                                        <tr>
                                            <td>Total</td>
                                            <td class="text-end fw-700">$3240</td>
                                        </tr>
                                        <tr>
                                            <td>Coupan Discount</td>
                                            <td class="text-end fw-700"><span class="text-danger me-15">50%</span>-$1620
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Delivery Charges</td>
                                            <td class="text-end fw-700">$50</td>
                                        </tr>
                                        <tr>
                                            <td>Tax</td>
                                            <td class="text-end fw-700">$18</td>
                                        </tr>
                                        <tr>
                                            <th class="bt-1">Payable Amount</th>
                                            <th class="bt-1 text-end fw-900 fs-18">$1688</th>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="box-footer">
                            <button class="btn btn-danger">Cancel Order</button>
                            <button class="btn btn-primary pull-right">Place Order</button>
                        </div>
                    </div>

                    <div class="box">
                        <div class="box-header bg-dark">
                            <h4 class="box-title">Support</h4>
                        </div>

                        <div class="box-body">
                            <h4 class="fw-500"><i class="ti-mobile"></i> +1800 123 1234 <span class="text-info">(Toll
                                    Free)</span></h4>
                            <p>Contact us for any queries. We are avalible 24x7x365.</p>
                        </div>
                    </div>

                </div>

            </div>

        </section>
        <!-- /.content -->
    </div>
</div>
<div class="modal center-modal fade" id="novo-pacote" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Pacote</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="fw-700 fs-16 form-label">Status</label>
                            <div class="radio-list">
                                <label class="p-0 radio-inline me-10">
                                    <div class="radio radio-info">
                                        <input id="statuss" type="radio" value="Ativo" checked name="status">
                                        <label for="statuss">Ativo</label>
                                    </div>
                                </label>
                                <label class="radio-inline">
                                    <div class="radio radio-info">
                                        <input id="statusn" type="radio" value="Inativo" name="status">
                                        <label for="statusn">Inativo</label>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="fw-700 fs-16 form-label">Data/Hora Início</label>
                            <input id="data_inicio" value="<?php echo e(old('data_inicio')); ?>" type="text" class="form-control date-time">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="fw-700 fs-16 form-label">Data/Hora Final</label>
                            <input id="data_fim" value="<?php echo e(old('data_fim')); ?>" type="text" class="form-control date-time">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">Abreviação</label>
                            <input type="text" id="sigla" class="form-control" placeholder="Abreviação">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">Nome</label>
                            <input type="text" id="nome" class="form-control" placeholder="Nome">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">Preço</label>
                            <input type="text" id="preco" class="form-control preco" placeholder="Preço">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">Quantidade</label>
                            <input type="text" id="qtd" class="form-control" placeholder="Quantidade">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-uniform">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary float-end" onclick="javascript:PacoteStore()">Adicionar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal center-modal fade" id="novo-grupo" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Grupo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">Titulo</label>
                            <input type="text" id="grupo_titulo" class="form-control" placeholder="Titulo">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-uniform">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary float-end" onclick="javascript:GrupoStore()">Adicionar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="<?php echo e(url('adm')); ?>/assets/vendor_components/formatter/formatter.js"></script>
<script src="<?php echo e(url('adm')); ?>/assets/vendor_components/formatter/jquery.formatter.js"></script>
<script src="<?php echo e(url('adm')); ?>/src/js/pages/formatter.js"></script>
<script>
    const inputsValores = document.querySelectorAll('.preco');
        inputsValores.forEach(function(inputValor) {
            inputValor.addEventListener('keyup', function(event) {
                // Pega o valor do input e remove tudo que não é número
                let valor = inputValor.value.replace(/\D/g, '');

                // Formata o valor como dinheiro
                valor = (valor / 100).toLocaleString('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                });

                // Atualiza o valor no input
                inputValor.value = valor;
            });
        });

        function PacoteStore() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.store')); ?>",
                method: 'POST',
                data: {
                    evento_id: <?php echo e($evento->id); ?>,
                    grupo_id: $("#grupo_id").val(),
                    sigla: $("#sigla").val(),
                    nome: $("#nome").val(),
                    preco: $("#preco").val(),
                    qtd: $("#qtd").val(),
                    status: $("input[name='status']:checked").val(),
                    data_inicio: $("#data_inicio").val(),
                    data_fim: $("#data_fim").val(),
                },
                success: function(result) {
                    $("#novo-pacote").modal('hide');
                    $("#result_pacotes").html(result);
                }
            });
        }

        function GrupoStore() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('grupo.store')); ?>",
                method: 'POST',
                data: {
                    evento_id: <?php echo e($evento->id); ?>,
                    titulo: $("#grupo_titulo").val(),
                },
                success: function(result) {
                    $("#novo-grupo").modal('hide');
                    $("#grupo_id").html(result);
                    $("#novo-pacote").modal('show');
                }
            });
        }

        $("#grupo_id").change(function(){
            if($("#grupo_id").val() == 'add'){
                $("#novo-pacote").modal('hide');
                $("#novo-grupo").modal('show');
            }
        });

        function Remover(id){
            swal({
            title: "Atenção",
            text: "Você deseja remover este pacote?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sim",
            cancelButtonText: "Não",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm){
            if (isConfirm) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('pacote.destroy')); ?>",
                    method: 'POST',
                    data: {
                       id
                    },
                    success: function(result) {
                        if(result == 1){
                            swal("Erro", "O pacote não pode ser removido", "error");
                        }else{
                            $("#pacote"+id).hide();
                            swal("Removido", "Pacote removido com sucesso", "success");
                        }
                    }
                });
            } else {
                swal("Cancelado", "Nenhum pacote foi removido", "error");
            }
        });
        }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\Sollares2\resources\views/admin/eventos/pacotes.blade.php ENDPATH**/ ?>