<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('url', route('site.evento', [$evento->url, $evento->id])); ?>
<?php $__env->startSection('description', lmword($evento->descricao, 180)); ?>
<?php $__env->startSection('image', $evento->banner); ?>
<?php $__env->startSection('analytics', $evento->analytics); ?>
<?php $__env->startSection('ads', $evento->ads); ?>
<?php $__env->startSection('pixel', $evento->pixel ?? env('PIXEL')); ?>
<?php $__env->startSection('application_ld_json'); ?>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Event",
        "name": "<?php echo e($evento->titulo); ?>",
        "startDate": "<?php echo e(\Carbon\Carbon::parse($evento->data_inicio)->toIso8601String()); ?>",
        "endDate": "<?php echo e(\Carbon\Carbon::parse($evento->data_fim)->toIso8601String()); ?>",
        "eventAttendanceMode": "https://schema.org/OfflineEventAttendanceMode",
        "eventStatus": "https://schema.org/EventScheduled",
        "location": {
          "@type": "Place",
          "name": "<?php echo e($evento->local); ?>",
          "address": {
            "@type": "PostalAddress",
            "streetAddress": "<?php echo e($evento->endereco_site); ?>",
            "addressLocality": "<?php echo e($evento->cidade); ?>",
            "addressRegion": "<?php echo e($evento->estado); ?>",
            "addressCountry": "BR"
          }
        },
        "organizer": {
          "@type": "Organization",
          "name": "Musa Ticket",
          "url": "https://musaticket.com.br"
        },
        "image": [
          "<?php echo e($evento->banner); ?>"
        ],
        "description": <?php echo json_encode(strip_tags($evento->descricao)); ?>,
        "offers": {
          "@type": "Offer",
          "url": "<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>",
          "price": "<?php echo e(moeda2($evento->Pacotes->first()?->preco)); ?>",
          "priceCurrency": "BRL",
          "availability": "https://schema.org/InStock",
          "validFrom": "<?php echo e(\Carbon\Carbon::parse($evento->Pacotes->first()?->data_inicio ?? $evento->data_inicio)->toIso8601String()); ?>"
        },
        "performer": {
          "@type": "PerformingGroup",
          "name": "<?php echo e($evento->artistas ?? 'Atrações confirmadas'); ?>"
        }
      }
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="p-0">
        <div class="event-header d-none d-lg-flex">
            <div class="event-banner-block">
                <div class="bg-section">
                    <div class="bg-wrapper">
                        <div class="img-event-blur"
                            style="background-image: -webkit-linear-gradient(270deg,rgba(0,0,0,.2),rgba(0,0,0,.2)) , url(<?php echo e($evento->banner); ?>);
                        background-image: linear-gradient(180deg,rgba(0,0,0,.2),rgba(0,0,0,.2)) , url(<?php echo e($evento->banner); ?>);">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner-section">
            <img src="<?php echo e($evento->banner); ?>" class="banner-img">
        </div>
        <div>
            <div class="container">
                <div class="row pt-4  pt-lg-6">
                    <div class="col-sm-12 d-block d-lg-none">
                        <h3 class="mb-3 event-title">
                            <?php echo e($evento->titulo); ?>

                        </h3>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="text-muted event-info">
                                    <p style="margin-bottom:5px">
                                        <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                                    </p>
                                    <p>
                                        <i class="far fa-calendar-alt mr-1"></i>
                                        <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?>

                                        às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                        até
                                        <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às
                                        <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sidebar content -->
                    <div class="col-lg-4 order-lg-2 mb-4 mb-lg-0">
                        <div data-toggle="sticky" data-settings="{'parent': '#content', 'top': 10, 'breakpoint': 992}">
                            <div class="row">
                                <div class="col-md-12">
                                    <form method="POST" action="<?php echo e(route('site.checkout', [$evento->url, $evento->id])); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="">
                                            <table class="table table-tickets scroll-sm-hidden">
                                                <thead>
                                                    <tr class="header">
                                                        <th colspan="2">
                                                            Ingressos
                                                            <div style="float: right;">
                                                                <i class="fas fa-shopping-cart"></i> <span class="cart_total">R$ 0,00</span>
                                                            </div>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $hoje = now(); // Data atual
                                                        $cupomSessao = session('cupom'); // ['evento_id'=>..., 'cupom'=>..., 'desconto'=>...]
                                                    ?>

                                                    <?php $__currentLoopData = $evento->Pacotes->where('status', 'Ativo'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            // Datas do pacote
                                                            $dataInicio = \Carbon\Carbon::parse($pacote->data_inicio);
                                                            $dataFim = \Carbon\Carbon::parse($pacote->data_fim);

                                                            // Estoque
                                                            $ingressosVendidos = $pacote->Ingressos->where('status', '1')->count();
                                                            $ingressosRestantes = max(0, (int) $pacote->qtd - $ingressosVendidos);

                                                            // Flags de cupom
                                                            $permiteCupom = (int) ($pacote->permitir_cupom ?? 1) === 1; // novo
                                                            $temCupomEvento = $cupomSessao && isset($cupomSessao['evento_id']) && (int) $cupomSessao['evento_id'] === (int) $evento->id;
                                                            $temCupomValido = $temCupomEvento && $permiteCupom; // cupom só vale se o pacote permitir

                                                            // Preços
                                                            $precoOriginal = (float) ($pacote->preco ?? 0);
                                                            $precoComDesconto = $precoOriginal;
                                                            $taxa = 0.0;
                                                            $precoFinal = $precoOriginal;

                                                            if ($precoOriginal > 0) {
                                                                if ($temCupomValido) {
                                                                    $desconto = (float) porcentagem($cupomSessao['desconto'] ?? 0, $precoOriginal);
                                                                    $precoComDesconto = max(0, $precoOriginal - $desconto);
                                                                    $taxa = (float) porcentagem($evento->taxa_servico ?? 0, $precoComDesconto);
                                                                    $precoFinal = $precoComDesconto + $taxa;
                                                                } else {
                                                                    $taxa = (float) porcentagem($evento->taxa_servico ?? 0, $precoOriginal);
                                                                    $precoFinal = $precoOriginal + $taxa;
                                                                }
                                                            }

                                                            // Exibir apenas tipos válidos
                                                            $mostrarPacote = false;
                                                            if (($pacote->tipo ?? '') === 'Gratuito' && $precoOriginal == 0) {
                                                                $mostrarPacote = true;
                                                            }
                                                            if (($pacote->tipo ?? '') === 'Público' && $precoOriginal > 0) {
                                                                $mostrarPacote = true;
                                                            }
                                                            if (!$mostrarPacote) {
                                                                continue;
                                                            }
                                                        ?>

                                                        <?php if($hoje->between($dataInicio, $dataFim)): ?>
                                                            <tr>
                                                                <td>
                                                                    <span class="ticket-type" style="<?php echo e($ingressosRestantes <= 0 ? 'text-decoration: line-through;' : ''); ?>">
                                                                        <?php echo e($pacote->nome); ?>

                                                                    </span>
                                                                    <br>

                                                                    
                                                                    <?php if(($pacote->tipo ?? '') === 'Público'): ?>
                                                                        <span class="ticket-amount">
                                                                            <?php if($temCupomValido): ?>
                                                                                <span style="text-decoration: line-through; color: lightgray;">
                                                                                    R$ <?php echo e(moeda($precoOriginal)); ?>

                                                                                </span>
                                                                                &nbsp;
                                                                                <span style="font-weight: bold; color: #000;">
                                                                                    R$ <?php echo e(moeda($precoComDesconto)); ?>

                                                                                </span>
                                                                            <?php else: ?>
                                                                                R$ <?php echo e(moeda($precoOriginal)); ?>

                                                                            <?php endif; ?>

                                                                            <?php if(($evento->taxa_servico ?? 0) > 0 && $taxa > 0): ?>
                                                                                (+ R$ <?php echo e(moeda($taxa)); ?> taxa)
                                                                            <?php endif; ?>
                                                                        </span>
                                                                    <?php elseif(($pacote->tipo ?? '') === 'Gratuito'): ?>
                                                                        <span class="ticket-amount" style="color:green; font-weight:bold;">
                                                                            Ingresso gratuito
                                                                        </span>
                                                                    <?php endif; ?>

                                                                    <br>
                                                                    <span class="ticket-notes">
                                                                        <?php
                                                                            $diffEmSegundos = $hoje->diffInSeconds($dataFim, false);
                                                                        ?>

                                                                        <?php if($ingressosRestantes <= 10): ?>
                                                                            <?php if($ingressosRestantes > 0): ?>
                                                                                <span style="color:red"><strong>Restam apenas <?php echo e($ingressosRestantes); ?> ingressos</strong></span>
                                                                            <?php endif; ?>
                                                                        <?php else: ?>
                                                                            <?php if($diffEmSegundos > 0 && $diffEmSegundos < 43200): ?>
                                                                                <?php
                                                                                    $horas = floor($diffEmSegundos / 3600);
                                                                                    $minutos = floor(($diffEmSegundos % 3600) / 60);
                                                                                ?>
                                                                                <span style="color:red"><strong>Virada de lote em <?php echo e($horas); ?>h <?php echo e($minutos); ?>min</strong></span>
                                                                            <?php else: ?>
                                                                                Vendas até <?php echo e($dataFim->format('d/m/Y')); ?> às <?php echo e($dataFim->format('H:i')); ?>

                                                                            <?php endif; ?>
                                                                        <?php endif; ?>
                                                                    </span>
                                                                </td>

                                                                <td class="qtd-panel">
                                                                    <?php if($ingressosRestantes <= 0): ?>
                                                                        <span style="color: red; font-weight: bold;">Esgotado</span>
                                                                    <?php else: ?>
                                                                        <input type="hidden" name="form-<?php echo e($k); ?>-id" value="<?php echo e($pacote->id); ?>">
                                                                        
                                                                        <input type="hidden" name="form-<?php echo e($k); ?>-codigo_promocional" value="<?php echo e($temCupomValido ? $cupomSessao['cupom'] ?? '' : ''); ?>">
                                                                        <input type="hidden" name="form-<?php echo e($k); ?>-qtd" value="0" id="id_form-<?php echo e($k); ?>-qtd">

                                                                        <a class="btn-operator" href="javascript:;" onclick="minus('id_form-<?php echo e($k); ?>-qtd')">
                                                                            <i class="fas fa-minus-circle"></i>
                                                                        </a>
                                                                        <span id="qty_label-id_form-<?php echo e($k); ?>-qtd" class="number opt-plus"
                                                                            data-available="<?php echo e($ingressosRestantes <= 5 ? $ingressosRestantes : $pacote->qtd_maxima_compra ?? $ingressosRestantes); ?>" data-min-qty="1"
                                                                            data-total="<?php echo e(($pacote->tipo ?? '') === 'Público' ? moeda($precoFinal) : 0); ?>">
                                                                            0
                                                                        </span>
                                                                        <a class="btn-operator" href="javascript:;" onclick="plus('id_form-<?php echo e($k); ?>-qtd')">
                                                                            <i class="fas fa-plus-circle"></i>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>

                                                <tfoot>
                                                    <?php if(empty($cupomSessao)): ?>
                                                        <tr class="linkAplicarCodigo">
                                                            <td colspan="2" class="text-center">
                                                                <a href="javascript:;" onclick="showDiscountPanel()" style="font-size: 14px;">Aplicar código promocional</a>
                                                            </td>
                                                        </tr>
                                                    <?php else: ?>
                                                        <?php if($cupomSessao['desconto'] > 0): ?>
                                                            <tr class="linkAplicarCodigo">
                                                                <td colspan="2" class="text-center">
                                                                    <strong style="color: #468C00; font-size: 20px;">
                                                                        <?php echo e($cupomSessao['cupom'] ?? 'CUPOM'); ?> <?php echo e($cupomSessao['desconto'] ?? 0); ?>%
                                                                    </strong>
                                                                </td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    <tr class="trInputCodigo" style="display: none">
                                                        <td colspan="2" class="text-center">
                                                            <div class="input-group">
                                                                <input type="text" id="codigo_desconto" value="" class="form-control input-codigo-promocional" placeholder="código" aria-describedby="btnAplicar" autocomplete="off">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-outline-primary" onclick="AplicarDesconto();" type="button">Aplicar</button>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">
                                                            <p class="text-center table-cart-total" style="display: none;">
                                                                <small class="text-muted">Total:</small> <span class="cart_total cart_total_label">R$ 0,00</span>
                                                                <br>
                                                                
                                                            </p>
                                                            <?php
                                                                $dataAtual = now();
                                                                $vendasEncerradasPorData = $evento->data_fim < $dataAtual;
                                                                $pacotesAtivos = $evento->Pacotes->where('status', 'Ativo');
                                                                $todosIndisponíveis = $pacotesAtivos->every(function ($pacote) use ($dataAtual) {
                                                                    $dataInicio = \Carbon\Carbon::parse($pacote->data_inicio);
                                                                    $dataFim = \Carbon\Carbon::parse($pacote->data_fim);
                                                                    $ingressosVendidos = $pacote->Ingressos->where('status', '1')->count();
                                                                    $ingressosRestantes = $pacote->qtd - $ingressosVendidos;
                                                                    return !($dataAtual->between($dataInicio, $dataFim) && $ingressosRestantes > 0);
                                                                });
                                                                $vendasEncerradasPorEstoque = !$vendasEncerradasPorData && $todosIndisponíveis;
                                                            ?>
                                                            <?php if($vendasEncerradasPorData): ?>
                                                                <input type="button" name="acao" value="Vendas Encerradas" class="btn btn-lg btn-block btn-danger btn-comprar">
                                                            <?php elseif($vendasEncerradasPorEstoque): ?>
                                                                <input type="button" name="acao" value="Ingressos Esgotados" class="btn btn-lg btn-block btn-danger btn-comprar">
                                                            <?php else: ?>
                                                                <?php if(Auth::check()): ?>
                                                                    <input type="submit" name="acao" value="Comprar Ingressos" class="btn btn-lg btn-block btn-success btn-comprar">
                                                                <?php else: ?>
                                                                    <input type="button" id="LoginCheckout" name="acao" value="Comprar Ingressos" class="btn btn-lg btn-block btn-success btn-comprar">
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Main content -->
                    <div class="col-lg-8 pull-lg-3 mb-3">
                        <div class="d-none d-lg-block">
                            <h3 class="mb-3 event-title">
                                <?php echo e($evento->titulo); ?>

                            </h3>
                            <div class="row">
                                <div class="col-md-12">
                                    
                                    <p class="event-info">
                                        <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                                        <i class="far fa-calendar-alt mr-1"></i>
                                        <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>,
                                        <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                        até
                                        <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às
                                        <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                                    </p>
                                </div>
                            </div>
                            <hr>
                        </div>

                        <div class="event-share d-block d-lg-none">
                            
                        </div>
                        <h4 class="mt-2 text-muted"><span>Descrição do evento</span></h4>
                        <div class="text-img-fluid">
                            <?php echo $evento->descricao; ?>

                            <p>🔍 <strong>Alinhando expectativas:</strong><br>
                                👥 <strong>Público-alvo:</strong> <?php echo e($evento->publico_alvo); ?><br>
                                🎵 <strong>Gêneros musicais:</strong> <?php echo e($evento->genero); ?><br>
                                📼 <strong>Tema:</strong> <?php echo e($evento->tema); ?><br>
                                🎬 <strong>Produtora:</strong> <?php echo e($evento->produtora); ?>

                            </p>
                        </div>

                        <h4 class="mt-5 text-muted"><span>Política do evento</span></h4>
                        <h5>Cancelamento de pedidos pagos</h5>
                        <p>
                            Cancelamentos de pedidos serão aceitos em até 7 dias após a compra, desde que a solicitação seja feita com no mínimo 48 horas de antecedência ao início do evento.
                            <br>
                            <span style="color: #d60404; font-weight: bold;">Compras efetuadas no dia do evento ou nas 48 horas que o antecedem não são elegíveis para cancelamento.</span>
                            <br>
                            <?php
                                $dataEvento = \Carbon\Carbon::parse($evento->data_inicio);
                                $podeCancelar = now()->diffInHours($dataEvento, false) > 48;
                            ?>
                            <a href="javascript:void(0)" onclick="verificarCancelamento()"><strong>Solicitar Cancelamento</strong></a>
                        </p>
                        <br>
                        <h5>Edição de participantes</h5>
                        <p>
                            Você poderá editar o participante de um ingresso apenas uma vez. Essa opção ficará disponível até 24 horas antes do início do evento.
                            <br>
                            <a href="<?php echo e(route('cliente.ingressos')); ?>"><strong>Editar participantes</strong></a>
                        </p>
                        <p><strong>Proibido para menores de 18 anos</strong></p>


                        <h4 class="mt-5 text-muted"><span>Local</span></h4>
                        <h5><?php echo e($evento->local); ?></h5>
                        <div class="event-address"><i class="fa fa-map-marker-alt mr-1"></i> <?php echo e($evento->endereco_site); ?></div>
                        <p>
                            <a href="https://www.google.com/maps/search/<?php echo e($evento->endereco_site); ?>" target="_blank" class="mb-1 btn btn-lg btn-outline-primary btn-rounded mt-2" role="button" aria-pressed="true">
                                Ver Mapa
                            </a>
                        </p>

                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="modal fade" id="ModalLoginCheckout" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document"> <!-- Modal Grande -->
            <div class="modal-content">
                <div class="modal-body">
                    <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="<?php echo e(route('login')); ?>" style="background: #FFF">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="evento" value="<?php echo e(request()->url()); ?>">
                        <h3 class="title-divider"><span>Login</span></h3>
                        <p class="text-muted text-center">Informe abaixo seu e-mail e senha.</p>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control email" placeholder="Email" required="required">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" class="form-control password" placeholder="Senha" required="required">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <button type="submit" id="loginBtn" class="btn btn-primary btn-lg btn-block">Login</button>
                        <p class="text-center mt-2">
                            <small><a href="javascript:;" onclick="$('#loginModal').modal('hide'); $('#recoverPasswordModal').modal('show');">Esqueceu sua senha?</a></small>
                        </p>
                        <p class="text-center">
                            Não possui uma conta? <a href="<?php echo e(route('register')); ?>">Cadastre-se!</a>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <style>
        #ModalLoginCheckout .modal-content {
            background: transparent;
            border: none;
            /* Remove a borda padrão */
            box-shadow: none;
            /* Remove sombras, se necessário */
        }

        #ModalLoginCheckout .modal-body {
            background: transparent;
            /* Também pode ser ajustado se houver outros elementos */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.6.0/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.6.0/dist/sweetalert2.min.js"></script>

    <script>
        $('#LoginCheckout').click(function(event) {
            event.preventDefault();
            $("#ModalLoginCheckout").modal('show');
        });

        $(document).ready(function() {
            // Verifica se há erros ao carregar a página
            <?php if($errors->has('email') || $errors->has('password')): ?>
                $("#ModalLoginCheckout").modal('show');
            <?php endif; ?>

            <?php if($errors->has('error_qtd')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: "<?php echo e($errors->first('error_qtd')); ?>",
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>

            <?php if($errors->has('error_cpf')): ?>
                Swal.fire({
                    title: 'Erro!',
                    html: 'Seu CPF é inválido.<br>Deseja atualizar seu cadastro agora?',
                    icon: 'error',
                    showCancelButton: true,
                    confirmButtonText: 'Atualizar Cadastro',
                    cancelButtonText: 'Cancelar',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Redireciona para o link de atualização do cadastro
                        window.location.href = '<?php echo e(route('minha.conta')); ?>';
                    }
                });
            <?php endif; ?>

        });

        function AplicarDesconto() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('cupom.store')); ?>",
                method: 'POST',
                data: {
                    evento_id: <?php echo e($evento->id); ?>,
                    cupom: $("#codigo_desconto").val()
                },

                success: function(result) {
                    if (result == 'error') {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: "Cupom de desconto inválido",
                            confirmButtonText: 'OK'
                        });
                    } else {
                        showSuccessAlert();
                    }
                },
            });
        }

        function showSuccessAlert() {
            let timerInterval;
            Swal.fire({
                title: "Cupom Confirmado",
                html: "Carregando seus descontos... <b></b>",
                timer: 1000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                    location.reload();
                }
            });
        }

        function verificarCancelamento() {
            const podeCancelar = <?php echo e($podeCancelar ? 'true' : 'false'); ?>;

            if (!podeCancelar) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Cancelamento não permitido',
                    text: 'O cancelamento só pode ser solicitado com no mínimo 48 horas de antecedência ao início do evento.',
                    confirmButtonText: 'Entendi',
                });
            } else {
                window.location.href = "https://api.whatsapp.com/send?1=pt_BR&phone=55<?php echo e(setUri2(env('WHATSAPP'))); ?>&text=Olá eu gostaria de cancelar um ingresso."
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendas.base-pg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\DUNNA\Versão O Ingresso\resources\views/vendas/evento.blade.php ENDPATH**/ ?>