<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('content'); ?>
<div class="content-wrapper" style="min-height: 589px;">
    <div class="container-full">
        <section class="content">
            <a href="javascript:void(0)" onclick="javascript:Remover(<?php echo e($evento->id); ?>)" class="mb-5 waves-effect waves-light btn btn-danger pull-right">Excluir Evento</a>
            <div class="row">
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="box">
                        <div class="box-body">
                            <h4 class="mt-0 fw-500">Total de Vendas</h4>
                            <div class="d-flex align-items-center justify-content-between">
                                <h2 class="my-0 fw-600"><i class="fa fa-money"></i> R$ 999.999,99</h2>
                                <h4 class="my-0 fw-500 text-success"> +15%</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-3 col-12">
                    <div class="box">
                        <div class="box-header">
                            <h4 class="box-title">Acessos do Evento</h4>
                        </div>
                        <div class="box-body" style="position: relative;">
                            <div id="acesso_evento" style="min-height: 218.7px;"></div>
                            <div class="d-flex align-items-center justify-content-between">
                                <h5 class="my-0 fw-500"><span class="me-10 badge badge-xl badge-dot" style="background-color:#7047EE"></span> Vendidos</h5>
                                <h5 class="my-0 fw-500"><span class="me-10 badge badge-xl badge-dot badge-primary-light"></span> Validados</h5>
                            </div>
                            <div class="resize-triggers">
                                <div class="expand-trigger">
                                    <div style="width: 435px; height: 281px;"></div>
                                </div>
                                <div class="contract-trigger"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-12">
                    <div class="box">
                        <div class="box-header">
                            <h4 class="box-title">Acessos por Áreas</h4>
                        </div>
                        <div class="box-body" style="position: relative;">
                            <div id="vendas_por_area"></div>
                            <div class="mt-10 d-flex align-items-center justify-content-between">
                                <h5 class="my-0 fw-500"><span class="me-10 badge badge-xl badge-dot badge-info"></span> Vendidos</h5>
                                <h5 class="my-0 fw-500"><span class="me-10 badge badge-xl badge-dot badge-info-light"></span> Validados</h5>
                            </div>
                            <div class="resize-triggers">
                                <div class="expand-trigger">
                                    <div style="width: 892px; height: 281px;"></div>
                                </div>
                                <div class="contract-trigger"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-12">
                    <div class="box">
                        <div class="box-header">
                            <h4 class="box-title">Total Ingressos</h4>
                        </div>
                        <?php
                        $estilos = ['danger', 'success', 'warning', 'info']; // Define os estilos disponíveis
                        ?>
                        <div class="box-body">
                            <div class="py-10 overflow-hidden d-flex w-p100 rounded100">
                                <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $estilo = $estilos[$index % 4]; // Pega um estilo do array baseado no índice do loop
                                ?>
                                <div class="h-10 bg-<?php echo e($estilo); ?>" style="width: 25%;"></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="p-0 box-body">
                            <div class="media-list media-list-hover media-list-divided">
                                <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $estilo = $estilos[$index % 4]; // Pega um estilo do array baseado no índice do loop
                                ?>
                                <a class="media media-single rounded-0" href="#">
                                    <span class="badge badge-xl badge-dot badge-<?php echo e($estilo); ?>"></span>
                                    <span class="title"><?php echo e($pacote->nome); ?> </span>
                                    <span class="badge badge-pill badge-<?php echo e($estilo); ?>-light">58%</span>
                                </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12 col-12">
                    <div class="box">
                        <div class="box-header">
                            <h4 class="box-title">Vendas Mensal</h4>
                        </div>
                        <div class="box-body" style="position: relative;">
                            <div id="vendas_meses" style="min-height: 243px;"></div>
                            <div class="resize-triggers">
                                <div class="expand-trigger">
                                    <div style="width: 892px; height: 286px;"></div>
                                </div>
                                <div class="contract-trigger"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
    var options = {
          series: [8, 2],
          chart: {
          type: 'donut',
			 height: 240,
			  width: 240,
        },
		legend: {
      		show: false,
		},
		dataLabels: {
			enabled: false,
		  },
		plotOptions: {
			pie: {
			  customScale: 0.90,
			  donut: {
				size: '80%',
				  labels: {
					show: true,
					total: {
					  showAlways: true,
					  show: true,
					}
				  }
			  },
			  offsetY: 0,
			},
			stroke: {
			  colors: undefined
			}
		  },
		colors:['#7047EE', '#e8e1ff'],
        };

        var chart = new ApexCharts(document.querySelector("#acesso_evento"), options);
        chart.render();



        var analyticsBarChartOptions = {
		chart: {
		  height: 194,
		  type: 'bar',
		  toolbar: {
			show: false
		  }
		},
		plotOptions: {
		  bar: {
			horizontal: false,
			columnWidth: '40%',
			borderRadius: 3
		  },
		},
		dataLabels: {
		  enabled: false
		},
		colors: ['#3596f7', '#cce5ff'],
		series: [{
		  name: 'Vendidos',
		  data: [
            <?php for($i=0;$i<count($evento->Pacotes);$i++): ?>
                '<?php echo e($i+750); ?>',
            <?php endfor; ?>
          ]
		}, {
		  name: 'Validados',
		  data: [
            <?php for($i=0;$i<count($evento->Pacotes);$i++): ?>
                '<?php echo e($i+500); ?>',
            <?php endfor; ?>
          ]
		}],
		xaxis: {
		  categories: [
            <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e($pacote->sigla); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ],
		  axisBorder: {
			show: false
		  },
		  axisTicks: {
			show: false
		  },
		  labels: {
			style: {
			  colors: '#333333'
			}
		  }
		},
		yaxis: {
		  min: 0,
		  max: 1000,
		  tickAmount: 3,
		  labels: {
			style: {
			  color: '#333333'
			}
		  }
		},
		legend: {
		  show: false,
		},
	  }

	  var analyticsBarChart = new ApexCharts(
		document.querySelector("#vendas_por_area"),
		analyticsBarChartOptions
	  );

	  analyticsBarChart.render();


      var analyticsBarChartOptions = {
		chart: {
			height: 228,
			type: 'bar',
			toolbar: {
			show: true
		  }
		},
		plotOptions: {
		  bar: {
			horizontal: false,
			columnWidth: '45%',
			borderRadius: 3
		  },
		},
		dataLabels: {
		  enabled: false
		},
		colors: ['#7047ee'],
		series: [{
		  name: 'Total de Vendas',
		  data: [1265899, 1059987, 2566699, 3588899, 4999988, 10156488, 3254888, 7584599, 4256699]
		}],
		xaxis: {
		  categories: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set'],
		  axisBorder: {
			show: false
		  },
		  axisTicks: {
			show: false
		  },
		  labels: {
			style: {
			  colors: '#333333'
			}
		  }
		},
		yaxis: {
		  min: 0,
		  max: 11000000,
		  tickAmount: 3,
		  labels: {
			style: {
			  color: '#333333'
			}
		  }
		},
		legend: {
		  show: false,
		},
		tooltip: {
		  y: {
			formatter: function (val) {
                let valorReal; // Declaração da variável fora do bloco if-else

                // Verificar o valor para aplicar a conversão correta
                if (val < 1000) {
                    valorReal = val; // Assume que o valor já está correto em reais
                } else {
                    valorReal = val / 100; // Converte de centavos para reais
                }

                // Formatar o valor como moeda
                return valorReal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
			}
		  }
		}
	  }

	  var analyticsBarChart = new ApexCharts(
		document.querySelector("#vendas_meses"),
		analyticsBarChartOptions
	  );

	  analyticsBarChart.render();


      function Remover(id){
            swal({
            title: "Atenção",
            text: "Você deseja remover este evento?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sim",
            cancelButtonText: "Não",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm){
            if (isConfirm) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('evento.destroy')); ?>",
                    method: 'POST',
                    data: {
                       id
                    },
                    success: function(result) {
                        if(result == 1){
                            swal("Erro", "O pacote não pode ser removido", "error");
                        }else{
                            $("#pacote"+id).hide();
                            swal("Removido", "Pacote removido com sucesso", "success");
                            window.location.href = '<?php echo e(route('eventos.index')); ?>';
                        }
                    }
                });
            } else {
                swal("Cancelado", "Nenhum pacote foi removido", "error");
            }
        });
        }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\Sollares2\resources\views/admin/eventos/show.blade.php ENDPATH**/ ?>