<?php $__env->startSection('titulo', 'Histórico de Transações - ' . $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info-financeira', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Hoje</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                <?php echo e(moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->isToday();
                                        })->sum('total'),
                                )); ?>

                            </p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Últimos 7 dias</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                <?php echo e(moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->greaterThanOrEqualTo(now()->subDays(7));
                                        })->sum('total'),
                                )); ?>

                            </p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Últimos 30 dias</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                <?php echo e(moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->greaterThanOrEqualTo(now()->subDays(30));
                                        })->sum('total'),
                                )); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="form-group">
                                    <label class="form-label">Filtrar por tipo de transação</label>
                                    <select class="form-select" style="width: 350px;">
                                        <option>Selecione</option>
                                        <option value="Pagamento Aprovado">Pagamento Aprovado</option>
                                        <option value="Pagamento Pendente">Pagamento Pendente</option>
                                        <option value="Pagamento Cancelados">Pagamento Cancelados</option>
                                        <option value="Adicionados Manualmente">Adicionados Manualmente</option>
                                        <option value="PDV Musa">PDV Musa</option>
                                    </select>
                                </div>
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th class="sorting">Nº DO PEDIDO</th>
                                                <th class="sorting">COMPRADOR</th>
                                                <th class="sorting">DATA DA VENDA</th>
                                                <th class="sorting">PREÇO DA VENDA</th>
                                                <th class="sorting">CUSTOS DA VENDA</th>
                                                <th class="sorting">TOTAL DA VENDA</th>
                                            </tr>
                                        </thead>
                                        <tbody id="pedidos-list">
                                            <?php echo $__env->make('admin.evento.ajax.pedidos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td>Total</td>
                                                <td>R$ <?php echo e(moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('total'))); ?></td>
                                                <td>R$ <?php echo e(moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('taxa'))); ?></td>
                                                <td>R$ <?php echo e(moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('total') + $Evento->Pedidos->where('status', 'Aprovado')->sum('taxa'))); ?></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                    <div id="loading" style="text-align: center; display: none;">
                                        <p>Carregando...</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        let page = 1; // Página inicial
        let loading = false;

        $(window).scroll(function() {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 100 && !loading) {
                page++;
                loadMoreData(page);
            }
        });

        function loadMoreData(page) {
            loading = true;
            $("#loading").show();

            $.ajax({
                url: "<?php echo e(route('historico.transacoes', $Evento)); ?>" + "?page=" + page,
                type: "GET",
                success: function(data) {
                    if (data.trim() === "") {
                        $("#loading").html("<p>Não há mais registros.</p>");
                        return;
                    }

                    $("#pedidos-list").append(data);
                    $("#loading").hide();
                    loading = false;
                },
                error: function(xhr, status, error) {
                    console.error("Erro ao carregar mais dados: ", error);
                    $("#loading").hide();
                    loading = false;
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/historico-transacoes.blade.php ENDPATH**/ ?>