<!doctype html>
<html lang="en">

<head>
      <!-- Required meta tags -->
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
      <!-- favicon -->
      <link rel="icon" type="image/png" href="<?php echo e(url('site')); ?>/assets/images/favicon.png">
      <!-- Bootstrap CSS -->
      <link rel="stylesheet" href="<?php echo e(url('site')); ?>/assets/vendors/bootstrap/css/bootstrap.min.css" media="all">
      <!-- Fonts Awesome CSS -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/fontawesome/css/all.min.css">
      <!-- jquery-ui css -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/jquery-ui/jquery-ui.min.css">
      <!-- modal video css -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/modal-video/modal-video.min.css">
      <!-- light box css -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/lightbox/dist/css/lightbox.min.css">
      <!-- slick slider css -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/slick/slick.css">
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/assets/vendors/slick/slick-theme.css">
      <!-- google fonts -->
      <link href="<?php echo e(url('site')); ?>/https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,400&amp;family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,400&amp;display=swap" rel="stylesheet">
      <!-- Custom CSS -->
      <link rel="stylesheet" type="text/css" href="<?php echo e(url('site')); ?>/style.css">
      <title><?php echo e(env('APP_NAME')); ?></title>


      <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>" />
      <meta property="og:type" content="website" />
      <meta property="og:title" content="<?php echo $__env->yieldContent('url'); ?>" />
      <meta property="og:description" content="<?php echo $__env->yieldContent('url'); ?>" />
      <meta property="og:image" content="<?php echo $__env->yieldContent('url'); ?>" />
      <meta property="og:image:width" content="200" />
      <meta property="og:image:height" content="200" />
   </head>
   <body class="home">
      <div id="siteLoader" class="site-loader">
         <div class="preloader-content">
            <img src="<?php echo e(url('site')); ?>/assets/images/loader1.gif" alt="">
         </div>
      </div>
      <div id="page" class="full-page">
         <header id="masthead" class="site-header header-primary">
            <!-- header html start -->
            <div class="top-header">
               <div class="container">
                  <div class="row">
                     <div class="col-lg-8 d-none d-lg-block">
                        <div class="header-contact-info">
                           <ul>
                              <li>
                                 <a href=""><i class="fas fa-phone-alt"></i> <?php echo e(env('WHATSAPP_VENDAS')); ?></a>
                              </li>
                              <li>
                                 <a href="mailto:<?php echo e(env('EMAIL')); ?>"><i class="fas fa-envelope"></i><?php echo e(env('EMAIL')); ?></a>
                              </li>
                              <li>
                                 <i class="fas fa-map-marker-alt"></i> <?php echo e(env('ENDERECO')); ?>

                              </li>
                           </ul>
                        </div>
                     </div>
                     <div class="col-lg-4 d-flex justify-content-lg-end justify-content-between">
                        <div class="header-social social-links">
                           <ul>
                              <li><a href=""><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
                              <li><a href=""><i class="fab fa-instagram" aria-hidden="true"></i></a></li>
                              <li><a href=""><i class="fab fa-youtube" aria-hidden="true"></i></a></li>
                           </ul>
                        </div>
                        
                     </div>
                  </div>
               </div>
            </div>
            <div class="bottom-header">
                <div class="container d-flex justify-content-between align-items-center">
                    <div class="site-identity">
                        <h1 class="site-title">
                            <a href="<?php echo e(route('site.home')); ?>">
                                <img class="white-logo" style="filter: invert(100%);" src="<?php echo e(url('site')); ?>/images/logo.png" alt="logo">
                                <img class="black-logo" style="filter: invert(100%);" src="<?php echo e(url('site')); ?>/images/logo.png" alt="logo">
                            </a>
                        </h1>
                    </div>
                    <div class="main-navigation d-none d-lg-block">
                        <nav id="navigation" class="navigation heaer-content-right pull-right">
                            <ul>
                                <li><a href="<?php echo e(route('site.home')); ?>">Home</a></li>
                                <li><a href="<?php echo e(route('site.home')); ?>">Eventos</a></li>
                                <li><a href="<?php echo e(route('site.home')); ?>">Categorias</a></li>
                                <li style="text-transform: none"><a href="javascript:void(0)"><i class="fas fa-map-marker-alt"></i> Qualquer lugar</a></li>
                            </ul>
                        </nav>
                    </div>
                    <div class="header-btn">
                        <a href="" class="m-10 rounded-20 button-primary">Login</a>
                        <a href="" class="m-10 rounded-20 button-secondary">Cadastre-se</a>
                    </div>
                </div>
            </div>
            <div class="mobile-menu-container"></div>
         </header>

         <?php echo $__env->yieldContent('content'); ?>

         <footer id="colophon" class="site-footer footer-primary">
            <div class="buttom-footer">
               <div class="container">
                  <div class="row align-items-center">
                     <div class="col-md-5">
                        <div class="footer-menu">
                           <ul>
                              <li><a href="">Politica de Privacidade</a></li>
                              <li><a href="">Termo de Uso</a></li>
                              <li><a href="">FAQ</a></li>
                           </ul>
                        </div>
                     </div>
                     <div class="text-center col-md-2">
                        <div class="footer-logo">
                           <a href=""><img style="filter: invert(100%);" src="<?php echo e(url('site')); ?>/images/logo.png"></a>
                        </div>
                     </div>
                     <div class="col-md-5">
                        <div class="text-right copy-right">Copyright © <?php echo e(date('Y')); ?> <?php echo e(env('APP_NAME')); ?>. Todos os direitos reservados.</div>
                     </div>
                  </div>
               </div>
            </div>
         </footer>
         <a id="backTotop" href="" class="to-top-icon">
            <i class="fas fa-chevron-up"></i>
         </a>
         <!-- custom search field html -->
            <div class="header-search-form">
               <div class="container">
                  <div class="header-search-container">
                     <form class="search-form" role="search" method="get" >
                        <input type="text" name="s" placeholder="Enter your text...">
                     </form>
                     <a href="" class="search-close">
                        <i class="fas fa-times"></i>
                     </a>
                  </div>
               </div>
            </div>
         <!-- header html end -->

         <div class="modal fade bs-example-modal-sm mt-100" id="EstadosShow"  tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true" style="display: none;">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="mySmallModalLabel">Selecione um estado</h4>
                        <button type="button" data-bs-dismiss="modal" aria-label="Close" style="background: none; border:none"><i class="fas fa-times"></i></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="pb-2 mb-3 menu">
                                    <div class="col-auto">
                                        <div class="form-check">
                                            <input name="estado" <?php echo e(session()->get('estado') == 'All' ? 'checked' : ''); ?>

                                                class="form-check-input estado-radio" type="radio" value="All"
                                                id="all">
                                            <label class="form-check-label" for="all">
                                                Todos os Estados
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="pb-2 mb-3 menu">
                                        <div class="col-auto">
                                            <div class="form-check">
                                                <input name="estado" <?php echo e(session()->get('estado') == $estado->nome ? 'checked' : ''); ?> class="form-check-input estado-radio" type="radio" value="<?php echo e($estado->nome); ?>" id="<?php echo e(setUri($estado->nome)); ?>">
                                                <label class="form-check-label" for="<?php echo e(setUri($estado->nome)); ?>">
                                                    <?php echo e($estado->nome); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>



      <!-- JavaScript -->
      <script src="<?php echo e(url('site')); ?>/assets/js/jquery.js"></script>
      <script src="<?php echo e(url('site')); ?>/ajax/libs/waypoints/2.0.3/waypoints.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/bootstrap/js/bootstrap.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/jquery-ui/jquery-ui.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/countdown-date-loop-counter/loopcounter.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/js/jquery.counterup.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/modal-video/jquery-modal-video.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/masonry/masonry.pkgd.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/lightbox/dist/js/lightbox.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/vendors/slick/slick.min.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/js/jquery.slicknav.js"></script>
      <script src="<?php echo e(url('site')); ?>/assets/js/custom.min.js"></script>

      <script>
        $(document).ready(function(){
            setTimeout(() => {
                $("#EstadosShowXXX").modal('show');
            }, 2000);
        });
      </script>

      <?php echo $__env->yieldContent('js'); ?>

</body>

</html>
<?php /**PATH F:\Laravel\Sollares\resources\views/site/base.blade.php ENDPATH**/ ?>