<!DOCTYPE html>
<html lang="pt">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />

<head>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-RSKJE20DT1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-RSKJE20DT1');
    </script>

    <title><?php echo $__env->yieldContent('titulo'); ?></title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow">
    <link rel="icon" href="<?php echo e(url('vendas')); ?>/images/favicon.png" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo e(url('vendas')); ?>/images/favicon.png" type="image/x-icon" />
    <link rel="apple-touch-icon" href="<?php echo e(url('vendas')); ?>/images/favicon.png">
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>" />
    <meta property="og:title" content="<?php echo $__env->yieldContent('titulo'); ?>" />
    <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>" />
    <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>" />
    <?php echo $__env->yieldContent('application_ld_json'); ?>
    <meta property="og:image" content="<?php echo $__env->yieldContent('image'); ?>" />
    <meta property="og:image:width" content="954" />
    <meta property="og:image:height" content="500" />

    <!-- Bootstrap v4.5.0 CSS via CDN -->
    <link rel="stylesheet" href="<?php echo e(url('vendas')); ?>/static/strap34/assets/css/bootstrap.min.css">
    <!-- Theme style -->
    <link href="<?php echo e(url('vendas')); ?>/static/strap34/assets/css/theme-style.css" rel="stylesheet">
    <!-- Your custom override -->
    <link href="<?php echo e(url('vendas')); ?>/static/strap34/assets/css/event-style.css?v=23" rel="stylesheet">
    <link href="<?php echo e(url('vendas')); ?>/static/css/fontawesome/6.5.2/css/all.min.css" rel="stylesheet">
    <!-- Google fonts -->
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700,300' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="<?php echo e(url('vendas')); ?>/css/style-page.css?v=<?php echo e(rand()); ?>">

    <!--jQuery 3.3.1 via CDN -->
    <script src="<?php echo e(url('vendas')); ?>/static/strap34/assets/js/jquery-3.3.1.min.js"></script>

    <!-- Google Tag Manager (Analytics e Ads) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $__env->yieldContent('analytics'); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', '<?php echo $__env->yieldContent('analytics'); ?>'); // Google Analytics ID (ex: G-XXXXXXX)
        gtag('config', '<?php echo $__env->yieldContent('ads'); ?>'); // Google Ads ID (ex: AW-YYYYYYY)
    </script>

    <!-- Facebook Pixel -->
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script', 'https://connect.facebook.net/en_US/fbevents.js');

        fbq('init', '<?php echo $__env->yieldContent('pixel'); ?>');
        fbq('track', 'PageView');
    </script>
    <noscript>
        <img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=<?php echo $__env->yieldContent('pixel'); ?>&ev=PageView&noscript=1" />
    </noscript>
    <?php echo $__env->yieldContent('css'); ?>
    <script src="https://sdk.mercadopago.com/js/v2"></script>
</head>

<body>
    <nav class="navbar navbar-expand-md navbar-dark navbar-bg-custom" style="height: 70px;">
        <div class="container-fluid justify-content-around" style="width: 1100px;">
            <div class="logo-box">
                <div class="logo-imgwrap">
                    <a href="<?php echo e(route('site.home')); ?>">
                        <img src="<?php echo e(url('vendas')); ?>/images/logo-branca.png">
                    </a>
                </div>
            </div>
            <div class="ml-auto" style="float:right">
                <?php if(Auth::check()): ?>
                    <div id="user-menu-dt" class="dropdown">
                        <a class="nav-link nav-link-text dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fa-regular fa-user mr-1"></i> <span class="user-first-name"></span> <?php echo e(Auth::user()->name); ?>

                        </a>
                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
                            <a href="<?php echo e(route('cliente.ingressos')); ?>" class="dropdown-item">Meus Ingressos</a>
                            <a href="<?php echo e(route('minha.conta')); ?>" class="dropdown-item">Minha Conta</a>
                            <a href="javascript:void(0)" onclick="javascript:Sair()" class="dropdown-item">Sair</a>
                        </div>
                    </div>
                <?php else: ?>
                    <a href="javascript:;" id="login-btn-dt" onclick="openLoginModal();" class="d-md-block nav-link-text">Login</a>
                    <button class="navbar-toggler mt-1" type="button" data-toggle="collapse" data-target="#navbarToggleExternalContent" aria-controls="navbarToggleExternalContent" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="fa-solid fa-bars nav-link-text" style="font-size: 24px;"></i>
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    <div class="collapse" id="navbarToggleExternalContent">
        <div class="bg-dark p-4">
            <div id="user-menu-mb" style="display:none">
                <h5 class="text-white h4">Olá <span class="user-first-name"></span>.</h5>
                <p><a href="<?php echo e(route('minha.conta')); ?>" class="text-white">Minha Conta</a></p>
                <p><a href="<?php echo e(route('cliente.ingressos')); ?>" class="text-white">Meus Ingressos</a></p>
                <a href="javascript:void(0)" onclick="javascript:Sair()" class="dropdown-item">Sair</a>
            </div>

            <div id="login-btn-mb" class="text-center">
                <a href="javascript:;" onclick="openLoginModal();" class="btn btn-light btn-lg">Fazer Login</a>
            </div>
        </div>
    </div>
    <?php echo $__env->yieldContent('content'); ?>

    <div id="loader"></div>
    <footer id="footer" class="mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="text-center">
                        <a class="logo" href="<?php echo e(route('site.home')); ?>">
                            <img src="<?php echo e(url('vendas')); ?>/images/logo.png" style="max-height:30px">
                        </a>
                        <ul class="list-inline footer-links mt-3">
                            <li class="list-inline-item"><a href="<?php echo e(route('site.home')); ?>">Login</a> | </li>
                            <li class="list-inline-item"><a href="<?php echo e(route('register')); ?>">Criar Conta</a> | </li>
                            <li class="list-inline-item"><a href="<?php echo e(route('cliente.ingressos')); ?>">Meus Ingressos</a> | </li>
                            <li class="list-inline-item"><a href="mailto:contato@musaticket.com.br">Organize seu Evento</a> | </li>
                            <li class="list-inline-item"><a href="mailto:contato@musaticket.com.br" target="_blank">Fale conosco</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <hr class="my-2">
            <div class="subfooter text-sm text-center">
                <p>
                    © <?php echo e(env('EMPRESA')); ?> - Todos os direitos reservados.
                    <br>
                    CNPJ: <?php echo e(env('CNPJ')); ?>

                </p>
                <ul class="list-inline footer-links">
                    <li class="list-inline-item"><a href="<?php echo e(route('site.politica.privacidade')); ?>">Termos de uso</a></li>
                    <li class="list-inline-item"><a href="<?php echo e(route('site.termo.uso')); ?>">Política de privacidade</a></li>
                </ul>
            </div>
        </div>
    </footer>
    <div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="loginModalLabel">Login</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="loginForm" class="form-modal" method="post" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group">
                            <input type="email" name="email" class="form-control email" placeholder="Email" required="required">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" class="form-control password" placeholder="Senha" required="required">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <button type="submit" id="loginBtn" class="btn btn-lg btn-primary btn-block">Login</button>
                        <p class="text-center mt-3">
                            <small><a href="javascript:;" onclick="$('#loginModal').modal('hide'); $('#recoverPasswordModal').modal('show');">Esqueceu sua senha?</a></small>
                        </p>
                        <hr>
                        <p class="text-center mt-3">
                            <small>Não possui uma conta? <a href="<?php echo e(route('register')); ?>">Cadastre-se!</a></small>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="recoverPasswordModal" tabindex="-1" role="dialog" aria-labelledby="recoverPassModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="recoverPassModalLabel">Recuperar Senha</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formRecoverPassword" class="form-modal" method="POST" action="<?php echo e(route('password.email')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control email" placeholder="Digite seu e-mail" required="required">
                        </div>
                        <button type="submit" id="recuperar" class="btn btn-lg btn-primary btn-block">Enviar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="recoverPasswordSuccessModal" tabindex="-1" role="dialog" aria-labelledby="recoverPassSuccessModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="recoverPassSuccessModalLabel">E-mail enviado</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Você receberá uma mensagem com as instruções para definir uma nova senha. Caso não tenha recebido, verifique sua caixa de Spam.</p>
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="createAccountModal" tabindex="-1" role="dialog" aria-labelledby="createAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered " role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="createAccountModalLabel">Criar Conta</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="createAccountForm" class="form-modal" method="POST" action="<?php echo e(route('register')); ?>">
                        <div id="googleSignup"></div>
                        <p class="text-center mt-2">ou</p>
                        <div class="form-group">
                            <input type="text" name="name" class="form-control" placeholder="Nome" required="required">
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control email" placeholder="Email" required="required">
                        </div>
                        <div class="form-group">
                            <input type="tel" name="cpf" class="form-control email" placeholder="CPF" required="required">
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" class="form-control password" placeholder="Senha" required="required">
                        </div>

                        <div id="createAccountRecaptchaV2" class="mb-4"></div>

                        <button type="submit" id="createAccountBtn" disabled class="btn btn-lg btn-primary btn-block">Criar Conta</button>

                        <p class="text-danger text-center mt-2 signup-error" style="display: none;">
                        </p>

                        <p class="mt-2">
                            <small>
                                Ao me cadastrar, concordo com os <a href="<?php echo e(route('site.termo.uso')); ?>" target="_blank">Termos de uso</a> e <a href="<?php echo e(route('site.politica.privacidade')); ?>" target="_blank">Política de privacidade</a>.
                            </small>
                        </p>
                        <hr>
                        <p class="text-center mt-3">
                            <small>Já possui uma conta? <a href="javascript:;" onclick="$('#createAccountModal').modal('hide'); $('#loginModal').modal('show');">Faça login!</a></small>
                        </p>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="createAccountCheckEmailModal" tabindex="-1" role="dialog" aria-labelledby="createAccountCheckModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="createAccountCheckModalLabel">Falta pouco</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <h4>Ação necessária:</h4>
                    <p>
                        Verifique seu e-mail para <strong>ativar sua conta</strong>.
                        <br>
                        Caso não tenha recebido, verifique sua caixa de Spam.
                    </p>
                    <button type="button" class="btn btn-primary" onclick="$('#createAccountCheckEmailModal').modal('hide'); $('#loginModal').modal('show');">Verifiquei meu e-mail</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="myAccountModal" tabindex="-1" role="dialog" aria-labelledby="myAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myAccountModalLabel">Olá</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <p class="text-center">Seja bem-vindo!</p>
                    <a href="<?php echo e(route('cliente.ingressos')); ?>" class="btn btn-primary btn-lg btn-block mb-3">Meus Ingressos</a>
                    <a href="<?php echo e(route('cliente.dados')); ?>" class="btn btn-warning btn-lg btn-block mb-3">Minha conta</a>
                    <button type="button" onclick="$('#myAccountModal').modal('hide');" class="btn btn-success btn-lg btn-block mb-3">Ir para o evento</button>
                </div>
            </div>
        </div>
    </div>
    <form action="<?php echo e(route('logout')); ?>" method="post" id="sair"><?php echo csrf_field(); ?></form>


    <script src="<?php echo e(url('vendas')); ?>/static/js/tippy/popper.min.js"></script>
    <script src="<?php echo e(url('vendas')); ?>/static/js/tippy/tippy-bundle.umd.min.js"></script>
    <!-- Bootstrap v4.5.0 JS via CDN -->
    <script src="<?php echo e(url('vendas')); ?>/static/strap34/assets/js/bootstrap.min.js"></script>
    <script src="<?php echo e(url('vendas')); ?>/static/js/numeral/numeral.min.js"></script>
    <script src="<?php echo e(url('vendas')); ?>/static/js/numeral/locales.min5e1f.js?v=2"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/auth.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/js.cookie.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/jquery.mask.min.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/masked_forms.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/event_checkout.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/checkout.js"></script>
    

    <script src="https://cdnjs.cloudflare.com/ajax/libs/fixto/0.5.0/fixto.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js"></script>
    <script type="text/javascript" src="<?php echo e(url('vendas')); ?>/static/js/event_detail8e0e.js?v=<?php echo e(rand()); ?>"></script>

    <?php echo $__env->yieldContent('js'); ?>

    <script>
        $(document).ready(function() {
            $("#loginBtn").click(function() {
                $('#loader').show();
                document.getElementById("loginForm").submit();
            });

            $("#recuperar").click(function() {
                $('#loader').show();
                document.getElementById("formRecoverPassword").submit();
            });
        });

        function Sair() {
            document.getElementById("sair").submit();
        }
    </script>
</body>

</html>
<?php /**PATH D:\Laravel\DUNNA\Versão O Ingresso\resources\views/vendas/base-pg.blade.php ENDPATH**/ ?>