<?php $__env->startSection('titulo', 'Home'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="box-body">
                                <h4 class="box-title mb-5"><?php echo e($saudacao); ?> <?php echo e(Auth::user()->name); ?>! </h4>
                                <p class="subtitle mb-20">Já publicou seu evento? </p>
                                <div class="clearfix">
                                    <a href="<?php echo e(route('evento.create')); ?>" class="waves-effect waves-light btn btn-primary mb-5">Criar Evento</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Meus Eventos</h4>
                            </div>
                            <div class="box-body p-15">
                                <div class="table-responsive">
                                    <div id="tickets_wrapper" class="dataTables_wrapper container-fluid dt-bootstrap4 no-footer">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <table id="tickets" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                                    <thead>
                                                        <tr role="row">
                                                            <th class="sorting_des" tabindex="0" aria-controls="tickets" rowspan="1" colspan="1" aria-sort="ascending" aria-label="ID: activate to sort column descending">ID</th>
                                                            <th class="sorting">Status</th>
                                                            <th class="sorting">Evento</th>
                                                            <th class="sorting">Data</th>
                                                            <th class="sorting">Local</th>
                                                            <th class="sorting">Ingressos</th>
                                                            <th class="sorting">Total Vendido</th>
                                                            <th class="sorting">Ações</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr role="row" class="odd">
                                                                <td class="sorting_1"><?php echo e($item->id); ?></td>
                                                                <td>
                                                                    <span class="badge badge-lg badge-dot badge-<?php echo e($status[$item->status]); ?>"></span>
                                                                    <span class="text-<?php echo e($status[$item->status]); ?>"><?php echo e($item->status); ?></span>
                                                                </td>
                                                                <td><?php echo e($item->titulo); ?></td>
                                                                <td><?php echo e(date('d/m/Y', strtotime($item->data_inicio))); ?></td>
                                                                <td><?php echo e($item->local); ?></td>
                                                                <td>
                                                                    <div class="row">
                                                                        <div class="text-right nopadding">
                                                                            <div class="progress-container">
                                                                                <div class="progress soldticket-bar pull-left">
                                                                                    <div role="progressbar" aria-valuenow="<?php echo e(count($item->Ingressos)); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($item->Pacotes->sum('qtd')); ?>" class="progress-bar" style="width: <?php echo e(MediaVendas(count($item->Ingressos), $item->Pacotes->sum('qtd'))); ?>%;"></div>
                                                                                    <span class="progress-sold"><?php echo e(count($item->Ingressos)); ?></span>
                                                                                    <span class="progress-total"><?php echo e($item->Pacotes->sum('qtd')); ?></span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>R$ <?php echo e(moeda($item->Pedidos->sum('total'))); ?></td>
                                                                <td>
                                                                    <a href="<?php echo e(route('evento.show', $item)); ?>" class="waves-effect waves-light btn btn-primary btn-sm">Gerenciar</a>
                                                                    <a href="<?php echo e(route('site.evento', [$item->url, $item->id])); ?>" target="_blank" class="waves-effect waves-light btn btn-primary btn-sm"><i class="glyphicon glyphicon-share"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>


    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/jquery.peity/jquery.peity.js"></script>

    <!-- CRMi App -->
    <script src="<?php echo e(url('adm')); ?>/src/js/jquery.smartmenus.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/menus.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/template.js"></script>

    <script src="<?php echo e(url('adm')); ?>/src/js/pages/data-table.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/app-ticket.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/home/index.blade.php ENDPATH**/ ?>