
<?php $__env->startSection('titulo','Ingressos Online e Gestão de Eventos | Musa Ticket'); ?>
<?php $__env->startSection('url',route('site.home')); ?>
<?php $__env->startSection('description','Compre e gerencie ingressos para eventos de forma rápida e segura na Musa Ticket'); ?>
<?php $__env->startSection('image',url('site/images/logo.png')); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 40px;"></div>
<div id="content" class="p-0">
    <div class="container py-6">
        <div id="slideDestaques" class="mt-4 owl-dots-center owl-nav-over owl-nav-over-lg owl-nav-over-hover" style="display: none;" data-toggle="owl-carousel" data-owl-carousel-settings='{"slideBy":2, "responsiveClass":true, "responsive":{ "0":{ "items":1, "nav":false }, "600":{ "items":2, "nav":true } }, "center":false, "margin":20, "autoplay":true, "loop":true, "dots":true, "nav":true, "animateOut":"slideOutLeft"}'>
            <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="item">
                <div class="card product-card card-no-border">
                    <div class="pos-relative">
                        <a href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" target="_blank">
                            <img style="object-fit: cover; object-position: center;" class="card-img-top img-fluid card-img-border slide-banner" src="<?php echo e(url("storage/{$evento->banner}")); ?>" alt="<?php echo e($evento->titulo); ?>">
                        </a>
                    </div>
                    <!-- Content -->
                    <div class="card-body card-padding">
                        <h4 class="card-title-slide mb-1 mt-1">
                            <a href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" class="card-link-title" target="_blank" title="<?php echo e($evento->titulo); ?>"><?php echo e($evento->titulo); ?></a>
                        </h4>
                        <p class="card-text">
                            <span class="text-primary card-event-date">
                                <?php echo e($semana[date('w',strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d',strtotime($evento->data_inicio))); ?>/<?php echo e(substr($mes[date('m', strtotime($evento->data_inicio))], 0, 3)); ?>

                                às <?php echo e(date('H:i',strtotime($evento->data_inicio))); ?>

                            </span><br>
                            <small><?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?></small>
                        </p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="row py-4 py-lg-4 justify-content-center">
            <div class="col-md-6 col-md-offset-3">
                <form action="<?php echo e(route('site.buscar')); ?>" method="POST" role="form">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" class="form-control input-lg" name="s" id="fieldBusca" value="" placeholder="Digite o nome do evento" required="required">
                        <span class="input-group-btn">
                            <button class="btn btn-primary btn-lg">
                                <span class="d-none d-lg-block"><i class="fa fa-search"></i> Procurar</span>
                                <span class="d-lg-none"><i class="fa fa-search"></i></span>
                            </button>
                        </span>
                    </div>
                </form>
            </div>
        </div>
        <h3 class="font-weight-bold my-0 mb-4" style="font-size: 25px;">
            Próximos Eventos
        </h3>
        <div class="row">
            <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 pb-4" style="display: flex; flex-wrap: wrap;">
                <div class="card product-card card-no-border">
                    <div class="pos-relative">
                        <a href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" target="_blank">
                            <img style="width: 350px; height: 183px; object-fit: cover; object-position: center;" class="card-img-top img-fluid card-img-border slide-banner" src="<?php echo e(url("storage/{$evento->banner}")); ?>" alt="<?php echo e($evento->titulo); ?>">
                        </a>
                    </div>
                    <!-- Content -->
                    <div class="card-body card-padding">
                        <h4 class="card-title mb-1 mt-1">
                            <a href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" class="card-link-title" target="_blank" title="<?php echo e($evento->titulo); ?>"><?php echo e($evento->titulo); ?></a>
                        </h4>
                        <p class="card-text">
                            <span class="text-primary card-event-date">
                                <?php echo e($semana[date('w',strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d',strtotime($evento->data_inicio))); ?>/<?php echo e(substr($mes[date('m', strtotime($evento->data_inicio))], 0, 3)); ?>

                                às <?php echo e(date('H:i',strtotime($evento->data_inicio))); ?>

                            </span><br>
                            <small><?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?></small>
                        </p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/site/index.blade.php ENDPATH**/ ?>