<?php $__env->startSection('content'); ?>
    <main id="page_content">
        <div class="hero" style="background-image: url(<?php echo e(url('site')); ?>/images/banner/home.jpg);"></div>
        <div class="under-hero container">
            <div class="section">
                <div class="section__head">
                    <div class="flex-grow-1"><span class="section__subtitle">TOP Musa</span>
                        <h4 class="mb-0">Eventos <span class="text-primary">mais comprados</span> nas últimas 24h</h4>
                    </div><a href="<?php echo e(route('site.eventos')); ?>" class="btn btn-link">Ver tudo</a>
                </div>
                <div class="swiper-carousel swiper-carousel-button">
                    <div class="swiper" data-swiper-slides="5" data-swiper-autoplay="true">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <div class="cover cover--round">
                                        <div class="cover__head">
                                            <ul class="cover__label d-flex">
                                                <li>
                                                    <span class="badge rounded-pill bg-danger">
                                                        <i class="ri-heart-fill"></i>
                                                    </span>
                                                </li>
                                            </ul>
                                            <div class="cover__options dropstart d-inline-flex ms-auto">
                                                <a class="dropdown-link" href="javascript:void(0);" role="button" data-bs-toggle="dropdown" aria-label="Cover options" aria-expanded="false">
                                                    <i class="ri-more-2-fill"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-sm">
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button" data-favorite-id="1">Favorite</a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button" data-playlist-id="1">Add to playlist</a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button" data-queue-id="1">Add to queue</a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button" data-next-id="1">Next to play</a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button">Share</a>
                                                    </li>
                                                    <li class="dropdown-divider"></li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" role="button" data-play-id="1">Play</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="cover__image">
                                            <a target="_blank" href="<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>">
                                                <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" alt="<?php echo e($evento->titulo); ?>" class="corta-img-cover">
                                            </a>
                                        </div>
                                        <div class="cover__foot">
                                            <a target="_blank" href="<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>" class="cover__title text-truncate"><?php echo e($evento->titulo); ?></a>
                                            <p class="cover__subtitle text-truncate">
                                                <a href="<?php echo e(url('site')); ?>/artist-details.html"><?php echo e($evento->Categoria->titulo); ?></a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="swiper-button-prev btn-default rounded-pill"></div>
                    <div class="swiper-button-next btn-default rounded-pill"></div>
                </div>
            </div>

            <div class="section">
                <div class="section__head">
                    <div class="flex-grow-1">
                        <h3 class="mb-0">Categorias</h3>
                    </div>
                    <a href="<?php echo e(route('site.categorias')); ?>" class="btn btn-link">Ver tudo</a>
                </div>
                <div class="swiper-carousel swiper-carousel-button">
                    <div class="swiper" data-swiper-slides="6" data-swiper-autoplay="true">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <div class="avatar avatar--xxl d-block text-center">
                                        <div class="avatar__image">
                                            <a href="<?php echo e(route('site.categoria', $categoria->url)); ?>">
                                                <img src="<?php echo e(url("storage/{$categoria->ico}")); ?>" alt="<?php echo e($categoria->titulo); ?>">
                                            </a>
                                        </div>
                                        <a href="<?php echo e(route('site.categoria', $categoria->url)); ?>" class="avatar__title mt-3"><?php echo e($categoria->titulo); ?></a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="section col-xl-12">
                    <div class="section__head">
                        <div class="flex-grow-1">
                            <h3 class="mb-0">Próximos <span class="text-primary">Eventos</span></h3>
                        </div><a href="<?php echo e(route('site.eventos')); ?>" class="btn btn-link">Ver todos</a>
                    </div>
                    <div class="swiper-carousel">
                        <div class="swiper" data-swiper-slides="4" data-swiper-autoplay="true">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="cover cover--round">
                                            <a target="_blank" href="<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>" class="cover__image">
                                                <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" style="width: 100%; height: 200px; object-fit: cover; object-position: center;">
                                            </a>
                                            <div class="cover__foot mt-3 px-2">
                                                <p class="cover__subtitle d-flex mb-2">
                                                    <i class="ri-map-pin-fill fs-6"></i>
                                                    <span class="ms-1 fw-semi-bold"><?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?></small>
                                                </p>
                                                <p class="cover__subtitle d-flex mb-2">
                                                    <i class="ri-calendar-fill fs-6"></i>
                                                    <span class="ms-1 fw-semi-bold">
                                                        <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>,
                                                        <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e(substr($mes[date('m', strtotime($evento->data_inicio))], 0, 3)); ?>

                                                        às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                                        </small>
                                                </p>
                                                <a href="<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>" class="cover__title fs-6 mb-3">
                                                    <?php echo e($evento->titulo); ?>

                                                </a>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <a target="_blank" href="<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>" class="btn btn-sm btn-light-primary" style="width: 100%">Compre
                                                        Aqui</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="section">
                <div class="section__head">
                    <div class="flex-grow-1"><span class="section__subtitle">Músicas mais tocadas nas últimas 24h</span>
                        <h3 class="mb-0">Top <span class="text-primary">Músicas</span></h3>
                    </div>
                </div>
                <div class="list list--lg list--order">
                    <div class="row">
                        <div class="col-xl-6">
                            <?php $__currentLoopData = $Play; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list__item" data-song-id="<?php echo e($item->id); ?>" data-song-name="<?php echo e($item->titulo); ?>" data-song-artist="<?php echo e($item->artista); ?>" data-song-album="Hot shot"
                                    data-song-url="<?php echo e(url("storage/{$item->file}")); ?>" data-song-cover="<?php echo e(url("storage/{$item->capa}")); ?>">
                                    <div class="list__cover">
                                        <img src="<?php echo e(url("storage/{$item->capa}")); ?>" alt="<?php echo e($item->titulo); ?>">
                                        <a href="javascript:void(0);" class="btn btn-play btn-sm btn-default btn-icon rounded-pill" data-play-id="<?php echo e($item->id); ?>" aria-label="Play pause">
                                            <i class="ri-play-fill icon-play"></i>
                                            <i class="ri-pause-fill icon-pause"></i>
                                        </a>
                                    </div>
                                    <div class="list__content">
                                        <a href="song-details.html" class="list__title text-truncate"><?php echo e($item->titulo); ?></a>
                                        <p class="list__subtitle text-truncate"><a href="artist-details.html"><?php echo e($item->artista); ?></a></p>
                                    </div>
                                    <ul class="list__option">
                                        <li><span class="badge rounded-pill bg-info"><i class="ri-vip-crown-fill"></i></span></li>
                                        <li>
                                            <a href="javascript:void(0);" role="button" class="d-inline-flex" aria-label="Favorite" data-favorite-id="100">
                                                <i class="ri-heart-line heart-empty"></i>
                                                <i class="ri-heart-fill heart-fill"></i>
                                            </a>
                                        </li>
                                        <li class="dropstart d-inline-flex">
                                            <a class="dropdown-link" href="javascript:void(0);" role="button" data-bs-toggle="dropdown" aria-label="Cover options" aria-expanded="false"><i
                                                    class="ri-more-fill"></i></a>
                                            <ul class="dropdown-menu dropdown-menu-sm">
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" role="button" data-favorite-id="100">Favorite</a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="audio/ringtone-1.mp3" download>Download</a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" role="button">Share</a>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('site.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/musaticketcom/novo.musaticket.com.br/resources/views/site/index.blade.php ENDPATH**/ ?>