<?php $__env->startSection('url',''); ?>
<?php $__env->startSection('type',''); ?>
<?php $__env->startSection('titulo',''); ?>
<?php $__env->startSection('description',''); ?>
<?php $__env->startSection('image',''); ?>
<?php $__env->startSection('content'); ?>
<main id="content" class="site-main" style="background: url(<?php echo e(url("storage/{$evento->banner}")); ?>) no-repeat center center fixed; background-size: cover !important;">
    <!-- Inner Banner html start-->
    <section class="inner-banner-wrap">
        <div class="inner-baner-container">
            <div class="container">
                <div class="inner-banner-content">
                    <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" class="img-evento-full">
                </div>
            </div>
        </div>
        <div class="inner-shape"></div>
    </section>
    <!-- Inner Banner html end-->
    <div class="single-tour-section">
        <div class="container" style="background:#FFF; margin-top:-110px; padding:10px">
            <div class="row">
                <div class="col-lg-12">
                    <div class="cart-section">
                        <div class="container">
                            <div class="cart-list-inner" style="margin-top: 50px;">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th style="width:55%;">Descrição</th>
                                                <th style="width:15%;">Preço</th>
                                                <th style="width:15%;">Quantidade</th>
                                                <th style="width:15%;">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <input type="hidden" id="preco<?php echo e($pacote->id); ?>" value="<?php echo e($pacote->preco); ?>">
                                            <tr>
                                                <td data-column="Descrição"><?php echo e($pacote->nome); ?></td>
                                                <td data-column="Preço">
                                                    R$ <?php echo e(moeda($pacote->preco)); ?><br>
                                                    <p style="font-size: 10px;">(+ R$ <?php echo e(moeda(porcentagem(env('TAXA'),$pacote->preco))); ?> taxa)</p>
                                                </td>
                                                <td data-column="Quantidade" class="count-input">
                                                    <div>
                                                        <a onclick="javascript:Del(<?php echo e($pacote->id); ?>)" class="minus-btn" href="javascript:void(0)"><i class="fa fa-minus"></i></a>
                                                        <input id="qtd<?php echo e($pacote->id); ?>" class="quantity" type="text" value="0">
                                                        <a onclick="javascript:Add(<?php echo e($pacote->id); ?>)" class="plus-btn" href="javascript:void(0)"><i class="fa fa-plus"></i></a>
                                                    </div>
                                                </td>
                                                <td id="total_pacote<?php echo e($pacote->id); ?>" data-column="Sub Total">R$ 0,00 </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="updateArea">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Cupom de Desconto" style="border-top-left-radius: 50px; border-bottom-left-radius: 50px;">
                                        <a href="#" class="button-primary"  style="border-top-right-radius: 50px; border-bottom-right-radius: 50px;">Validar</a>
                                    </div>
                                </div>
                                <div class="totalAmountArea">
                                    <ul class="list-unstyled">
                                        <li><strong>Sub Total</strong> <span id="sub_total">R$ 0,00</span></li>
                                        <li><strong>Taxa de serviço</strong> <span id="total_taxa">R$ 0,00</span></li>
                                        <li><strong>Total</strong> <span class="grandTotal" id="total_geral">R$ 0,00</span></li>
                                    </ul>
                                </div>
                                <div class="text-right checkBtnArea">
                                    <p class="fw-bold">
                                        <input type="checkbox" name="aceito" id="aceito"> Li e concordo com as
                                        <a href="#">Políticas de Privacidade</a> e
                                        <a href="#">Reembolso</a>.
                                    </p>
                                    <button type="button" class="button-primary rounded-50" onclick="javascript:Avancar()">Avançar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
    function Add(id) {
        var qtd = document.getElementById('qtd' + id);
        var valor = parseInt(qtd.value);
        var total = qtd.value = valor + 1;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "<?php echo e(route('cart.add')); ?>",
            method: 'POST',
            data: {
                id,
                total
            },
            success: function(result) {
                $("#total_pacote"+id).text(result.total_pacote);

                $.ajax({
                    url: "<?php echo e(route('cart.total')); ?>",
                    method: 'POST',
                    data: {
                        id
                    },
                    success: function(result) {
                        $("#sub_total").text(result.sub_total);
                        $("#total_taxa").text(result.total_taxa);
                        $("#total_geral").text(result.total_geral);
                    }
                });
            }
        });
    }

    function Del(id) {
        var qtd = document.getElementById('qtd' + id);
        var valor = parseInt(qtd.value);
        if (valor > 0) {
            var total = qtd.value = valor - 1;
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('cart.del')); ?>",
                method: 'POST',
                data: {
                    id,
                    total
                },
                success: function(result) {
                    $("#total_pacote"+id).text(result.total_pacote);

                    $.ajax({
                        url: "<?php echo e(route('cart.total')); ?>",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#sub_total").text(result.sub_total);
                            $("#total_taxa").text(result.total_taxa);
                            $("#total_geral").text(result.total_geral);
                        }
                    });
                }
            });
        } else {
            Swal.fire({
              title: 'Atenção!',
              text: 'A quantidade não pode ser menor que zero',
              icon: 'error'
            });
        }
    }

    $(document).ready(function() {
    // Monitorar mudanças no checkbox
        $('#aceito').change(function() {
            if (this.checked) {
                // Habilitar o botão se o checkbox está marcado
                $('#avancar').removeAttr('disabled');
            } else {
                // Desabilitar o botão se o checkbox está desmarcado
                $('#avancar').attr('disabled', 'disabled');
            }
        });
    });

    function Avancar(){
        if ($('#aceito').is(':checked')) {
            window.location.href = <?php echo e(route('site.checkout')); ?>;
        } else {
            Swal.fire({
                title: 'Erro!',
                text: 'Você precisa aceitar os termos para continuar.',
                icon: 'error'
            });
        }
    }

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\Sollares\resources\views/site/evento.blade.php ENDPATH**/ ?>