<div class="modal-content">
    <div class="modal-header">
        <h4 class="modal-title" id="myLargeModalLabel">Editar ingresso <strong><?php echo e($exe->nome); ?></strong></h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
        <div class="box-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label">Título do ingresso</label>
                        <input type="text" id="titulo_ingresso_update" class="form-control" value="<?php echo e($exe->nome); ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="form-label">Quantidade</label>
                        <input id="qtd_ingresso_update" type="text" class="form-control" value="<?php echo e($exe->qtd); ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="form-label">Valor a receber</label>
                        <input type="text" id="valor_ingresso_update" class="form-control preco" value="<?php echo e(moeda($exe->preco)); ?>">
                    </div>
                </div>
            </div>
            <div class="row mt-30">
                <label class="form-label">Período das vendas deste ingresso</label>
                <div class="row">
                    <div class="col-lg-3 col-md-3 col-6">
                        <div class="form-group">
                            <label class="form-label">Data Início </label>
                            <input id="data_inicio_update" value="<?php echo e(date('Y-m-d', strtotime($exe->data_inicio))); ?>" type="date" class="form-control date-time">
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-6">
                        <div class="form-group">
                            <label class="form-label">Hora Final</label>
                            <input id="hora_inicio_update" value="<?php echo e(date('H:i', strtotime($exe->hora_inicio))); ?>" type="time" class="form-control date-time">
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-6">
                        <div class="form-group">
                            <label class="form-label">Data Final</label>
                            <input id="data_fim_update" value="<?php echo e(date('Y-m-d', strtotime($exe->data_fim))); ?>" type="date" class="form-control date-time">
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-6">
                        <div class="form-group">
                            <label class="form-label">Hora Final</label>
                            <input id="hora_fim_update" value="<?php echo e(date('H:i', strtotime($exe->hora_fim))); ?>" type="time" class="form-control date-time">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-30">
                <label class="form-label">Disponibilidade do Ingresso</label>
                <div class="form-group">
                    <div class="radio">
                        <input name="disponibilidade_update" type="radio" id="tipo_1" <?php echo e($exe->tipo == 'Público' ? 'checked' : ''); ?> value="Público">
                        <label for="tipo_1">Para todo o público </label>
                    </div>
                    <div class="radio">
                        <input name="disponibilidade_update" type="radio" id="tipo_2" <?php echo e($exe->tipo == 'Convidados' ? 'checked' : ''); ?> value="Convidados">
                        <label for="tipo_2">Restrito a convidados</label>
                    </div>
                    <div class="radio">
                        <input name="disponibilidade_update" type="radio" id="tipo_3" <?php echo e($exe->tipo == 'Convidados' ? 'checked' : ''); ?> value="Manual">
                        <label for="tipo_3">Para ser adicionado manualmente</label>
                    </div>
                    <div class="radio">
                        <input name="disponibilidade_update" type="radio" id="tipo_4" value="Excluir">
                        <label for="tipo_4" class="text-danger">Excluir Ingresso</label>
                    </div>
                </div>
            </div>
            <div class="row mt-30">
                <label class="form-label">Quantidade permitida por compra</label>
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Mínima</label>
                                <input id="qtd_minima_compra_update" type="text" class="form-control" value="<?php echo e($exe->qtd_minima_compra); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Máxima</label>
                                <input id="qtd_maxima_compra_update" type="text" class="form-control" value="<?php echo e($exe->qtd_maxima_compra); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
        <button onclick="javascript:IngressoUpdate(<?php echo e($exe->id); ?>)" type="button" class="btn btn-primary float-end btn-sm">Atualizar Ingresso</button>
    </div>
</div><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/ajax/pacote-show.blade.php ENDPATH**/ ?>