<div class="row">
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Pedido:</strong></p>
        <p><?php echo e($pedido->registro); ?></p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Data do pedido:</strong></p>
        <p><?php echo e(date('d/m/Y', strtotime($pedido->created_at))); ?> às <?php echo e(date('H:i', strtotime($pedido->created_at))); ?></p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Valor total:</strong></p>
        <p>R$ <?php echo e(moeda($pedido->total + $pedido->taxa)); ?></p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Situação:</strong></p>
        <div class="iso-bootstrap">
            <span class="badge badge-<?php echo e($status_pagamento[$pedido->status]); ?> badge-django"><?php echo e($pedido->status); ?></span>
        </div>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Forma de pagamento:</strong></p>
        <p><?php echo e($forma_pagamento[$pedido->forma_pagamento]); ?></p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Evento:</strong></p>
        <p><?php echo e($pedido->Evento->titulo); ?></p>
    </div>
    <div class="col-md-12 text-muted">
        <p class="mb-1"><strong>Comprador:</strong></p>
        <p><?php echo e($pedido->Cliente->name); ?> <?php echo e($pedido->Cliente->sobrenome); ?> - <?php echo e($pedido->Cliente->email); ?></p>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <h4>Ingressos</h4>
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <th scope="col">Nome completo / E-mail</th>
                        <th scope="col">Tipo</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Taxa</th>
                        <th scope="col">Total</th>
                    </tr>
                </thead>
                <tbody style="font-size: 12px;">
                    <?php $__currentLoopData = $pedido->Ingressos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ingresso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($ingresso->nome_completo); ?><br><?php echo e($ingresso->email); ?></td>
                            <td><?php echo e($ingresso->Pacote->nome); ?></td>
                            <td>R$ <?php echo e(moeda($ingresso->preco)); ?></td>
                            <td>R$ <?php echo e(moeda($ingresso->taxa)); ?></td>
                            <td>R$ <?php echo e(moeda($ingresso->preco+$ingresso->taxa)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>Total</td>
                        <td>R$ <?php echo e(moeda($pedido->total+$pedido->taxa)); ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<div id="divParticipantEdit" class="row mb-4" style="display:none;">
    <div class="col-md-12">
        <hr>
        <h4>Editar participante</h4>
        <div id="participantEditBody">
        </div>
    </div>
</div>
<?php /**PATH F:\Laravel\MusaTicket\resources\views/cliente/ajax/pedido.blade.php ENDPATH**/ ?>