
<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('url',route('site.evento',[$evento->titulo,$evento->id])); ?>
<?php $__env->startSection('description',lmword($evento->titulo,180)); ?>
<?php $__env->startSection('image',url("storage/{$evento->banner}")); ?>
<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row pt-4 pt-lg-5">
            <div class="col-sm-12 d-block d-lg-none">
                <h3 class="mb-3 event-title">
                    <?php echo e($evento->titulo); ?>

                </h3>
                <div class="row">
                    <div class="col-md-12">
                        <p class="text-muted event-info">
                            <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                            <i class="far fa-calendar-alt mr-1"></i>
                            <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                            até
                            <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                        </p>
                    </div>
                </div>
            </div>
            <!-- Sidebar content -->
            <div class="col-lg-4 order-lg-2 mb-4 mb-lg-0">
                <div data-toggle="sticky" data-settings="{'parent': '#content', 'top': 10, 'breakpoint': 992}" class="sticky" style="position: sticky; top: 0px;">
                    <div class="sticky-inner">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-striped table-tickets scroll-sm-hidden">
                                        <thead>
                                            <tr class="header">
                                                <th colspan="2">
                                                    Ingressos
                                                    <div style="float: right;">
                                                        <i class="fas fa-shopping-cart"></i> <span class="cart_total">R$ <?php echo e(moeda($total + porcentagem(10, $total))); ?></span>
                                                    </div>
                                                    <script type="text/javascript">
                                                        var totalAmount = "176.00";
                                                    </script>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <span class="ticket-type"><?php echo e($cart['ingresso']); ?></span>
                                                        <br>
                                                        <span class="ticket-amount">
                                                            R$ <?php echo e(moeda($cart['valor'])); ?>

                                                            (+ R$ <?php echo e(moeda(porcentagem(10, $cart['valor']))); ?> taxa)
                                                        </span>
                                                        <br>
                                                        <span class="ticket-notes">Vendas até 10/01/25</span>
                                                    </td>
                                                    <td class="qtd-panel">
                                                        <?php echo e($cart['qtd']); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main content -->
            <div class="col-lg-8 pull-lg-3 mb-3">
                <div class="d-none d-lg-block">
                    <h3 class="mb-3 event-title">
                        <?php echo e($evento->titulo); ?>

                    </h3>
                    <div class="row">
                        <div class="col-md-12">
                            <p class="event-info">
                                <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                                <i class="far fa-calendar-alt mr-1"></i>
                                <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                até
                                <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                            </p>
                        </div>
                    </div>
                    <hr>
                </div>
                <form id="form_pedido" class="form" method="POST" action="<?php echo e(route('processar.pagamento')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="<?php echo e($evento->id); ?>" name="evento_id">
                    <div class="row">
                        <?php if(empty(Auth::check())): ?>
                        <div class="col-lg-12 pt-0">
                            <div id="alertLogin" class="alert alert-light-login" role="alert">
                                <div class="row">
                                    <div class="col-12 col-md-5 text-center text-md-left mb-2 mb-md-0">
                                        <span style="font-size: 13px; font-weight: bold;">Facilite o preenchimento dos dados:</span>
                                    </div>
                                    <div class="col-12 col-md-2 p-0 text-center mt-2 mt-md-0">
                                        <a href="javascript:;" onclick="openLoginModal();" style="font-size: 12px; font-weight: bold">Logar com e-mail</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-lg-12 pt-0">
                            <h4 class="mb-3">
                                <span>Informações do participante</span>
                            </h4>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-form-tickets mb-0">
                                            <tbody id="participantsTable">
                                                <!-- Campos para participantes serão inseridos aqui -->
                                            </tbody>
                                        </table>
                                    </div>

                                    <hr>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 pt-0">
                            <h4 class="mb-3">
                                <span>Informações para o recebimento do ingresso</span>
                            </h4>
                            <div class="row form-group-cst">
                                <div class="col-md-12">
                                    <label for="id_nome_completo">Nome completo:</label><input type="text" name="nome_completo" class="form-control" required="" maxlength="255" id="id_nome_completo">
                                </div>
                            </div>
                            <div class="row form-group-cst">
                                <div class="col-md-6">
                                    <label for="id_email">E-mail:</label><input type="email" name="email" class="form-control" required="" maxlength="255" id="id_email">
                                </div>
                                <div class="col-md-6">
                                    <label for="id_confirm_email">Confirmação do e-mail: REMOVER VALUE DE TESTE</label><input value="rbetobrito@gmail.com" type="email" name="confirm_email" class="form-control" required="" autocomplete="off" maxlength="255" id="id_confirm_email">
                                </div>
                            </div>
                            <div class="row form-group-cst">
                                <div class="col-md-6">
                                    <label for="id_cpf_cnpj">CPF / CNPJ:</label><input type="text" name="cpf_cnpj" class="form-control cpfcnpj-field" inputmode="numeric" maxlength="15" required="" id="id_cpf_cnpj">
                                </div>
                            </div>
                        </div>


                        <div class="col-lg-12 pt-2">
                            <hr>
                            <h4 class="mb-3">
                                <span>Informações de pagamento</span>
                            </h4>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="list-group mb-4">
                                        <button type="button" class="payment-method-btn list-group-item list-group-item-action">
                                            <h5 class="mb-1"><input type="radio" name="payment_method" value="PIX" required="required" class="payment-method-radio mr-3"><i class="fa-brands fa-pix mr-2"></i> PIX</h5>
                                        </button>
                                        <button type="button" class="payment-method-btn list-group-item list-group-item-action">
                                            <h5 class="mb-1"><input type="radio" name="payment_method" value="CC" class="payment-method-radio mr-3"><i class="fa-regular fa-credit-card mr-2"></i> Cartão de crédito</h5>
                                        </button>
                                    </div>

                                    <div class="card card-payment-data" style="display:none">
                                        <h5 class="card-header card-payment-header-title"></h5>
                                        <div class="card-body">
                                            <div class="form-cc">
                                                <input type="hidden" name="hash" id="id_hash" disabled="disabled">
                                                <input type="hidden" name="card_brand" id="id_card_brand" disabled="disabled">
                                                
                                                <input type="hidden" name="threeds_auth_id" id="id_threeds_auth_id" disabled="disabled">
                                                <input type="hidden" name="public_key" id="id_public_key" value="APP_USR-8338ae79-39ad-4de8-91bb-4be653720427" disabled="disabled">
                                                <div class="row form-group-cst">
                                                    <div class="col-md-6">
                                                        3,75
                                                        <label for="id_number_installments">Parcelamento:</label><select name="number_installments" class="form-control" required="required" id="id_number_installments" disabled="disabled">
                                                            <option value="1">1x de R$ <?php echo e(moeda($total + porcentagem(10, $total))); ?> </option>
                                                            <?php
                                                                $parcelamento = $total + porcentagem(10, $total);
                                                            ?>
                                                            <option value="2">2x de R$ <?php echo e(moeda(($parcelamento + porcentagem(4.99, $parcelamento)) / 2)); ?> ★ Mais escolhido</option>
                                                            <option value="3">3x de R$ <?php echo e(moeda(($parcelamento + porcentagem(4.09, $parcelamento)) / 3)); ?></option>
                                                            <option value="4">4x de R$ <?php echo e(moeda(($parcelamento + porcentagem(3.81, $parcelamento)) / 4)); ?></option>
                                                            <option value="5">5x de R$ <?php echo e(moeda(($parcelamento + porcentagem(3.09, $parcelamento)) / 5)); ?></option>
                                                            <option value="6">6x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.99, $parcelamento)) / 6)); ?></option>
                                                            <option value="7">7x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.92, $parcelamento)) / 7)); ?></option>
                                                            <option value="8">8x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.86, $parcelamento)) / 8)); ?></option>
                                                            <option value="9">9x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.81, $parcelamento)) / 9)); ?></option>
                                                            <option value="10">10x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.77, $parcelamento)) / 10)); ?></option>
                                                            <option value="11">11x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.74, $parcelamento)) / 11)); ?></option>
                                                            <option value="12">12x de R$ <?php echo e(moeda(($parcelamento + porcentagem(2.7, $parcelamento)) / 12)); ?></option>
                                                        </select>
                                                        <script id="installments-data" type="application/json">[{"quantity": 1, "amount": "176.00", "total_amount": "176.00", "interest_free": false}, {"quantity": 2, "amount": "88.00", "total_amount": "176.00", "interest_free": true}, {"quantity": 3, "amount": "58.67", "total_amount": "176.00", "interest_free": true}, {"quantity": 4, "amount": "44.00", "total_amount": "176.00", "interest_free": true}, {"quantity": 5, "amount": "35.20", "total_amount": "176.00", "interest_free": true}, {"quantity": 6, "amount": "34.49", "total_amount": "206.94", "interest_free": false}, {"quantity": 7, "amount": "30.01", "total_amount": "210.09", "interest_free": false}, {"quantity": 8, "amount": "26.66", "total_amount": "213.31", "interest_free": false}, {"quantity": 9, "amount": "24.06", "total_amount": "216.53", "interest_free": false}, {"quantity": 10, "amount": "21.98", "total_amount": "219.79", "interest_free": false}, {"quantity": 11, "amount": "20.28", "total_amount": "223.10", "interest_free": false}, {"quantity": 12, "amount": "18.87", "total_amount": "226.42", "interest_free": false}]</script>
                                                    </div>
                                                </div>
                                                <div class="row form-group-cst">
                                                    <div class="col-md-6">
                                                        <label for="id_card_number">Número do cartão:</label><input type="text" name="card_number" class="form-control masked" autocomplete="cc-number" inputmode="numeric" mask="0000 0000 0000 0000" required="required" placeholder="0000 0000 0000 0000" maxlength="19" id="id_card_number" disabled="disabled">
                                                    </div>
                                                    <div class="col-md-3 col-6">
                                                        <label for="id_expiration">Mês/Ano:</label><input type="text" name="expiration" class="form-control masked" autocomplete="cc-exp" inputmode="numeric" mask="00/00" placeholder="mm/aa" required="required" maxlength="5" id="id_expiration" disabled="disabled">
                                                    </div>
                                                    <div class="col-md-3 col-6">
                                                        <label for="id_cvv">CVV:</label><input type="text" name="cvv" maxlength="4" class="form-control masked" autocomplete="cc-csc" inputmode="numeric" mask="0000" required="required" placeholder="000" id="id_cvv" disabled="disabled">
                                                    </div>
                                                </div>
                                                <div class="row form-group-cst">
                                                    <div class="col-md-6">
                                                        <label for="id_holder_name">Nome impresso no cartão:</label><input type="text" name="holder_name" class="form-control" autocomplete="cc-name" required="" maxlength="90" id="id_holder_name" disabled="disabled">
                                                    </div>
                                                </div>
                                                <h4 style="margin-top:15px; margin-bottom: 15px;">Dados do titular do cartão</h4>
                                                <div class="row form-group-cst">
                                                    <div class="col-md-6">
                                                        <label for="id_holder_cpf_cnpj">CPF/CNPJ do titular:</label><input type="text" name="holder_cpf_cnpj" class="form-control cpfcnpj-field" inputmode="numeric" maxlength="15" required="" id="id_holder_cpf_cnpj" disabled="disabled">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="id_phone_number">Telefone:</label><input type="text" name="phone_number" class="phone form-control" required="" placeholder="xx-xxxxx-xxxx" inputmode="numeric" id="id_phone_number" maxlength="13" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-end">
                                                <div class="row form-group-cst">
                                                    <div class="col-md-3">
                                                        <label for="id_cep">CEP:</label><input type="text" name="cep" class="masked zip-field form-control" inputmode="numeric" maxlength="9" required="" id="id_cep" mask="99999-999" autocomplete="off" disabled="disabled">
                                                        <script type="text/javascript">
                                                            var address = {
                                                                "street": "id_logradouro",
                                                                "district": "id_bairro",
                                                                "city": "id_cidade",
                                                                "state": "id_uf"
                                                            };
                                                        </script>
                                                    </div>
                                                </div>
                                                <div id="posCep" style="display: none;">
                                                    <div class="row form-group-cst">
                                                        <div class="col-md-6">
                                                            <label for="id_logradouro">Rua/Av:</label><input type="text" name="logradouro" class="form-control" required="" maxlength="255" id="id_logradouro" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="id_numero">Número:</label><input type="text" name="numero" class="form-control" required="" maxlength="10" id="id_numero" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="id_complemento">Complemento:</label><input type="text" name="complemento" class="form-control" maxlength="30" id="id_complemento" disabled="disabled">
                                                        </div>
                                                    </div>
                                                    <div class="row form-group-cst">
                                                        <div class="col-md-6">
                                                            <label for="id_bairro">Bairro:</label><input type="text" name="bairro" class="form-control" required="" maxlength="155" id="id_bairro" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="id_cidade">Cidade:</label><input type="text" name="cidade" class="form-control" required="" maxlength="155" id="id_cidade" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="id_uf">Uf:</label>
                                                            <select name="uf" class="form-control" required="required" id="id_uf" disabled="disabled">
                                                                <option value="AC">Acre</option>
                                                                <option value="AL">Alagoas</option>
                                                                <option value="AM">Amazonas</option>
                                                                <option value="AP">Amapá</option>
                                                                <option value="BA">Bahia</option>
                                                                <option value="CE">Ceará</option>
                                                                <option value="DF">Distrito Federal</option>
                                                                <option value="ES">Espírito Santo</option>
                                                                <option value="GO">Goiás</option>
                                                                <option value="MA">Maranhão</option>
                                                                <option value="MT">Mato Grosso</option>
                                                                <option value="MS">Mato Grosso do Sul</option>
                                                                <option value="MG">Minas Gerais</option>
                                                                <option value="PA">Pará</option>
                                                                <option value="PB">Paraíba</option>
                                                                <option value="PR">Paraná</option>
                                                                <option value="PE">Pernambuco</option>
                                                                <option value="PI">Piauí</option>
                                                                <option value="RJ">Rio de Janeiro</option>
                                                                <option value="RN">Rio Grande do Norte</option>
                                                                <option value="RO">Rondônia</option>
                                                                <option value="RS">Rio Grande do Sul</option>
                                                                <option value="RR">Roraima</option>
                                                                <option value="SC">Santa Catarina</option>
                                                                <option value="SE">Sergipe</option>
                                                                <option value="SP">São Paulo</option>
                                                                <option value="TO">Tocantins</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7 order-2 order-lg-0 d-flex justify-content-center align-items-center mt-3 mt-md-3">
                            <p class="terms-and-policies-alert mb-0"><strong>Ao prosseguir, você declara estar ciente dos nossos <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal">Termos e Políticas.</a></strong></p>
                        </div>
                        <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document"> <!-- Modal Grande -->
                                <div class="modal-content">
                                    <!-- Cabeçalho do Modal -->
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Termo de uso Musa Ticket</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <!-- Corpo do Modal -->
                                    <div class="modal-body">
                                        <p>Os Termos de Uso a seguir são baseados nos princípios da <strong>Musa Ticket</strong> e representam os termos de serviço que regem nosso relacionamento com os Usuários, sejam eles Organizadores de eventos, Compradores ou outras pessoas que interagem com a Musa Ticket através do domínio <a href="https://musaticket.com.br/">musaticket.com.br</a>, de todas as suas páginas e subdomínios, através do aplicativo Musa Ticket e dos pontos de venda autorizados. Ao usar ou acessar os serviços da Musa Ticket você concorda com esta declaração, que poderá ser eventualmente atualizada.</p>

                                        <hr>

                                        <h3>1. SUAS RESPONSABILIDADES</h3>

                                        <h4>Seus dados cadastrados:</h4>
                                        <ul>
                                            <li>Ao criar uma conta na Musa Ticket, você concorda em fornecer informações verdadeiras, completas e atualizadas sobre si mesmo. Caso a Musa Ticket identifique inconsistências ou eventuais riscos em relação ao seu Usuário ou às suas atividades na Musa Ticket e considere necessário validar as informações cadastradas, você se compromete a fornecer as comprovações que lhe forem requisitadas;</li>
                                            <li>Se tivermos motivos que indiquem que quaisquer informações cadastradas não são verdadeiras, teremos o direito de suspender ou encerrar a sua conta, bem como nos recusar a prover quaisquer de nossos serviços;</li>
                                            <li>Qualquer erro, atraso, prejuízo ou dano causado devido ao cadastramento de informações incorretas, incompletas ou desatualizadas é de total responsabilidade do Usuário.</li>
                                        </ul>

                                        <h4>Usuário e senha:</h4>
                                        <ul>
                                            <li>Você é responsável por manter a confidencialidade de seus dados de Usuário e sua senha, criados no ato de registro com a Musa Ticket. Você é única e exclusivamente responsável por todas as atividades que ocorram sob sua conta e se compromete a notificar-nos imediatamente acerca de quaisquer usos não autorizados de sua conta ou quaisquer outras violações de segurança. A Musa Ticket não será responsável por quaisquer perdas e danos resultantes de acessos não autorizados ou uso de sua conta;</li>
                                            <li>A titularidade do cadastro é pessoal. Apenas o titular da conta na Musa Ticket poderá ter acesso aos dados relativos à mesma. Ainda, alterações em dados cadastrados somente poderão ser feitas pelo próprio Usuário em sua área logada. A Musa Ticket não tem prerrogativa para fazer esse tipo de alteração, independentemente da razão alegada ou circunstância.</li>
                                        </ul>

                                        <h4>Publicação e gestão de eventos:</h4>
                                        <p>A Musa Ticket criou a plataforma. O Organizador cadastra o evento e publica seu conteúdo. Ao fazê-lo, o Organizador se compromete a:</p>
                                        <ul>
                                            <li>Atender os termos das leis anticorrupção brasileiras, em especial a Lei 12.846/2013, comprometendo-se a se abster de qualquer atividade que constitua uma violação das disposições destas leis;</li>
                                            <li>Publicar eventos ou quaisquer conteúdos que sejam verdadeiros e com informações completas. Assim, é de responsabilidade do Organizador comunicar com exatidão informações como local, data, horário, valores, atrações, serviços oferecidos, contato, política de cancelamento, política de meia-entrada para fins de atendimento do contido na Lei 12.933/13 e Decreto 8.537/2015, restrição de faixa etária e qualquer outra informação que seja relevante para os Compradores ou, ainda, para a validação da realização dos eventos;</li>
                                            <li>Publicar eventos ou quaisquer conteúdos que o Organizador tenha o direito e capacidade de cumprir. Assim, o Organizador assume que os eventos ou conteúdos publicados têm todos os seus trâmites finalizados junto a atrações, local, patrocinadores, fornecedores, órgãos públicos e qualquer outra parte interessada e que é capaz e irá entregar tudo o que foi anunciado. Além disso, o Organizador confirma que tem direitos sobre o evento ou conteúdo publicado e que não está infringindo nenhuma patente, marca registrada ou direito autoral de qualquer pessoa ou entidade;</li>
                                            <li>Autorizar desde já que a Musa Ticket entre em contato e solicite junto ao local do evento, fornecedores ou demais partes interessadas informações e documentações que considere necessárias;</li>
                                        </ul>

                                        <h4>Compra e utilização de ingressos/inscrições/contribuições:</h4>
                                        <ul>
                                            <li>Inserir dados corretos, completos e atualizados. Caso contrário, a compra poderá ser invalidada e o Comprador, caso queira, terá que fazer uma nova compra, estando sujeito às condições e disponibilidade de ingressos/inscrições/contribuições nesse segundo momento;</li>
                                            <li>Arcar com os valores cobrados na fatura de cartão de crédito, caso essa seja a forma de pagamento escolhida pelo Comprador. A cobrança poderá vir em nome da Musa Ticket por intermédio do nosso processador de pagamentos;</li>
                                            <li>Arcar com o valor total e integral do boleto e paga-lo até a data do seu vencimento, caso o Comprador opte por esse método de pagamento. Após a data limite de pagamento, o boleto deixa de ser válido para a compra e o ingresso/inscrição/contribuição não estará mais reservado para o Comprador.</li>
                                        </ul>

                                        <p>Se esses compromissos forem desrespeitados, a Musa Ticket poderá suspender ou encerrar a conta do Comprador e se recusar a prover quaisquer de nossos serviços. Os ingressos/inscrições/contribuições comprados também poderão ser invalidados.</p>

                                        <h3>2. FORMA DE ENTREGA DOS INGRESSOS</h3>
                                        <ul>
                                            <li>Os ingressos/inscrições/contribuições comprados através da plataforma Musa Ticket são enviados em formato eletrônico (PDF) ao e-mail indicado pelo Comprador tão logo o pagamento é aprovado. Pagamentos aprovados em tempo real habilitam que os ingressos/inscrições/contribuições também sejam baixados na própria tela de confirmação de compra. O Comprador deve ficar atento, pois o ingresso poderá ser direcionado à caixas aleatórias como “spam”, “social” ou “promoções” do endereço de e-mail utilizado, o que não gerará qualquer tipo de indenização ao Comprador;</li>
                                            <li>Além das formas de entrega descritas acima, os ingressos/inscrições/contribuições também podem ser acessados na área autenticada do site ou aplicativo. Para isso, o Comprador deve criar um Usuário gratuitamente na Musa Ticket, fornecendo o mesmo e-mail utilizado no ato da compra. O ingresso pode ser acessado na área “Meus Ingressos” do site ou pelo aplicativo da Musa Ticket.</li>
                                        </ul>

                                        <h3>3. DIREITOS AUTORAIS SOBRE O CONTEÚDO ENVIADO</h3>
                                        <ul>
                                            <li>Ao disponibilizar qualquer conteúdo na nossa plataforma, o Organizador nos concede uma licença não exclusiva e irrevogável para a publicação deste conteúdo;</li>
                                            <li>O Organizador declara que tem todos os direitos necessários para outorgar esta licença e que o seu conteúdo não viola direitos autorais, patentes, marcas, segredo industrial, direito de propriedade, de representação e autoral ou propriedade intelectual de terceiros, visto que o Organizador é o único e exclusivo responsável pelo evento e pela publicação deste conteúdo. Responsabiliza-se, dessa maneira, perante a Musa Ticket ou eventuais terceiros interessados pelas obrigações assumidas no momento em que passa a utilizar a plataforma Musa Ticket;</li>
                                        </ul>

                                        <h3>4. PROCESSAMENTO DE VENDAS</h3>
                                        <h4>Processamento de pagamentos:</h4>
                                        <ul>
                                            <li>O processamento de pagamentos referentes às vendas de ingressos, inscrições e/ou contribuições para eventos inicia-se na página do evento publicado pelo Organizador. Nela, o Comprador indica os ingressos/inscrições/contribuições desejados, escolhe um método de pagamento dentre as opções disponíveis e procede com a finalização da compra. Ao receber a confirmação de aprovação do pagamento, e através de um intermediário financeiro, a Musa Ticket irá recolher o valor correspondente, deduzir a taxa de serviço e repassar ao Organizador o valor restante, de acordo com o modelo de recebimento escolhido. Todas as transações realizadas através da Musa Ticket passam por processos internos, automatizados, de análise de risco que são complementados pelo nosso processador de pagamentos;</li>
                                        </ul>

                                        <hr>
                                    </div>

                                    <!-- Rodapé do Modal -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 mt-3 mt-md-3">
                            <button type="button" id="btnFinalizar" class="btn btn-xlg btn-block btn-success">Pagar Agora</button>   
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $('#btnFinalizar').click(function(event) {
            event.preventDefault();
            $('#loader').show();
            $('#formError').remove();
            $('#form_pedido input').removeClass('field-error');
            $('#btnFinalizar').prop('disabled', true);
            document.getElementById("form_pedido").submit();
        });

       

        // var urlPedidoConfirm = "/evento/8740/checkout-confirm/";
        // var urlCheck3dsPayment = "/evento/8740/check-3ds-payment/";
        // var urlGet3dsPaymentData = "/evento/8740/get-3ds-payment-data/";
        // var urlSeatTableReservation = "/evento/8740/seat-table-reservation/";
        // var gatewayCredit = "mercado_pago";
        // var environment = "SANDBOX";

        // var client = new ClientJS();
        // var fingerprint = client.getFingerprint();
        // $('#id_fingerprint').val(fingerprint);
        // var csrftoken = Cookies.get('csrftoken');
    </script>

<script type="text/javascript">
    window.onload = function() {
        var dados = <?php echo json_encode($dados, 15, 512) ?>; // Passa os dados para o JavaScript
        var participantsTable = document.getElementById('participantsTable');

        dados.forEach(function(cart, index) {
            // Para cada ingresso, criar campos de participantes
            for (var i = 0; i < cart.qtd; i++) {
                var row = document.createElement('tr');
                row.style.backgroundColor = '#f9f9f9';

                var td = document.createElement('td');
                td.innerHTML = '<strong>Ingresso nº ' + (index + 1) + ': ' + cart.ingresso + ':</strong>';
                row.appendChild(td);

                var row2 = document.createElement('tr');
                var td2 = document.createElement('td');
                td2.innerHTML = `
            <label for="id_form-${index}-nome_completo">Nome completo:</label>
            <input type="text" name="form-${index}-nome_completo[]" class="form-control" required="required" id="id_form-${index}-nome_completo">
            <label for="id_form-${index}-email">E-mail:</label>
            <input type="email" name="form-${index}-email[]" class="form-control" required="required" id="id_form-${index}-email">
            <!-- Campo oculto para o ingresso -->
            <input type="hidden" name="form-${index}-ingresso[]" value="${cart.id}" id="id_form-${index}-ingresso">
        `;
                row2.appendChild(td2);
                participantsTable.appendChild(row);
                participantsTable.appendChild(row2);

                // Captura os campos de nome completo e e-mail para replicar
                var nomeCompletoField = document.getElementById(`id_form-${index}-nome_completo`);
                var emailField = document.getElementById(`id_form-${index}-email`);

                // Captura os campos de destino com id fixo
                var nomeCompletoDestino = document.getElementById('id_nome_completo');
                var emailDestino = document.getElementById('id_email');

                // Verifica se os campos existem e adiciona os eventos
                if (nomeCompletoField && nomeCompletoDestino) {
                    nomeCompletoField.addEventListener('input', function() {
                        // Atualiza o campo de destino com o valor do campo original
                        nomeCompletoDestino.value = nomeCompletoField.value;
                    });
                }

                if (emailField && emailDestino) {
                    emailField.addEventListener('input', function() {
                        // Atualiza o campo de destino com o valor do campo original
                        emailDestino.value = emailField.value;
                    });
                }
            }
        });

        $("#id_cep").keyup(function() {
            var numCep = $(this).val().replace(/[\.-]/g, ''); // Remove pontos e traços do CEP
            console.log(numCep.length);
            if (numCep.length === 8) {
                $('#loader').show();
                $('#posCep').show();
                timeout = setTimeout(function() { // Atraso para evitar múltiplas requisições
                    var url = "https://viacep.com.br/ws/" + numCep + "/json/";
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(dados) {
                            if (!dados.erro) {
                                // Preenche os campos com os dados retornados
                                $("#id_cep").val(dados.cep);
                                $("#id_logradouro").val(dados.logradouro);
                                $("#id_bairro").val(dados.bairro);
                                $("#id_cidade").val(dados.localidade);
                                $("#id_uf").val(dados.uf);
                            } else {
                                alert("CEP não encontrado. Verifique o número e tente novamente.");
                            }
                        },
                        error: function() {
                            alert("Não foi possível buscar o CEP. Tente novamente.");
                        }
                    });
                    $('#loader').hide();
                }, 500);

            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base-pg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/site/checkout.blade.php ENDPATH**/ ?>