@extends('site.base')
@section('titulo', 'Pagamento via Pix')
@section('content')
    <div class="min-h-screen bg-gray-100 flex items-center justify-center py-8 px-4">

        {{-- Moldura central --}}
        <div class="bg-white rounded-lg shadow-lg w-full max-w-2xl overflow-hidden">

            {{-- Topo verde com ícone --}}
            <div class="w-full bg-primary-success flex justify-center py-4" style="margin-top: 50px;">
                <div class="bg-green-700 rounded-full p-2">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                    </svg>
                </div>
            </div>

            {{-- Conteúdo --}}
            <div class="px-6 py-8 text-center">
                <h1 class="font-bold text-2xl">Falta pouco!</h1>
                <p class="mt-2 text-lg">
                    Conclua o pagamento de
                    <span class="font-semibold text-green-700">R$ {{ moeda($Pedido->total) }}</span> via Pix
                </p>
                <p class="text-gray-500 text-sm mt-1">
                    Código válido até {{ $Pedido->created_at->addDays(2)->format('d/m/Y \à\s H:i') }}
                </p>

                {{-- Box QR Code --}}
                <div class="bg-white border rounded-lg mt-8 p-6 shadow-sm w-full max-w-md mx-auto">
                    <h2 class="font-semibold mb-2 text-left">Como pagar</h2>
                    <p class="text-sm text-gray-600 mb-4 text-left">Escaneie o código QR com o seu celular:</p>

                    <div class="flex justify-center">
                        <img src="data:image/png;base64,{{ $boleto->qr_code }}" alt="QR Code Pix" class="w-48 h-48">
                    </div>

                    <p class="text-sm text-gray-600 mt-4 text-left">Ou copie o código Pix no app do seu banco:</p>
                    <div class="mt-2">
                        <input type="text" value="{{ $boleto->cod_pix }}" id="codigoPix" class="w-full border rounded px-3 py-2 text-sm text-gray-700" readonly>
                    </div>
                    <button onclick="copiarPix()" class="w-full mt-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-lg transition">
                        Copiar código Pix
                    </button>
                </div>

                {{-- Box descrição --}}
                <div class="bg-white border rounded-lg mt-6 p-4 shadow-sm w-full max-w-md mx-auto flex items-start text-sm text-gray-600">
                    <svg class="w-5 h-5 text-gray-400 mr-2 mt-1" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 11c0-1.1-.9-2-2-2s-2 .9-2 2 .9 2 2 2 2-.9 2-2zM12 22s8-4.5 8-10V5l-8-3-8 3v7c0 5.5 8 10 8 10z" />
                    </svg>
                    <div>
                        <strong>{{ now()->format('d/m/Y') }}</strong> | Compra de ingressos – {{ $Pedido->evento->titulo }}<br>
                        {{ $Pedido->Cliente->email }} – Pedido #{{ $Pedido->id }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        /* ===== Copiar código Pix (com SweetAlert) ===== */
        function copiarPix() {
            const input = document.getElementById("codigoPix");
            if (!input) return;
            const texto = input.value || "";

            function ok() {
                Swal.fire({
                    icon: 'success',
                    title: 'Código Pix copiado!',
                    showConfirmButton: false,
                    timer: 1500
                });
            }

            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(texto).then(ok).catch(ok);
            } else {
                input.select();
                input.setSelectionRange(0, 99999);
                document.execCommand("copy");
                ok();
            }
        }

        /* ===== AJAX (CSRF) ===== */
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        /* ===== Polling ASAAS: segue checando a cada 2s enquanto não for RECEIVED ===== */
        let pollTimer = null;
        let stopped = false;

        function stopPolling() {
            stopped = true;
            if (pollTimer) {
                clearTimeout(pollTimer);
                pollTimer = null;
            }
        }

        function scheduleNext(ms = 2000) {
            if (stopped) return;
            pollTimer = setTimeout(checkStatus, ms);
        }

        function checkStatus() {
            if (stopped) return;

            $.ajax({
                    url: "{{ route('retorno.asaas', $boleto->id) }}",
                    method: "GET"
                })
                .done(function(result) {
                    const status = (result && result.response) ? String(result.response) : "";
                    console.log("ASAAS status:", status);

                    if (status === "RECEIVED") {
                        stopPolling();
                        Swal.fire({
                            title: "Pagamento Confirmado",
                            html: "Você está sendo redirecionado...",
                            timer: 2000,
                            timerProgressBar: true,
                            didOpen: () => Swal.showLoading(),
                            willClose: () => {
                                window.location.href = "{{ route('success', $Pedido->id) }}";
                            }
                        });
                    } else {
                        // qualquer outro status → continua verificando em 2s
                        scheduleNext(2000);
                    }
                })
                .fail(function() {
                    // erro de rede/servidor → tenta novamente em 2s
                    scheduleNext(2000);
                });
        }

        // Inicia o polling
        stopped = false;
        scheduleNext(2000);

        // (opcional) interrompe se usuário sair da página
        window.addEventListener("beforeunload", stopPolling);
    </script>
@endsection
