@extends('site.base')
@section('titulo', 'Locais com Eventos | Musa Ticket')
@section('description', 'Descubra os melhores locais com eventos disponíveis na Musa Ticket. Confira os espaços, endereços e garanta já seus ingressos!')
@section('url', route('site.eventos'))
@section('image', url('site/images/favicon.png'))

{{-- SEO estruturado para locais --}}
@section('application_ld_json')
    <script type="application/ld+json">
{!! json_encode([
    '@context' => 'https://schema.org',
    '@graph' => $locais->map(function ($local) {
        return [
            '@type' => 'Place',
            'name' => $local->local,
            'url'  => route('site.local', [$local->url,$local->id]),
            'address' => [
                '@type' => 'PostalAddress',
                'streetAddress'   => $local->endereco_site ?? ($local->endereco . ', ' . $local->numero),
                'addressLocality' => $local->cidade,
                'addressRegion'   => $local->estado,
                'postalCode'      => $local->cep,
                'addressCountry'  => 'BR',
            ],
            'image' => [$local->logo],
            'description' => strip_tags($local->descricao ?? 'Local parceiro da Musa Ticket com eventos disponíveis.'),
        ];
    })
], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>
@endsection

@section('content')
    <div class="pt-[64px]">
        <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
            <div class="flex flex-col pt-6 md:pt-10 w-full">
                <div class="my-4">
                    <h1 class="font-bold text-2xl md:text-3xl text-primary-green">Locais com eventos</h1>
                </div>

                <section class="w-full mt-8 gap-8 grid grid-cols-2 md:grid-cols-4 3xl:grid-cols-5 pb-16">
                    @forelse ($locais as $local)
                        <a href="{{ route('site.local', [$local->url, $local->id]) }}">
                            <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                                <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-48 h-32">
                                    <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $local->logo ?: url('site/images/placeholder-local.webp') }}"
                                        alt="{{ $local->local }}" loading="lazy" />
                                </div>
                                <div class="px-4 pb-4 pt-2 flex flex-col">
                                    <h2 class="text-lg font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition">
                                        {{ $local->local }}
                                    </h2>
                                    <p class="text-sm text-gray-dark mt-1">
                                        {{ $local->bairro }}, {{ $local->cidade }}-{{ $local->estado }}
                                    </p>
                                    <p class="text-xs text-gray-light mt-1 line-clamp-2">
                                        {{ $local->endereco_site }}
                                    </p>
                                </div>
                            </div>
                        </a>
                    @empty
                        <p class="text-gray-dark">Nenhum local com eventos disponíveis no momento.</p>
                    @endforelse
                </section>
            </div>
        </div>
    </div>
@endsection
