@extends('site.base')
@section('titulo', 'UCESUB')
@section('url', route('site.home'))
@section('description', 'Carteira de Estudante UCESUB. Garanta já a sua!')
@section('image', url('site/images/favicon.png'))
@section('application_ld_json')
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "name": "UCESUB",
  "url": "{{ url('/') }}",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "{{ url('/buscar') }}/{search_term_string}",
    "query-input": "required name=search_term_string"
  }
}
</script>
@endsection
@section('content')
    <main>
        <!-- ================= HERO / SLIDER (refeito com fallbacks) ================ -->
        <section class="h-fit" style="opacity:1">
            <div class="min-w-full w-full relative">
                <div class="overflow-hidden w-full relative mt-[72px]">
                    @php
                        // Usa $hero se tiver conteúdo, senão filtra os eventos com banner_principal preenchido
                        $heroEventos = !empty($hero) ? $hero : $eventos->where('banner_principal', '!=', '');

                        // Garante que é contável
                        $heroCount = is_countable($heroEventos) ? count($heroEventos) : 0;
                    @endphp

                    <div id="hero-track" class="flex transition-transform duration-700 ease-in-out h-full" style="transform: translateX(0%)">
                        @foreach ($heroEventos as $i => $evento)
                            @php
                                // Fallbacks seguros
                                $hTitulo = $evento->titulo ?? ($evento['titulo'] ?? 'Evento');
                                $hUrl = $evento->url ?? ($evento['url'] ?? '#');
                                $hImg = $evento->banner_principal ?? ($evento['banner_principal'] ?? url('site/images/placeholder-evento.webp'));
                            @endphp

                            <div class="slide min-w-full relative cursor-pointer">
                                <a href="{{ route('site.evento', [$hUrl, $evento->id]) }}" aria-label="{{ $hTitulo }}">
                                    <img class="w-full h-auto max-h-screen sm:h-[650px] md:h-[800px] object-contain sm:object-cover object-top" src="{{ $evento->banner_principal }}" alt="{{ $hTitulo }}" loading="{{ $i === 0 ? 'eager' : 'lazy' }}"
                                        decoding="async" fetchpriority="{{ $i === 0 ? 'high' : 'auto' }}" />
                                </a>
                            </div>
                        @endforeach
                    </div>

                    @if ($heroCount > 1)
                        <!-- Navegação numérica (direita) -->
                        <div class="hidden lg:flex absolute top-1/2 right-0 -translate-y-1/2 justify-end items-center p-6 z-[999]">
                            <div id="hero-indexes" class="flex flex-col justify-center items-center gap-y-2">
                                @foreach ($heroEventos as $i => $evento)
                                    <div class="flex flex-col items-center">
                                        <button class="index-btn cursor-pointer" data-index="{{ $i }}">
                                            <h1 class="text-2xl font-bold text-primary-white {{ $i === 0 ? '' : 'text-opacity-60' }}">
                                                {{ sprintf('%02d', $loop->iteration) }}
                                            </h1>
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <!-- Setas -->
                        <div class="absolute bottom-0 right-0 flex justify-end items-end p-6 z-25">
                            <div class="flex flex-col gap-y-4">
                                <button id="hero-prev" class="bg-green-button hover:bg-green-hover rounded-full p-1 md:p-1" aria-label="Anterior">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#023324" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-left">
                                        <path d="m15 18-6-6 6-6"></path>
                                    </svg>
                                </button>
                                <button id="hero-next" class="bg-green-button hover:bg-green-hover rounded-full p-1 md:p-1" aria-label="Próximo">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#023324" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-chevron-right">
                                        <path d="m9 18 6-6-6-6"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    @endif
                </div>

                <!-- gradiente lateral opcional -->
                <div class="absolute top-0 right-0 bottom-0 left-1/2 bg-gradient-to-r from-transparent to-black opacity-50 pointer-events-none"></div>
            </div>
        </section>

        <script>
            (function() {
                const track = document.getElementById('hero-track');
                if (!track) return;

                const slides = Array.from(track.querySelectorAll('.slide'));
                const total = slides.length;

                // Sem slides? Não iniciar carrossel.
                if (total === 0) return;

                let index = 0;
                const prevBtn = document.getElementById('hero-prev');
                const nextBtn = document.getElementById('hero-next');
                const indexBtns = Array.from(document.querySelectorAll('.index-btn'));
                const INTERVAL = 5000; // ms
                const DURATION = 700; // deve casar com duration-700
                let timer;

                function goTo(i) {
                    if (total === 0) return;
                    index = ((i % total) + total) % total;
                    track.style.transform = `translateX(-${index * 100}%)`;
                    indexBtns.forEach((btn, k) => {
                        const h1 = btn.querySelector('h1');
                        if (!h1) return;
                        if (k === index) h1.classList.remove('text-opacity-60');
                        else if (!h1.classList.contains('text-opacity-60')) h1.classList.add('text-opacity-60');
                    });
                }

                function start() {
                    stop();
                    if (total > 1) timer = setInterval(() => goTo(index + 1), INTERVAL);
                }

                function stop() {
                    if (timer) clearInterval(timer);
                }

                prevBtn && prevBtn.addEventListener('click', () => {
                    goTo(index - 1);
                    start();
                });
                nextBtn && nextBtn.addEventListener('click', () => {
                    goTo(index + 1);
                    start();
                });
                indexBtns.forEach(btn => {
                    btn.addEventListener('click', () => {
                        goTo(parseInt(btn.dataset.index, 10) || 0);
                        start();
                    });
                });

                const wrapper = track.parentElement;
                if (wrapper) {
                    wrapper.addEventListener('mouseenter', stop);
                    wrapper.addEventListener('mouseleave', start);
                }

                track.style.transition = `transform ${DURATION}ms ease`;
                goTo(0);
                start();
            })();
        </script>

        @if (count($hoje) > 0)

            <!-- ================= EVENTOS DE HOJE (dinâmico/seguro) ================= -->
            <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
                <section id="featuredEvents" class="h-auto bg-primary-white py-4 md:py-12">
                    <div class="flex flex-col gap-y-4 md:gap-y-0 md:flex-row justify-between md:items-center">
                        <div>
                            <h1 class="font-bold text-3xl md:text-4xl text-primary-musa">
                                Eventos imperdíveis de hoje!
                            </h1>
                            <h2 class="text-gray-dark text-lg md:text-xl mt-1">
                                Descubra onde aproveitar a vibe e curtir as melhores experiências agora mesmo 🎉
                            </h2>
                        </div>
                        <div class="flex gap-x-4">
                            <button id="feat-prev" class="bg-primary-green hover:bg-primary-green/90 rounded-full p-1 md:p-1" aria-label="Anterior">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#E9F2F0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-left">
                                    <path d="m15 18-6-6 6-6"></path>
                                </svg>
                            </button>
                            <button id="feat-next" class="bg-primary-green hover:bg-primary-green/90 rounded-full p-1 md:p-1" aria-label="Próximo">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#E9F2F0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-right">
                                    <path d="m9 18 6-6-6-6"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    @php
                        // usa $top; evita erro se vier nulo
                        $ParaHoje = $hoje ?? [];
                    @endphp
                    @if (count($ParaHoje))
                        <!-- CARROSSEL -->
                        <div class="mt-5">
                            <div id="feat-carousel" class="flex gap-4 overflow-x-auto scroll-smooth snap-x snap-mandatory pb-2" style="-ms-overflow-style:none;scrollbar-width:none">
                                {{-- esconda scrollbar em navegadores webkit (opcional, via inline) --}}
                                <style>
                                    #feat-carousel::-webkit-scrollbar {
                                        display: none
                                    }
                                </style>

                                @foreach ($ParaHoje as $e)
                                    @php
                                        $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
                                        $url = $e->url ?? ($e['url'] ?? '#');
                                        $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
                                        $cidade = $e->cidade ?? ($e['cidade'] ?? '');
                                        $uf = $e->estado ?? ($e['estado'] ?? '');
                                        $local = $e->local . ' - ' . trim(($cidade ?: '') . ($uf ? ' / ' . $uf : '')) ?: $e->local ?? ($e['local'] ?? 'Local a definir');
                                        $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
                                        $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
                                        $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
                                    @endphp

                                    <a href="{{ route('site.evento', [$e->url, $e->id]) }}" class="snap-start shrink-0 w-[85%] sm:w-[60%] md:w-[50%] lg:w-[25%]">
                                        <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                                            <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                                                <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}"
                                                    alt="{{ $titulo }}" loading="lazy" />
                                            </div>
                                            <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                                                <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">
                                                    {{ $titulo }}
                                                </h1>
                                                <div class="flex flex-col mt-auto">
                                                    <div class="mt-2 mb-1 gap-2 flex items-center">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round" class="lucide lucide-map-pin text-gray-light">
                                                            <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                                            <circle cx="12" cy="10" r="3"></circle>
                                                        </svg>
                                                        <p class="text-sm text-gray-dark uppercase">{{ $local }}</p>
                                                    </div>
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round" class="lucide lucide-calendar-days text-gray-light">
                                                            <path d="M8 2v4"></path>
                                                            <path d="M16 2v4"></path>
                                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                            <path d="M3 10h18"></path>
                                                        </svg>
                                                        <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @else
                        <div class="mt-5">
                            <p class="text-gray-dark">Nenhum evento em destaque no momento.</p>
                        </div>
                    @endif
                </section>
            </div>
        @endif

        <!-- ================= DESTAQUES (dinâmico/seguro) ================= -->
        <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
            <section id="featuredEvents" class="h-auto bg-primary-white py-4 md:py-12">
                <div class="flex flex-col gap-y-4 md:gap-y-0 md:flex-row justify-between md:items-center">
                    <div>
                        <h1 class="font-bold text-2xl md:text-3xl text-primary-musa">Eventos mais Visitados</h1>
                        <h2 class="text-gray-dark text-lg">Acompanhe nossos eventos em destaque</h2>
                    </div>
                    <div class="flex gap-x-4">
                        <button id="feat-prev" class="bg-primary-green hover:bg-primary-green/90 rounded-full p-1 md:p-1" aria-label="Anterior">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#E9F2F0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                class="lucide lucide-chevron-left">
                                <path d="m15 18-6-6 6-6"></path>
                            </svg>
                        </button>
                        <button id="feat-next" class="bg-primary-green hover:bg-primary-green/90 rounded-full p-1 md:p-1" aria-label="Próximo">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="#E9F2F0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                class="lucide lucide-chevron-right">
                                <path d="m9 18 6-6-6-6"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                @php
                    // usa $top; evita erro se vier nulo
                    $destaques = $top ?? [];
                @endphp
                @if (count($destaques))
                    <!-- CARROSSEL -->
                    <div class="mt-5">
                        <div id="feat-carousel" class="flex gap-4 overflow-x-auto scroll-smooth snap-x snap-mandatory pb-2" style="-ms-overflow-style:none;scrollbar-width:none">
                            {{-- esconda scrollbar em navegadores webkit (opcional, via inline) --}}
                            <style>
                                #feat-carousel::-webkit-scrollbar {
                                    display: none
                                }
                            </style>

                            @foreach ($destaques as $e)
                                @php
                                    $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
                                    $url = $e->url ?? ($e['url'] ?? '#');
                                    $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
                                    $cidade = $e->cidade ?? ($e['cidade'] ?? '');
                                    $uf = $e->estado ?? ($e['estado'] ?? '');
                                    $local = $e->local . ' - ' . trim(($cidade ?: '') . ($uf ? ' / ' . $uf : '')) ?: $e->local ?? ($e['local'] ?? 'Local a definir');
                                    $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
                                    $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
                                    $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
                                @endphp

                                <a href="{{ route('site.evento', [$e->url, $e->id]) }}" class="snap-start shrink-0 w-[85%] sm:w-[60%] md:w-[50%] lg:w-[25%]">
                                    <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                                        <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                                            <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}"
                                                alt="{{ $titulo }}" loading="lazy" />
                                        </div>
                                        <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                                            <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">
                                                {{ $titulo }}
                                            </h1>
                                            <div class="flex flex-col mt-auto">
                                                <div class="mt-2 mb-1 gap-2 flex items-center">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="lucide lucide-map-pin text-gray-light">
                                                        <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                                        <circle cx="12" cy="10" r="3"></circle>
                                                    </svg>
                                                    <p class="text-sm text-gray-dark uppercase">{{ $local }}</p>
                                                </div>
                                                <div class="flex items-center gap-2 mt-2">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="lucide lucide-calendar-days text-gray-light">
                                                        <path d="M8 2v4"></path>
                                                        <path d="M16 2v4"></path>
                                                        <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                        <path d="M3 10h18"></path>
                                                    </svg>
                                                    <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="mt-5">
                        <p class="text-gray-dark">Nenhum evento em destaque no momento.</p>
                    </div>
                @endif
            </section>
        </div>

        <script>
            (function() {
                const container = document.getElementById('feat-carousel');
                const prev = document.getElementById('feat-prev');
                const next = document.getElementById('feat-next');
                if (!container || !prev || !next) return;

                const page = () => container.clientWidth;

                function scrollLeft() {
                    container.scrollBy({
                        left: -page(),
                        behavior: 'smooth'
                    });
                }

                function scrollRight() {
                    container.scrollBy({
                        left: page(),
                        behavior: 'smooth'
                    });
                }

                function updateNav() {
                    const atStart = container.scrollLeft <= 0;
                    const atEnd = Math.ceil(container.scrollLeft + container.clientWidth) >= container.scrollWidth;

                    prev.disabled = atStart;
                    next.disabled = atEnd;

                    prev.classList.toggle('opacity-50', atStart);
                    next.classList.toggle('opacity-50', atEnd);
                    prev.classList.toggle('cursor-not-allowed', atStart);
                    next.classList.toggle('cursor-not-allowed', atEnd);
                }

                prev.addEventListener('click', scrollLeft);
                next.addEventListener('click', scrollRight);
                container.addEventListener('scroll', updateNav, {
                    passive: true
                });
                window.addEventListener('resize', updateNav);

                // setas via teclado quando focado
                container.setAttribute('tabindex', '0');
                container.addEventListener('keydown', (e) => {
                    if (e.key === 'ArrowLeft') scrollLeft();
                    if (e.key === 'ArrowRight') scrollRight();
                });

                // init
                updateNav();
            })();
        </script>


        <!-- ================= BLOCO PESQUISA (mantido) ================= -->
        <div class="relative bg-primary-white">
            <div class="px-4 md:px-0 flex flex-col md:items-center py-4 md:py-14 md:justify-center bg-primary-green h-auto relative">
                <h1 class="text-green-light text-2xl md:text-3xl">Pesquise eventos na {{ env('EMPRESA') }}, é rápido e fácil!</h1>
                <div class="flex flex-col lg:flex-row items-center justify-center w-full md:max-w-[75%] gap-x-4 gap-y-4 lg:gap-y-0 mt-4 md:mt-6 z-20">
                    <div class="w-full">
                        <div class="relative w-full truncate">
                            <span class="w-full" data-pc-name="autocomplete" data-pc-section="root" id="pr_id_1">
                                <input id="get-evento"
                                    class="w-full md:h-10 h-11 px-4 rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-white bg-green-light text-ellipsis overflow-hidden whitespace-nowrap"
                                    type="text" placeholder="Nome do evento" />
                            </span>
                            <button class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-party-popper absolute right-3 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                                    <path d="M5.8 11.3 2 22l10.7-3.79"></path>
                                    <path d="M4 3h.01"></path>
                                    <path d="M22 8h.01"></path>
                                    <path d="M15 2h.01"></path>
                                    <path d="M22 20h.01"></path>
                                    <path d="m22 2-2.24.75a2.9 2.9 0 0 0-1.96 3.12c.1.86-.57 1.63-1.45 1.63h-.38c-.86 0-1.6.6-1.76 1.44L14 10"></path>
                                    <path d="m22 13-.82-.33c-.86-.34-1.82.2-1.98 1.11c-.11.7-.72 1.22-1.43 1.22H17"></path>
                                    <path d="m11 2 .33.82c.34.86-.2 1.82-1.11 1.98C9.52 4.9 9 5.52 9 6.23V7"></path>
                                    <path d="M11 13c1.93 1.93 2.83 4.17 2 5-.83.83-3.07-.07-5-2-1.93-1.93-2.83-4.17-2-5 .83-.83 3.07.07 5 2Z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="w-full">
                        <div class="relative h-full w-auto">
                            <input class="bg-green-light w-full md:h-10 h-11 px-4 rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-white" placeholder="Local" type="text"
                                value="" />
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <button class="">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-map-pin absolute right-1 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                                        <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                        <circle cx="12" cy="10" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="relative w-full">
                        <div class="react-datepicker-wrapper">
                            <div class="react-datepicker__input-container">
                                <input placeholder="Selecione a data" class="w-full px-4 rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-white bg-green-light md:h-10 h-11"
                                    type="text" value="" />
                            </div>
                        </div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="lucide lucide-calendar-days absolute right-3 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                            <path d="M8 2v4"></path>
                            <path d="M16 2v4"></path>
                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                            <path d="M3 10h18"></path>
                        </svg>
                    </div>
                    <div class="w-full">
                        <button type="button" class="bg-green-button w-full flex hover:bg-green-hover rounded-full px-12 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed">
                            <div class="flex items-center w-full justify-center">
                                <div class=""><span class="text-center text-primary-musa">Pesquisar evento</span></div>
                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                            </div>
                        </button>
                    </div>
                </div>
                {{-- <div class="absolute left-0 h-full z-10 opacity-50 hidden lg:block">
                            <img alt="Logo" loading="lazy" width="500" height="500" decoding="async" data-nimg="1" class="h-full w-full" style="color: transparent"
                                srcset="/_next/image?url=%2Fimages%2Fbig_logo_left.png&amp;w=800&amp;q=75 1x, /_next/image?url=%2Fimages%2Fbig_logo_left.png&amp;w=1200&amp;q=75 2x"
                                src="{{ url('site') }}//_next/image?url=%2Fimages%2Fbig_logo_left.png&amp;w=1200&amp;q=75" />
                        </div>
                        <div class="absolute right-0 h-full z-10 opacity-50 hidden lg:block">
                            <img alt="Logo" loading="lazy" width="500" height="500" decoding="async" data-nimg="1" class="h-full w-full" style="color: transparent"
                                srcset="/_next/image?url=%2Fimages%2Fbig_logo_right.png&amp;w=800&amp;q=75 1x, /_next/image?url=%2Fimages%2Fbig_logo_right.png&amp;w=1200&amp;q=75 2x"
                                src="{{ url('site') }}//_next/image?url=%2Fimages%2Fbig_logo_right.png&amp;w=1200&amp;q=75" />
                        </div> --}}
            </div>
        </div>

        <!-- ================= PRÓXIMOS EVENTOS (dinâmico/seguro) ================= -->
        <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
            <section id="thisWeekEvents" class="h-auto py-4 md:py-12">
                <div class="flex items-center justify-between w-full">
                    <div>
                        <h1 class="font-bold text-2xl md:text-3xl text-primary-musa">Próximos eventos</h1>
                        <h2 class="text-gray-dark text-lg">Acompanhe os nossos próximos eventos</h2>
                    </div>
                    <div class="hidden md:block">
                        <a href="{{ url('site') }}//events">
                            <button class="flex items-center gap-x-1">
                                <h1 class="text-gray-dark font-bold">Ver todos</h1>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-chevron-right text-[#2C2C2C]">
                                    <path d="m9 18 6-6-6-6"></path>
                                </svg>
                            </button>
                        </a>
                    </div>
                </div>
                <div id="resultado-eventos">
                    @php
                        $proximosEventos = $listaProximos ?? ($proximos ?? ($eventos ?? []));
                    @endphp
                    <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mt-5 transition-all duration-500 ease-in">
                        @forelse ($proximosEventos as $e)
                            @php
                                $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
                                $url = $e->url ?? ($e['url'] ?? '#');
                                $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
                                $cidade = $e->cidade ?? ($e['cidade'] ?? '');
                                $uf = $e->estado ?? ($e['estado'] ?? '');
                                $local = $e->local . ' - ' . trim(($cidade ?: '') . ($uf ? ' / ' . $uf : '')) ?: $e->local ?? ($e['local'] ?? 'Local a definir');
                                $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
                                $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
                                $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
                            @endphp
                            <a href="{{ route('site.evento', [$e->url, $e->id]) }}">
                                <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                                    <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                                        <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}"
                                            alt="{{ $titulo }}" loading="lazy" />
                                    </div>
                                    <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                                        <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">{{ $titulo }}</h1>
                                        <div class="flex flex-col mt-auto">
                                            <div class="mt-2 mb-1 gap-2 flex items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="lucide lucide-map-pin text-gray-light">
                                                    <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                                    <circle cx="12" cy="10" r="3"></circle>
                                                </svg>
                                                <p class="text-sm text-gray-dark uppercase">{{ $local }}</p>
                                            </div>
                                            <div class="flex items-center gap-2 mt-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="lucide lucide-calendar-days text-gray-light">
                                                    <path d="M8 2v4"></path>
                                                    <path d="M16 2v4"></path>
                                                    <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                    <path d="M3 10h18"></path>
                                                </svg>
                                                <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @empty
                            <div class="col-span-2 lg:col-span-4">
                                <p class="text-gray-dark">Nenhum evento encontrado.</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </section>
        </div>

        <!-- ================= CTA (mantido) ================= -->
        <div class="relative bg-musa-ticket">
            <div class="h-[500px] flex flex-col justify-center items-center gap-y-5">
                <div style="padding: 20px; margin-top: 30px;">
                    <h1 class="text-green-light text-2xl md:text-3xl font-bold" style="text-align: center; margin-top: 30px;">✨ A UCESUB chegou para revolucionar!</h1>
                </div>
                <div>
                    <p class="text-green-light max-w-2xl text-center text-lg px-4 md:px-0">
                        A plataforma mais inteligente e inovadora do entretenimento. <br>
                        Com tecnologia de ponta e soluções em IA, oferecemos suporte completo para o seu evento — da venda de ingressos ao marketing automatizado, sempre com eficiência, segurança e inovação para você ter o máximo de
                        resultados.
                    </p>
                </div>
                <div>
                    <a target="_blank" href="https://api.whatsapp.com/send?phone=55{{ env('WHATSAPP') }}">
                        <button type="button" class="bg-green-button w-full flex hover:bg-green-hover rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed">
                            <div class="flex items-center w-full justify-center">
                                <div class=""><span class="text-center text-primary-musa">Divulgue seu Evento</span></div>
                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                            </div>
                        </button>
                    </a>
                </div>
            </div>
        </div>

        <!-- ================= MARQUEE (mantido) ================= -->
        <div class="w-full overflow-hidden bg-primary-white text-primary-musa py-1 flex items-center cursor-pointer">
            <div class="animate-scroll whitespace-nowrap">
                <span class="text-lg font-bold text-primary-musa">
                    UCESUB - OS MELHORES EVENTOS ESTÃO AQUI
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="lucide lucide-ticket text-primary-musa inline-block mx-2">
                        <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                        <path d="M13 5v2"></path>
                        <path d="M13 17v2"></path>
                        <path d="M13 11v2"></path>
                    </svg>
                    UCESUB - OS MELHORES EVENTOS ESTÃO AQUI
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="lucide lucide-ticket text-primary-musa inline-block mx-2">
                        <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                        <path d="M13 5v2"></path>
                        <path d="M13 17v2"></path>
                        <path d="M13 11v2"></path>
                    </svg>
                    UCESUB - OS MELHORES EVENTOS ESTÃO AQUI
                </span>
            </div>
        </div>
        @include('site.footer')
    </main>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            let timer = null;

            $("#get-evento").on("keyup", function() {
                clearTimeout(timer); // evita flood ao digitar rápido
                let termo = $(this).val();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                timer = setTimeout(function() {
                    if (termo.length > 2) { // só busca se tiver mais de 2 caracteres
                        $.ajax({
                            url: "{{ route('site.buscar') }}", // crie a rota no web.php
                            type: "POST",
                            data: {
                                s: termo
                            },
                            success: function(res) {
                                $("#resultado-eventos").html(res); // div onde você vai renderizar
                            },
                            error: function() {
                                $("#resultado-eventos").html("<p class='text-red-500'>Erro ao buscar eventos.</p>");
                            }
                        });
                    } else {
                        $("#resultado-eventos").empty();
                    }
                }, 300); // espera 300ms depois do último keyup
            });
        });
    </script>
@endsection
