@extends('site.base')
@section('titulo', $evento->titulo)
@section('url', route('site.evento', [$evento->url, $evento->id]))
@section('description', lmword($evento->descricao, 180))
@section('image', $evento->banner)
@section('analytics', $evento->analytics)
@section('ads', $evento->ads)
@section('pixel', $evento->pixel ?? env('PIXEL'))
@section('pixel_track', 'PageView')
@section('application_ld_json')
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Event",
  "name": "{{ $evento->titulo }}",
  "startDate": "{{ \Carbon\Carbon::parse($evento->data_inicio)->toIso8601String() }}",
  "endDate": "{{ \Carbon\Carbon::parse($evento->data_fim)->toIso8601String() }}",
  "eventAttendanceMode": "https://schema.org/OfflineEventAttendanceMode",
  "eventStatus": "https://schema.org/EventScheduled",
  "location": {
    "@type": "Place",
    "name": "{{ $evento->local }}",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "{{ $evento->endereco_site }}",
      "addressLocality": "{{ $evento->cidade }}",
      "addressRegion": "{{ $evento->estado }}",
      "addressCountry": "BR"
    }
  },
  "organizer": {
    "@type": "Organization",
    "name": "Musa Ticket",
    "url": "https://musaticket.com.br"
  },
  "image": ["{{ $evento->banner }}"],
  "description": {!! json_encode(strip_tags($evento->descricao)) !!},
  "offers": {
    "@type": "Offer",
    "url": "{{ route('site.evento', [$evento->url, $evento->id]) }}",
    "price": "{{ moeda2($evento->Pacotes->first()?->preco) }}",
    "priceCurrency": "BRL",
    "availability": "https://schema.org/InStock",
    "validFrom": "{{ \Carbon\Carbon::parse($evento->Pacotes->first()?->data_inicio ?? $evento->data_inicio)->toIso8601String() }}"
  },
  "performer": {
    "@type": "PerformingGroup",
    "name": "{{ $evento->artistas ?? 'Atrações confirmadas' }}"
  }
}
</script>
@endsection

@section('content')
    <main class="h-full relative">
        {{-- HERO --}}
        <div class="relative w-full h-full pt-[72px] bg-[#e9e9e9]">
            <div class="absolute inset-0 w-full h-full bg-cover bg-center hidden lg:block" style="background-image:url('{{ $evento->banner }}')"></div>
            <div class="absolute inset-0 bg-white/50 backdrop-blur-xl"></div>

            <div class="relative z-10 flex flex-col lg:flex-row lg:items-center justify-center w-full h-full lg:min-h-screen gap-4">
                <div class="flex justify-center lg:w-[400px] lg:h-[400px] w-full h-full lg:max-h-[400px]">
                    <img class="lg:w-[400px] lg:h-[400px] w-full h-full object-cover rounded-none lg:rounded-2xl" src="{{ $evento->banner }}" alt="Imagem" sizes="100vw" srcset="{{ $evento->banner }}" />
                </div>

                <div class="flex flex-col gap-4 px-4 pb-6 pt-0 lg:px-6 lg:pt-6 max-w-md">
                    <div class="flex justify-between gap-4">
                        <h1 class="text-2xl lg:text-4xl text-gray-info font-bold">{{ $evento->titulo }}</h1>
                    </div>
                    <div class="flex items-center gap-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="none" stroke="#303030" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-calendar-check">
                            <path d="M8 2v4"></path>
                            <path d="M16 2v4"></path>
                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                            <path d="M3 10h18"></path>
                            <path d="m9 16 2 2 4-4"></path>
                        </svg>
                        <h2 class="text-gray-info text-base">
                            <span class="font-bold">Válida até:</span>
                            {{ mb_substr($semana[date('w', strtotime($evento->data_fim))], 0, 3, 'UTF-8') }},
                            {{ date('d', strtotime($evento->data_fim)) }} de {{ $mes[date('m', strtotime($evento->data_fim))] }} de {{ date('Y', strtotime($evento->data_fim)) }}
                        </h2>
                    </div>

                    {{-- botão âncora (scroll) --}}
                    <div class="lg:flex items-center justify-between mt-2 hidden" style="width: 200px">
                        <button id="btn-comprar" type="button" class="bg-primary-green w-full flex hover:bg-primary-green/90 rounded-full px-12 py-[0.6rem]">
                            <span class="text-center text-green-light">Solicite Agora</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div id="rolar_pagina"></div>

        {{-- CONTEÚDO + MAPA + INFORMAÇÕES --}}
        <div id="ingressos" class="flex flex-col lg:flex-row h-auto justify-center lg:my-12 px-4 lg:px-0">
            <div class="w-full h-auto flex flex-col lg:flex-row lg:justify-center lg:gap-12">

                {{-- Coluna Esquerda --}}
                <div class="flex flex-col w-full lg:w-[60%] order-2 lg:order-1">

                    <div class="w-full p-6 bg-[#e9e9e9] rounded-2xl lg:mb-5">
                        <div class="flex flex-col lg:flex-row lg:items-center justify-between mb-8">
                            <h2 class="font-bold text-[#2c2c2c] text-2xl lg:text-3xl">Informações gerais</h2>
                        </div>
                        <div class="text-base lg:text-lg leading-relaxed text-gray-dark">
                            <p>🚨 <strong>{{ $evento->titulo }}</strong></p>
                            <p><br /></p>
                            <p><strong>Validade:</strong>
                                {{ $semana[date('w', strtotime($evento->data_fim))] }},
                                {{ date('d', strtotime($evento->data_fim)) }} de {{ $mes[date('m', strtotime($evento->data_fim))] }} de {{ date('Y', strtotime($evento->data_fim)) }}
                            </p>
                            {!! $evento->descricao !!}
                        </div>
                    </div>


                    <div class="lg:border lg:border-gray-200 w-full p-6 bg-[#e9e9e9] rounded-2xl mt-6 lg:mt-0 mb-6 lg:mb-0">
                        <h2 class="font-bold text-[#2c2c2c] text-2xl lg:text-3xl mb-4">Informações Importantes</h2>
                        <div class="text-base lg:text-lg leading-relaxed text-justify text-gray-dark">
                            <p>1. A organização do evento não é de responsabilidade da {{ env('EMPRESA') }}. Alterações de data, horário, local ou qualquer descumprimento do informado são de inteira responsabilidade da produtora.</p>
                            <p>2. É indispensável a apresentação do ingresso digital; em alguns eventos pode ser solicitado documento oficial com foto para acesso.</p>
                            <p>3. Reembolsos: WhatsApp {{ env('WHATSAPP') }}, em até 7 dias da compra e no máximo 48h antes do evento, com documento oficial com foto.</p>
                            <p>4. Em devolução por arrependimento, a taxa administrativa não é restituída.</p>
                            <div class="my-4 flex flex-col lg:items-center lg:flex-row gap-3 lg:gap-6">
                                <a class="open-modal text-primary-green underline underline-offset-4 cursor-pointer" data-type="termos">TERMOS DE USO</a>
                                <a class="open-modal text-primary-green underline underline-offset-4 cursor-pointer" data-type="privacidade">POLÍTICA DE PRIVACIDADE</a>
                            </div>

                            {{-- Modal --}}
                            <div id="customModal" class="fixed inset-0 bg-black/70 hidden justify-center items-center z-[9999]">
                                <div class="bg-white rounded-xl shadow-lg max-w-2xl w-[95%] p-6 relative">
                                    <button id="closeModal" class="absolute top-3 right-3 text-gray-600 hover:text-red-500 text-xl">✖</button>
                                    <h3 id="modalTitle" class="text-2xl font-bold mb-4">Título</h3>
                                    <div id="modalContent" class="text-gray-700 text-base leading-relaxed overflow-y-auto max-h-[70vh] pr-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Coluna Direita: FORM DE COMPRA --}}
                <form id="form_ing" class="w-full lg:w-[33%] 4xl:w-[25%] h-fit lg:bg-[#e9e9e9] lg:rounded-2xl lg:p-6 order-1 lg:order-2" style="margin:60px 0 30px 0;" action="{{ route('cart') }}" method="POST"
                    onsubmit="return validFormCompraMin(this);">
                    @csrf
                    <input type="hidden" name="evento_id" value="{{ (int) $evento->id }}">

                    <div class="items-center justify-between hidden lg:flex mb-4 gap-x-8">
                        <h2 class="font-bold text-[#2c2c2c] text-3xl">Tipos de Carteiras</h2>
                    </div>

                    <div class="w-full rounded-2xl">
                        <div class="rounded-2xl scrollbar-none overflow-auto">
                            {{-- Cabeçalho fixo --}}
                            <div class="w-full p-3 bg-green-button flex justify-between items-center rounded-t-2xl">
                                <h3 class="text-[#2c2c2c] font-bold">Preços</h3>
                                <div>
                                    <i class="fas fa-shopping-cart text-primary-green"></i>
                                    <span id="cart_total" class="font-bold text-primary-green text-base lg:text-lg">R$ 0,00</span>
                                </div>
                            </div>

                            @php
                                $hoje = now();
                                $cupomSessao = session('cupom');
                            @endphp

                            @foreach ($evento->Pacotes->where('status', 'Ativo') as $pacote)
                                @php
                                    $dataInicio = \Carbon\Carbon::parse($pacote->data_inicio);
                                    $dataFim = \Carbon\Carbon::parse($pacote->data_fim);

                                    $vendidos = $pacote->Ingressos->where('status', '1')->count();
                                    $restantes = max(0, (int) $pacote->qtd - $vendidos);

                                    $permiteCupom = (int) ($pacote->permitir_cupom ?? 1) === 1;
                                    $temCupomEvento = $cupomSessao && isset($cupomSessao['evento_id']) && (int) $cupomSessao['evento_id'] === (int) $evento->id;
                                    $temCupomValido = $temCupomEvento && $permiteCupom;

                                    $precoOriginal = (int) $pacote->preco; // centavos
                                    $precoComDesc = $precoOriginal;
                                    $taxa = 0;
                                    $precoFinal = $precoOriginal;

                                    if ($precoOriginal > 0) {
                                        if ($temCupomValido) {
                                            $desconto = (int) round((($cupomSessao['desconto'] ?? 0) / 100) * $precoOriginal);
                                            $precoComDesc = max(0, $precoOriginal - $desconto);
                                            $taxa = (int) round((($evento->taxa_servico ?? 0) / 100) * $precoComDesc);
                                            $precoFinal = $precoComDesc + $taxa;
                                        } else {
                                            $taxa = (int) round((($evento->taxa_servico ?? 0) / 100) * $precoOriginal);
                                            $precoFinal = $precoOriginal + $taxa;
                                        }
                                    }

                                    $tipo = (string) ($pacote->tipo ?? '');
                                    $mostrarPacote = ($tipo === 'Gratuito' && $precoOriginal === 0) || ($tipo === 'Público' && $precoOriginal > 0);
                                @endphp

                                @if ($mostrarPacote && $hoje->between($dataInicio, $dataFim))
                                    <div class="py-2 bg-[#e9e9e9] lg:bg-primary-white block border-b">
                                        <div class="py-2 flex flex-col lg:flex-row justify-between lg:items-center">

                                            {{-- Nome e Preço --}}
                                            <div class="px-4">
                                                <div class="flex items-center gap-2">
                                                    <i class="fas fa-ticket-alt text-[#2c2c2c]"></i>
                                                    <p class="font-bold text-base text-[#2c2c2c]">{{ $pacote->nome }}</p>
                                                </div>

                                                <div class="mt-2 text-[#444]">
                                                    @if ($tipo === 'Gratuito')
                                                        <span class="text-green-600 font-bold">Ingresso gratuito</span>
                                                    @else
                                                        @if ($temCupomValido)
                                                            <span style="text-decoration:line-through;color:lightgray;">R$ {{ number_format($precoOriginal / 100, 2, ',', '.') }}</span>
                                                            &nbsp;<span class="font-bold text-black">R$ {{ number_format($precoComDesc / 100, 2, ',', '.') }}</span>
                                                        @else
                                                            R$ {{ number_format($precoOriginal / 100, 2, ',', '.') }}
                                                        @endif
                                                        @if (($evento->taxa_servico ?? 0) > 0 && $taxa > 0)
                                                            (+ R$ {{ number_format($taxa / 100, 2, ',', '.') }} taxa)
                                                        @endif
                                                    @endif
                                                    @php
                                                        $percentualVendido = $pacote->qtd > 0 ? round(($vendidos / $pacote->qtd) * 100, 1) : 0;

                                                        if ($percentualVendido >= 80) {
                                                            $corBarra = 'linear-gradient(90deg, #dc2626, #ef4444)'; // Verde
                                                        } elseif ($percentualVendido >= 50) {
                                                            $corBarra = 'linear-gradient(90deg, #dc2626, #ef4444)'; // Amarelo
                                                        } elseif ($percentualVendido >= 30) {
                                                            $corBarra = 'linear-gradient(90deg, #f97316, #fb923c)'; // Laranja
                                                        } else {
                                                            $corBarra = 'linear-gradient(90deg, #dc2626, #ef4444)'; // Vermelho
                                                        }
                                                    @endphp
                                                    @if ($percentualVendido >= 50 && $percentualVendido < 100)
                                                        <div class="progress-container mt-2 mb-2">
                                                            <div class="progress soldticket-bar pull-left">
                                                                <div role="progressbar" aria-valuenow="{{ $vendidos }}" aria-valuemin="0" aria-valuemax="{{ $pacote->qtd }}" class="progress-bar"
                                                                    style="width: {{ $percentualVendido }}%; background: {{ $corBarra }};">
                                                                    <span class="progress-text">
                                                                        {{ (int) $percentualVendido }}% vendido
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="mt-1 text-sm text-gray-600">
                                                    @php
                                                        $diffSegundos = now()->diffInSeconds($dataFim, false);
                                                    @endphp

                                                    @if ($restantes > 0 && $diffSegundos > 0 && $diffSegundos < 43200)
                                                        <div class="contador-virada" data-end="{{ $dataFim->toIso8601String() }}" style="color:#d60404; font-weight:bold;">
                                                            ⏰ Virada de lote em {{ floor($diffSegundos / 3600) }}h {{ floor(($diffSegundos % 3600) / 60) }}min
                                                        </div>
                                                    @endif

                                                    @if ($restantes <= 10)
                                                        @if ($restantes > 0)
                                                            <span class="text-red-600 font-bold">🚨 Restam apenas {{ $restantes }} ingressos</span>
                                                        @endif
                                                    @else
                                                        Vendas até {{ $dataFim->format('d/m/Y') }} às {{ $dataFim->format('H:i') }}
                                                    @endif
                                                </div>
                                            </div>

                                            {{-- Controles e input real do form --}}
                                            <div class="flex flex-row items-center gap-x-3 px-4 mt-2">
                                                @if ($restantes <= 0)
                                                    <span class="text-red-600 font-bold">❌ Esgotado</span>
                                                @else
                                                    <button type="button" class="bg-green-button hover:bg-green-hover rounded-full p-1 md:p-1" onclick="minus('qty_label-id_form-{{ $pacote->id }}-qtd','input_pacote_{{ $pacote->id }}')"
                                                        data-preco="{{ $precoFinal }}">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#023324" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                            class="lucide lucide-minus">
                                                            <path d="M5 12h14"></path>
                                                        </svg>
                                                    </button>
                                                    <p id="qty_label-id_form-{{ $pacote->id }}-qtd" class="qtd-item" data-pacote-id="{{ $pacote->id }}" data-preco="{{ $precoFinal }}">0</p>
                                                    <button type="button" class="bg-primary-green hover:bg-primary-green/90 rounded-full p-1 md:p-1" onclick="plus('qty_label-id_form-{{ $pacote->id }}-qtd','input_pacote_{{ $pacote->id }}')"
                                                        data-preco="{{ $precoFinal }}">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#E9F2F0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                            class="lucide lucide-plus">
                                                            <path d="M5 12h14"></path>
                                                            <path d="M12 5v14"></path>
                                                        </svg>
                                                    </button>
                                                    {{-- input que vai no POST: pacotes[ID] = qtd --}}
                                                    <input type="hidden" id="input_pacote_{{ $pacote->id }}" name="pacotes[{{ $pacote->id }}]" value="0">
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <div class="mt-2 lg:mt-4 mb-6 lg:mb-0 hidden lg:block">
                            <h4 class="text-base font-bold text-[#2c2c2c]">
                                Total: <span id="cart_total_bottom" class="font-bold text-primary-green text-base lg:text-lg">R$ 0,00</span>
                            </h4>
                            @if (!empty($restantes))
                                @if ($restantes > 0)
                                    <button type="{{ Auth::check() ? 'submit' : 'button' }}" id="buyTicketDesktop" class="{{ Auth::check() ? '' : 'btnConta' }} mt-2 bg-primary-green w-full flex justify-center px-4 py-2 rounded-full">
                                        <span class="text-secondary-white">Solicitar</span>
                                    </button>
                                @else
                                    <button class="mt-2 bg-red-500 w-full flex justify-center px-4 py-2 rounded-full">
                                        <span class="text-secondary-white">Vendas Encerradas</span>
                                    </button>
                                @endif
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>

        {{-- Barra Mobile fixa (envia o MESMO form via atributo form) --}}
        <div id="cart_mobile" class="lg:hidden fixed bottom-0 bg-white w-full z-[9999] hidden">
            <div class="flex flex-col items-center justify-between px-4 py-4">
                <div class="flex items-center gap-4 mb-4">
                    <div class="flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="#444" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-ticket">
                            <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                            <path d="M13 5v2"></path>
                            <path d="M13 17v2"></path>
                            <path d="M13 11v2"></path>
                        </svg>
                        <h5 id="cart_mobile_qty" class="text-gray-dark text-base">0 carteira(s)</h5>
                    </div>
                    <div class="flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="#444" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-credit-card">
                            <rect width="20" height="14" x="2" y="5" rx="2"></rect>
                            <line x1="2" x2="22" y1="10" y2="10"></line>
                        </svg>
                        <h5 id="cart_mobile_total" class="text-gray-dark text-base">R$ 0,00</h5>
                    </div>
                </div>
                <div class="w-full">
                    <button style="justify-content: center" type="{{ Auth::check() ? 'submit' : 'button' }}" form="form_ing" id="buyTicketMobile"
                        class="{{ Auth::check() ? '' : 'btnConta' }} bg-primary-green w-full flex hover:bg-green-hover rounded-full px-4 py-[0.6rem]">
                        <span class="text-center text-secondary-white" style="text-align: center">Continuar</span>
                    </button>
                </div>
            </div>
        </div>

        {{-- Área para retorno/partials, se necessário --}}
        <div id="result_ingressos" class="hidden"></div>
        @include('site.footer')
    </main>
@endsection

@section('js')
    <script>
        (function() {
            'use strict';

            const $id = (s) => document.getElementById(s);
            const $all = (s) => Array.prototype.slice.call(document.querySelectorAll(s) || []);
            const toInt = (v, d = 0) => {
                const n = parseInt(String(v ?? '').replace(/[^\d-]/g, ''), 10);
                return Number.isFinite(n) ? n : d;
            };
            const fmtBRL = (num) => {
                try {
                    return new Intl.NumberFormat('pt-BR', {
                        style: 'currency',
                        currency: 'BRL'
                    }).format(Number(num) || 0);
                } catch {
                    const n = (Number(num) || 0).toFixed(2).replace('.', ',');
                    return 'R$ ' + n.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                }
            };

            // Scroll até a área de ingressos
            (function bindScrollComprar() {
                const btn = $id('btn-comprar');
                const tgt = $id('rolar_pagina');
                if (!btn || !tgt || typeof tgt.scrollIntoView !== 'function') return;
                btn.addEventListener('click', (e) => {
                    e.preventDefault();
                    try {
                        tgt.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    } catch {}
                });
            })();

            // Modal (termos/privacidade)
            (function bindModal() {
                const modal = $id('customModal');
                const closeModal = $id('closeModal');
                const modalTitle = $id('modalTitle');
                const modalContent = $id('modalContent');
                if (!modal || !closeModal || !modalTitle || !modalContent) return;

                const textos = {
                    termos: {
                        titulo: "Termos de Uso",
                        conteudo: `
          <p>Esses termos regulam o uso da plataforma {{ env('EMPRESA') }}.</p>
          <p>- A plataforma é apenas intermediadora da venda de ingressos, não sendo produtora dos eventos.</p>
          <p>- Alterações de data, local ou horário são de responsabilidade do organizador.</p>
          <p>- É indispensável a apresentação do ingresso digital com documento oficial com foto.</p>
          <p>- Reembolsos devem obedecer prazos e regras descritas.</p>
        `
                    },
                    privacidade: {
                        titulo: "Política de Privacidade",
                        conteudo: `
          <p>A {{ env('EMPRESA') }} respeita sua privacidade e protege seus dados pessoais.</p>
          <p>- Dados usados apenas para efetivar a compra e comunicação.</p>
          <p>- Não compartilhamos informações sem autorização.</p>
          <p>- Dados armazenados com medidas de segurança adequadas.</p>
        `
                    }
                };

                document.addEventListener('click', (e) => {
                    const el = e.target.closest('.open-modal');
                    if (!el) return;
                    const type = el.dataset.type;
                    if (!type || !textos[type]) return;

                    modalTitle.textContent = textos[type].titulo || '';
                    modalContent.innerHTML = textos[type].conteudo || '';
                    modal.classList.remove('hidden');
                    modal.classList.add('flex');
                });

                closeModal.addEventListener('click', () => {
                    modal.classList.add('hidden');
                    modal.classList.remove('flex');
                });

                modal.addEventListener('click', (e) => {
                    if (e.target === modal) {
                        modal.classList.add('hidden');
                        modal.classList.remove('flex');
                    }
                });
            })();

            // Atualização de totais
            function atualizarTotal() {
                let totalCentavos = 0,
                    totalQtd = 0;

                $all('.qtd-item').forEach(el => {
                    const qtd = toInt(el.textContent, 0);
                    const preco = toInt(el.dataset?.preco, 0);
                    if (qtd > 0 && preco >= 0) {
                        totalQtd += qtd;
                        totalCentavos += qtd * preco;
                    }
                });

                const total = totalCentavos / 100;
                const top = $id('cart_total');
                if (top) top.textContent = fmtBRL(total);
                const bot = $id('cart_total_bottom');
                if (bot) bot.textContent = fmtBRL(total);

                const mobBar = $id('cart_mobile');
                const mobQty = $id('cart_mobile_qty');
                const mobTot = $id('cart_mobile_total');
                if (mobBar) {
                    if (totalQtd > 0) {
                        mobBar.classList.remove('hidden');
                        if (mobQty) mobQty.textContent = totalQtd + ' carteira(s)';
                        if (mobTot) mobTot.textContent = fmtBRL(total);
                    } else {
                        mobBar.classList.add('hidden');
                    }
                }
            }

            // Expostos globalmente (usados nos botões inline)
            window.plus = function(labelId, inputId) {
                const label = $id(labelId),
                    input = $id(inputId);
                if (!label || !input) return;
                const qtd = toInt(label.textContent, 0) + 1;
                label.textContent = qtd;
                input.value = qtd;
                atualizarTotal();
            };

            window.minus = function(labelId, inputId) {
                const label = $id(labelId),
                    input = $id(inputId);
                if (!label || !input) return;
                const atual = toInt(label.textContent, 0);
                const qtd = Math.max(0, atual - 1);
                label.textContent = qtd;
                input.value = qtd;
                atualizarTotal();
            };

            // Validação mínima do form
            window.validFormCompraMin = function(form) {
                try {
                    const inputs = Array.prototype.slice.call(form.querySelectorAll('input[name^="pacotes["]') || []);
                    const tem = inputs.some(i => toInt(i.value, 0) > 0);
                    if (!tem) {
                        alert('Selecione ao menos 1 ingresso.');
                        return false;
                    }
                    return true;
                } catch {
                    return true;
                }
            };

            document.addEventListener('DOMContentLoaded', atualizarTotal);
        })();
    </script>
@endsection
