@extends('site.base')
@section('titulo', $evento->titulo)
@section('url', route('site.evento', [$evento->url, $evento->id]))
@section('description', lmword($evento->descricao, 180))
@section('image', $evento->banner)
@section('analytics', $evento->analytics)
@section('ads', $evento->ads)
@section('pixel', $evento->pixel ?? env('PIXEL'))
@section('pixel_track', 'AddToCart')
@section('content')
    <div class="relative w-full false">
        {{-- HEADER --}}
        <div class="fixed top-0 left-0 right-0 z-30">
            <div class="w-full 4xl:mx-auto">
                <header class="h-[72px] bg-primary-green flex justify-between items-center px-4 md:px-8 z-[9999]">
                    <div class="h-[72px] 4xl:px-12 w-full 4xl:w-[70%] 4xl:mx-auto flex justify-between items-center">
                        <a href="{{ route('site.home') }}">
                            <img alt="Logo" loading="lazy" width="150" decoding="async" src="{{ url('site') }}/images/logo-branca.png" />
                        </a>
                        <div class="flex justify-end font-bold text-white" title="Tempo restante para encerrar o carrinho!">
                            <div class="border-2 border-white rounded-full flex p-2 gap-1 align-middle min-w-[94px]">
                                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 1024 1024">
                                    <path
                                        d="M945 412H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h256c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM811 548H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h122c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM477.3 322.5H434c-6.2 0-11.2 5-11.2 11.2v248c0 3.6 1.7 6.9 4.6 9l148.9 108.6c5 3.6 12 2.6 15.6-2.4l25.7-35.1v-0.1c3.6-5 2.5-12-2.5-15.6l-126.7-91.6V333.7c0.1-6.2-5-11.2-11.1-11.2z">
                                    </path>
                                    <path
                                        d="M804.8 673.9H747c-5.6 0-10.9 2.9-13.9 7.7-12.7 20.1-27.5 38.7-44.5 55.7-29.3 29.3-63.4 52.3-101.3 68.3-39.3 16.6-81 25-124 25-43.1 0-84.8-8.4-124-25-37.9-16-72-39-101.3-68.3s-52.3-63.4-68.3-101.3c-16.6-39.2-25-80.9-25-124 0-43.1 8.4-84.7 25-124 16-37.9 39-72 68.3-101.3 29.3-29.3 63.4-52.3 101.3-68.3 39.2-16.6 81-25 124-25 43.1 0 84.8 8.4 124 25 37.9 16 72 39 101.3 68.3 17 17 31.8 35.6 44.5 55.7 3 4.8 8.3 7.7 13.9 7.7h57.8c6.9 0 11.3-7.2 8.2-13.3-65.2-129.7-197.4-214-345-215.7-216.1-2.7-395.6 174.2-396 390.1C71.6 727.5 246.9 903 463.2 903c149.5 0 283.9-84.6 349.8-215.8 3.1-6.1-1.4-13.3-8.2-13.3z">
                                    </path>
                                </svg>
                                <span id="tempoCarLabel" class="text-left">15:00</span>
                            </div>
                        </div>
                    </div>
                </header>
            </div>
        </div>

        {{-- FORM PARTICIPANTES --}}
        <div class="pt-[64px]">
            <div class="bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
                <section class="py-8">
                    <h2 class="font-bold text-2xl lg:text-3xl text-primary-green mb-2">Estudante</h2>
                    <p class="text-gray-dark mb-6">Preencha seus dados pessoais e dados acadêmicos</p>

                    {{-- FORM que envia via POST --}}
                    <form method="POST" action="{{ route('ingressos.cart.update') }}" enctype="multipart/form-data">
                        @csrf

                        {{-- Loop nos ingressos --}}
                        @foreach ($carrinho['dados_ingressos'] as $index => $ingresso)
                            <div class="bg-white rounded-2xl px-4 py-6 mb-6">
                                <div class="flex flex-col lg:flex-row items-center justify-between mb-4">
                                    <h3 class="text-lg font-bold text-[#2c2c2c]">
                                        Carteira {{ $ingresso['pacote_nome'] }}
                                    </h3>
                                    <button type="button" class="btn-preencher bg-primary-green flex hover:bg-green-hover rounded-full px-4 py-[0.6rem]" data-index="{{ $index }}">
                                        <span class="text-center text-white">Preencher com dados da conta</span>
                                    </button>
                                </div>
                                <div class="space-y-4">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="avatar avatar--xl">
                                            <div class="avatar__image">
                                                <label for="imageInput-{{ $index }}" style="cursor:pointer">
                                                    <img id="selectedImage-{{ $index }}" class="img-fluid rounded-full object-cover" width="128" height="128" src="{{ url('site/images/users/thumb.jpg') }}">
                                                </label>

                                                <input name="participantes[{{ $index }}][foto]" type="file" class="form-control" style="display: none" id="imageInput-{{ $index }}" accept="image/*"
                                                    onchange="previewImage(event, {{ $index }})" required>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Campos fixos --}}
                                    <input name="participantes[{{ $index }}][nome]" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green"
                                        value="{{ Auth::user()->name }} {{ Auth::user()->sobrenome }}">
                                    <input name="participantes[{{ $index }}][email]" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green" value="{{ Auth::user()->email }}" placeholder="E-mail">
                                    <input name="participantes[{{ $index }}][cpf]" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green" value="{{ Auth::user()->cpf }}" placeholder="CPF">
                                    <input name="participantes[{{ $index }}][celular]" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green" value="{{ Auth::user()->celular }}" placeholder="Celular">

                                    {{-- Campos personalizados --}}
                                    @foreach ($evento->CamposPersonalizados as $campo)
                                        @php
                                            $inputName = "participantes[{$index}][{$campo->campo}]";
                                            $isRequired = $campo->obrigatorio ? 'required' : '';
                                        @endphp

                                        @if ($campo->tipo_input === 'text')
                                            <input name="{{ $inputName }}" type="text" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green" placeholder="{{ $campo->label }}" {{ $isRequired }}>
                                        @elseif ($campo->tipo_input === 'select')
                                            @php
                                                $opcoes = json_decode($campo->opcoes, true) ?? [];
                                            @endphp
                                            <select name="{{ $inputName }}" class="campo-{{ $index }} bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green" {{ $isRequired }}>
                                                <option value="">Selecione {{ strtolower($campo->label) }}</option>
                                                @foreach ($opcoes as $opcao)
                                                    <option value="{{ $opcao }}">{{ $opcao }}</option>
                                                @endforeach
                                            </select>
                                        @elseif ($campo->tipo_input === 'textarea')
                                            <textarea name="{{ $inputName }}" rows="3" class="campo-{{ $index }} bg-green-light w-full px-4 py-2 rounded-2xl text-tertiary-green" placeholder="{{ $campo->label }}" {{ $isRequired }}></textarea>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @endforeach

                        {{-- Botões --}}
                        <div class="flex flex-col lg:flex-row items-center gap-4 mt-6">
                            <a href="{{ route('site.evento', [$evento->url, $evento->id]) }}" class="bg-green-button w-full lg:w-1/2 py-3 rounded-full text-primary-green hover:bg-green-hover text-center">
                                Voltar
                            </a>
                            <button type="submit" class="bg-primary-green w-full lg:w-1/2 py-3 rounded-full text-white hover:bg-primary-green/90">
                                Ir para o pagamento
                            </button>
                        </div>
                    </form>
                </section>
            </div>
        </div>

    </div>
@endsection
@section('css')
    <style>
        .sempreDireita {
            display: none;
        }
    </style>
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        @if (empty(Auth::user()->cpf))
            Swal.fire({
                title: 'Erro!',
                html: 'Seu CPF é inválido.<br>Deseja atualizar seu cadastro agora?',
                icon: 'error',
                showCancelButton: true,
                confirmButtonText: 'Atualizar Cadastro',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Redireciona para o link de atualização do cadastro
                    window.location.href = '{{ route('minha.conta') }}';
                }
            });
        @endif

        // Dados do usuário logado vindos do backend
        const userData = {
            nome: "{{ Auth::user()->name ?? '' }} {{ Auth::user()->sobrenome ?? '' }}",
            email: "{{ Auth::user()->email ?? '' }}",
            cpf: "{{ Auth::user()->cpf ?? '' }}",
            celular: "{{ Auth::user()->celular ?? '' }}",
        };

        // Se os dados estiverem vazios, não faz nada
        if (userData.nome || userData.email) {
            document.querySelectorAll('.btn-preencher').forEach(btn => {
                btn.addEventListener('click', function() {
                    let idx = this.dataset.index;
                    document.querySelector(`[name="participantes[${idx}][nome]"]`).value = userData.nome;
                    document.querySelector(`[name="participantes[${idx}][email]"]`).value = userData.email;
                    document.querySelector(`[name="participantes[${idx}][cpf]"]`).value = userData.cpf;
                    document.querySelector(`[name="participantes[${idx}][celular]"]`).value = userData.celular;
                });
            });
        }

        function previewImage(event, index) {
            const input = event.target;
            if (!input.files || !input.files[0]) return;

            const reader = new FileReader();

            reader.onload = function(e) {
                const img = document.getElementById('selectedImage-' + index);
                if (img) {
                    img.src = e.target.result;
                }
            };

            reader.readAsDataURL(input.files[0]);
        }
    </script>
@endsection
