<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="{{ url('site') }}/images/favicon.ico" type="image/x-icon" sizes="256x256" />
    <meta name="next-size-adjust" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <title>@yield('titulo')</title>

    <!-- CSS (corrigido link duplicado) -->
    <link rel="stylesheet" href="{{ url('site') }}/css/style.css?v={{ rand() }}" />
    <link rel="stylesheet" href="{{ url('site') }}/css/style_2.css?v={{ rand() }}" />
    <link rel="stylesheet" href="{{ url('site') }}/css/style_3.css?v={{ rand() }}" />
    <link rel="stylesheet" href="{{ url('site') }}/css/style_4.css?v={{ rand() }}" />
    <link rel="stylesheet" href="{{ url('site') }}/css/style_5.css?v={{ rand() }}" />

    <!-- JS (coloquei defer para não bloquear renderização) -->
    <script src="{{ url('site') }}/js/scritp.js" defer></script>
    <script src="{{ url('site') }}/js/script_2.js" defer></script>
    <script src="{{ url('site') }}/js/script_3.js" defer></script>
    <script src="{{ url('site') }}/js/carousel.js" defer></script>

    <meta property="og:title" content="@yield('titulo')" />
    <meta property="og:url" content="@yield('url')" />
    <meta property="og:description" content="@yield('description')" />
    @yield('application_ld_json')
    <meta property="og:image" content="@yield('image')" />
    <meta property="og:image:width" content="954" />
    <meta property="og:image:height" content="500" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="{{ url('vendas') }}/static/strap34/assets/js/jquery-3.3.1.min.js"></script>
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script', 'https://connect.facebook.net/en_US/fbevents.js');

        fbq('init', '@yield('pixel'))'; fbq('track', '@yield('pixel_track')');
    </script>
    <noscript>
        <img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=@yield('pixel')&ev=@yield('pixel_track')&noscript=1" />
    </noscript>

    <script src="https://sdk.mercadopago.com/js/v2"></script>
    @yield('css')

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-RSKJE20DT1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-RSKJE20DT1');
    </script>

</head>

<body class="scrollbar scrollbar-none relative bg-primary-white" data-auth="{{ Auth::check() ? '1' : '0' }}">
    @if (Auth::check())
        <div class="sempreDireita">
            <a href="https://api.whatsapp.com/send?phone=55{{ tiraMoeda(env('WHATSAPP_SUPORTE')) }}&text=Olá, eu me chamo {{ Auth::user()->name }}, estou no Site da UCESUB e preciso de ajuda para minha conta. Meu código do cliente UCESUB é {{ Auth::user()->id }}."
                target="_blank">
                <img src="{{ url('site/images/whatsapp.png') }}" width="20" style="margin-right: 5px">
                Atendimento ao Cliente
            </a>
        </div>
        {{-- @else --}}
        {{-- <a href="https://api.whatsapp.com/send?phone=55{{ tiraMoeda(env('WHATSAPP_SUPORTE')) }}&text=Olá eu estou no Site da UCESUB e preciso de ajuda." target="_blank">
                <img src="{{ url('site/images/whatsapp.png') }}" width="20" style="margin-right: 5px">
                Atendimento ao Cliente
            </a> --}}
    @endif

    <div id="_rht_toaster" style="position: fixed; z-index: 9999; inset: 16px; pointer-events: none"></div>

    <div class="relative w-full">
        <div class="fixed top-0 left-0 right-0 z-30">
            <div class="w-full 4xl:mx-auto">
                <!-- ====== HEADER ====== -->
                <header class="h-[72px] bg-primary-green flex justify-between items-center px-4 md:px-8 z-[9999]">
                    <div class="h-[72px] 4xl:px-12 w-full 4xl:w-[70%] 4xl:mx-auto flex justify-between items-center">

                        <!-- Logo -->
                        <div>
                            <a href="{{ route('site.home') }}" class="cursor-pointer block">
                                <img alt="Logo" loading="lazy" width="70" decoding="async" src="{{ url('site') }}/images/logo-branca.png" />
                            </a>
                        </div>

                        <!-- Menu desktop -->
                        <ul class="grow shrink basis-0 self-stretch justify-start items-center hidden lg:flex w-full ml-12">
                            {{-- Início --}}
                            <a class="h-full" href="{{ route('site.home') }}">
                                <li
                                    class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
                                    {{ request()->routeIs('site.home') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white' }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="{{ request()->routeIs('site.home') ? '#023324' : '#F1F7FF' }}" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-house">
                                        <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8"></path>
                                        <path d="M3 10a2 2 0 0 1 .709-1.528l7-5.999a2 2 0 0 1 2.582 0l7 5.999A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Início</span>
                                    </div>
                                </li>
                            </a>
                            <a class="h-full" href="{{ route('site.eventos') }}">
                                <li
                                    class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
                                    {{ request()->routeIs('site.eventos') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white' }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="{{ request()->routeIs('site.eventos') ? '#023324' : '#F1F7FF' }}" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-house">
                                        <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8"></path>
                                        <path d="M3 10a2 2 0 0 1 .709-1.528l7-5.999a2 2 0 0 1 2.582 0l7 5.999A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Solicitar Carteira</span>
                                    </div>
                                </li>
                            </a>
                        </ul>


                        <!-- Botão hambúrguer (VISÍVEL NO MOBILE) -->
                        <button id="menuButton" type="button" aria-label="Abrir menu" aria-controls="mobileMenu" aria-expanded="false" class="xl:hidden block p-2 ml-3 text-white cursor-pointer relative z-[10000]">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <line x1="3" y1="12" x2="21" y2="12" />
                                <line x1="3" y1="6" x2="21" y2="6" />
                                <line x1="3" y1="18" x2="21" y2="18" />
                            </svg>
                        </button>
                        <!-- Ações (desktop) -->
                        <div class="flex-row items-center hidden lg:flex">
                            <div class="ml-4">
                                <button type="button" class="btnConta bg-green-button w-full flex hover:bg-green-hover rounded-full px-4 py-[0.6rem] relative">
                                    <div class="flex items-center w-full gap-x-3 pr-6 justify-between">
                                        <div><span class="text-center text-primary-musa">Conta</span></div>
                                        <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="lucide lucide-chevron-down">
                                                <path d="m6 9 6 6 6-6"></path>
                                            </svg>
                                        </div>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </header>
                <!-- Dropdown Conta -->
                <div id="menuConta" class="hidden absolute right-0 top-[72px] w-[250px] bg-green-light px-3 py-3 rounded-b-2xl shadow-lg z-[99999]">
                    <h1 class="text-base">Bem vindo,</h1>
                    <h1 class="font-bold text-primary-musa">{{ Auth::check() ? Auth::user()->name : 'Visitante' }}</h1>
                    <hr class="my-2 bg-primary-green border-primary-green">
                    <ul>
                        <a href="{{ route('site.eventos') }}">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-ticket text-primary-musa">
                                    <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                                    <path d="M13 5v2"></path>
                                    <path d="M13 17v2"></path>
                                    <path d="M13 11v2"></path>
                                </svg>
                                <p class="ml-2">Solicitar Carteira</p>
                            </li>
                        </a>
                        <a href="{{ route('cliente.ingressos') }}">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-ticket text-primary-musa">
                                    <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                                    <path d="M13 5v2"></path>
                                    <path d="M13 17v2"></path>
                                    <path d="M13 11v2"></path>
                                </svg>
                                <p class="ml-2">Minhas Compras</p>
                            </li>
                        </a>
                        <a href="{{ route('minhas.indicacoes') }}">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-user text-primary-musa">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p class="ml-2">Minhas Indicações</p>
                            </li>
                        </a>
                        <a href="{{ route('minha.conta') }}">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-user text-primary-musa">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p class="ml-2">Meus dados</p>
                            </li>
                        </a>
                        @if (Auth::check() && Auth::user()->nivel < 3)
                            <a href="{{ route('dashboard') }}">
                                <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-user text-primary-musa">
                                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    <p class="ml-2">Área Restrita</p>
                                </li>
                            </a>
                        @endif
                        @if (Auth::check())
                            <a href="javascript:void(0)" onclick="javascript:Sair();">
                                <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-log-out text-primary-musa">
                                        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                        <polyline points="16 17 21 12 16 7"></polyline>
                                        <line x1="21" x2="9" y1="12" y2="12"></line>
                                    </svg>
                                    <p class="ml-2">Sair</p>
                                </li>
                            </a>
                        @endif

                    </ul>
                </div>
            </div>
        </div>

        <!-- CONTEÚDO -->
        <div class="pt-0">
            @yield('content')
        </div>
    </div>

    <!-- Backdrop + Menu Mobile (fora do header para cobrir a tela toda) -->
    <div id="backdrop" class="fixed inset-0 bg-black/40 opacity-0 pointer-events-none transition-opacity duration-300 z-[9998]"></div>

    <nav id="mobileMenu" class="fixed right-0 top-0 w-[100%] max-w-[420px] min-h-screen bg-white z-[9999] transform translate-x-full transition-transform duration-300 ease-in-out p-4 shadow-xl" role="dialog" aria-modal="true"
        aria-labelledby="mobileMenuTitle" tabindex="-1">
        <button class="w-fit ml-auto p-2" id="closeMenu" aria-label="Fechar menu">
            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
        </button>
        <div>
            <h1 class="text-sm">Bem vindo,</h1>
            <h1 id="mobileMenuTitle" class="font-bold text-xl">{{ Auth::check() ? Auth::user()->name : 'Visitante' }}</h1>
        </div>
        <hr class="my-2 border-black">
        <ul class="my-6">
            <a href="{{ route('site.home') }}">
                <li class="flex items-center mb-6"><span class="mr-3">🏠</span><span class="text-lg">Início</span></li>
            </a>
            <a href="{{ route('cliente.ingressos') }}">
                <li class="flex items-center mb-6"><span class="mr-3">🎟️</span><span class="text-lg">Minhas Compras</span></li>
            </a>
            <!-- Também pode acionar o mesmo comportamento -->
            <li class="flex items-center mb-6">
                <a href="{{ route('minha.conta') }}" class="btnConta flex items-center"><span class="mr-3">👤</span><span class="text-lg">Conta</span></a>
            </li>
            @if (Auth::check())
                <hr class="mt-2 mb-4 border border-gray-300">
                <a href="javascript:void(0)" onclick="javascript:Sair();">
                    <li class="flex items-center mb-6"><span class="mr-3">🚪</span><span class="text-lg">Sair</span></li>
                </a>
            @endif

        </ul>
    </nav>

    <!-- ===== Modal de Login ===== -->
    <div id="modalLogin" class="hidden fixed inset-0 flex items-center justify-center z-[99999] bg-black/50">
        <div class="relative
                  w-[95%] max-h-[100%]
                  md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%]
                  my-6 mx-auto bg-white rounded-2xl shadow-lg">
            <button id="closeModalLogin" class="absolute top-2 right-6 cursor-pointer" aria-label="Fechar modal">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="28" width="28" xmlns="http://www.w3.org/2000/svg">
                    <path d="M405 136.798L375.202 107 256 226.202 136.798 107 107 136.798 226.202 256 107 375.202 136.798 405 256 285.798 375.202 405 405 375.202 285.798 256z"></path>
                </svg>
            </button>

            <div class="p-6">
                <h1 class="text-primary-green font-bold text-2xl mb-3 mt-6">Entrar na minha conta</h1>
                {{-- Mostra erros de login --}}
                @if ($errors->any())
                    <div class="mb-4">
                        <ul class="text-red-600 text-sm">
                            @foreach ($errors->all() as $error)
                                <li style="font-weight: bold; background: #FFBFBF; padding: 10px; border-radius: 20px; padding-left: 20px;">{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Dentro do Modal de Login -->
                <form class="w-full" action="{{ route('login') }}" method="POST">
                    @csrf
                    <div class="flex flex-col gap-y-3">
                        <div class="relative">
                            <label class="mb-1 text-primary-green">E-mail</label>
                            <input id="email" name="email" type="text" value="{{ old('email') }}"
                                class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green
                   text-base leading-none focus:outline-none
                   placeholder:text-tertiary-green focus:bg-green-light/60"
                                placeholder="nome@email.com">
                        </div>
                        <div class="relative">
                            <label class="mb-1 text-primary-green">Senha</label>
                            <input id="password" name="password" type="password"
                                class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green
                   text-base leading-none focus:outline-none
                   placeholder:text-tertiary-green focus:bg-green-light/60"
                                placeholder="Insira sua senha">
                        </div>
                    </div>

                    <!-- Link Esqueceu a Senha -->
                    <button id="forgotPasswordLink" type="button" class="my-3">
                        <span class="hover:text-primary-green transition">Esqueceu a senha?</span>
                    </button>

                    <div class="px-6">
                        <div class="flex items-center justify-center flex-col gap-2 pb-10 w-full">
                            <div class="w-full md:w-[90%]">
                                <button type="submit" id="btnLogin"
                                    class="bg-primary-green w-full flex hover:bg-primary-green/90
                                    rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed
                                    relative justify-center items-center">
                                    <!-- Texto -->
                                    <span id="btnLoginText" class="text-center text-white">Entrar</span>

                                    <!-- Loader 3 dots -->
                                    <span id="btnLoginLoader" class="hidden flex gap-3 items-center justify-center">
                                        <span class="dot"></span>
                                        <span class="dot delay-150"></span>
                                        <span class="dot delay-300"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>

                <div class="px-6">
                    <div class="flex items-center justify-center flex-col gap-2 pb-10 w-full">
                        <div class="mt-1 w-full flex justify-center">
                            <h2>Não possui uma conta?
                                <a href="{{ route('site.cadastro') }}" class="text-primary-green font-bold cursor-pointer text-center">
                                    Criar conta
                                </a>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modalForgotPassword" class="hidden fixed inset-0 flex items-center justify-center z-[99999] bg-black/50">
        <div class="relative w-[95%] max-h-[100%]
        md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%]
        my-6 mx-auto bg-white rounded-2xl shadow-lg">

            <!-- Botão fechar -->
            <div class="absolute top-2 right-6 cursor-pointer" id="closeForgotPassword">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="28" width="28">
                    <path d="M405 136.798L375.202 107 256 226.202 136.798 107
                         107 136.798 226.202 256 107 375.202
                         136.798 405 256 285.798 375.202 405
                         405 375.202 285.798 256z"></path>
                </svg>
            </div>

            <!-- Conteúdo -->
            <div class="h-full p-6 flex justify-start items-start overflow-auto">
                <div class="w-full md:w-[90%]">
                    <h1 class="text-primary-green font-bold text-2xl mb-1 mt-6">Esqueceu sua senha?</h1>
                    <h2 class="mb-6 text-gray-dark text-sm">
                        Digite seu e-mail para receber um link para redefinir sua senha.
                    </h2>
                    @if ($errors->any())
                        <div class="mb-4">
                            <ul class="text-red-600 text-sm">
                                @foreach ($errors->all() as $error)
                                    <li style="font-weight: bold; background: #FFBFBF; padding: 10px; border-radius: 20px; padding-left: 20px;">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf
                        <div class="relative h-full w-auto">
                            <label class="mb-1 text-primary-green">E-mail</label>
                            <input id="email_forgot" name="email" type="email"
                                class="bg-green-light w-full md:h-10 h-11 px-4 rounded-full
                                   text-tertiary-green text-base font-normal leading-none
                                   focus:outline-none placeholder:text-tertiary-green
                                   focus:bg-green-light/60"
                                placeholder="Insira seu e-mail">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                        </div>

                        <!-- Botão igual ao do login -->
                        <div class="px-6">
                            <div class="flex justify-center w-full mt-6">
                                <button type="submit" id="btnForgot"
                                    class="bg-primary-green w-full flex hover:bg-primary-green/90
                                        rounded-full px-4 py-[0.6rem] disabled:bg-disabled
                                        disabled:cursor-not-allowed relative justify-center items-center">

                                    <!-- Texto -->
                                    <span id="btnForgotText" class="text-center text-white">Enviar</span>

                                    <!-- Loader 3 dots -->
                                    <span id="btnForgotLoader" class="hidden flex gap-3 items-center justify-center">
                                        <span class="dot"></span>
                                        <span class="dot delay-150"></span>
                                        <span class="dot delay-300"></span>
                                    </span>
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>




    <form action="{{ route('logout') }}" method="post" id="sair">@csrf</form>
    <!-- Scripts da página -->
    <script>
        (function() {
            // Estado de login vindo do Blade
            const isLogged = document.body.getAttribute('data-auth') === '1';

            // Elementos
            const btnsConta = document.querySelectorAll('.btnConta'); // pode ter em vários lugares
            const menuConta = document.getElementById('menuConta');
            const modalLogin = document.getElementById('modalLogin');
            const closeModalLogin = document.getElementById('closeModalLogin');

            // Mobile menu
            const menuButton = document.getElementById('menuButton');
            const mobileMenu = document.getElementById('mobileMenu');
            const closeMenu = document.getElementById('closeMenu');
            const backdrop = document.getElementById('backdrop');
            let lastFocused = null;

            // Helpers visibilidade
            const show = el => el && el.classList.remove('hidden');
            const hide = el => el && el.classList.add('hidden');
            const toggle = el => el && el.classList.toggle('hidden');

            // Fecha tudo relacionado a conta
            function closeAccountUIs() {
                hide(menuConta);
                hide(modalLogin);
            }

            // Clique nos botões "Conta" (abre um ou outro)
            btnsConta.forEach(btn => {
                btn.addEventListener('click', (e) => {
                    e.stopPropagation();
                    // Garante que só um fica aberto
                    closeAccountUIs();
                    if (isLogged) {
                        // usuário logado → abre o menu
                        toggle(menuConta);
                    } else {
                        // não logado → abre o modal
                        show(modalLogin);
                        // 👇 FECHA o menu mobile se estiver aberto
                        closeMenuFn();
                    }
                });
            });


            // Fechar modal no X
            if (closeModalLogin) {
                closeModalLogin.addEventListener('click', () => hide(modalLogin));
            }

            // Fechar clicando fora (menu e modal)
            document.addEventListener('click', (e) => {
                const clickInsideMenu = menuConta && menuConta.contains(e.target);
                const clickInsideModal = modalLogin && modalLogin.contains(e.target);
                const clickOnAnyBtn = Array.from(btnsConta).some(btn => btn.contains(e.target));

                if (!clickOnAnyBtn && !clickInsideMenu && !clickInsideModal) {
                    closeAccountUIs();
                }

                // Caso clique no backdrop do modal (fora do conteúdo interno)
                if (modalLogin && !modalLogin.classList.contains('hidden')) {
                    // se específico no overlay (inset-0), fechar
                    if (e.target === modalLogin) hide(modalLogin);
                }
            });

            // ESC fecha tudo
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    closeAccountUIs();
                    closeMenuFn();
                }
            });

            // ===== Lógica do menu mobile =====
            function openMenu() {
                lastFocused = document.activeElement;
                document.body.style.overflow = 'hidden';
                mobileMenu.classList.remove('translate-x-full');
                mobileMenu.classList.add('translate-x-0');
                backdrop.classList.remove('pointer-events-none');
                requestAnimationFrame(() => {
                    backdrop.classList.add('opacity-100');
                    mobileMenu.focus();
                });
                if (menuButton) menuButton.setAttribute('aria-expanded', 'true');
            }

            function closeMenuFn() {
                document.body.style.overflow = '';
                if (mobileMenu) {
                    mobileMenu.classList.remove('translate-x-0');
                    mobileMenu.classList.add('translate-x-full');
                }
                if (backdrop) {
                    backdrop.classList.remove('opacity-100');
                    backdrop.classList.add('pointer-events-none');
                }
                if (menuButton) menuButton.setAttribute('aria-expanded', 'false');
                if (lastFocused) lastFocused.focus();
            }

            if (menuButton && mobileMenu && closeMenu && backdrop) {
                menuButton.addEventListener('click', openMenu);
                closeMenu.addEventListener('click', closeMenuFn);
                backdrop.addEventListener('click', closeMenuFn);
            }
        })();

        function Sair() {
            document.getElementById("sair").submit();
        }

        (function() {
            'use strict';
            const KEY = 'tempoCar';
            const MAX = 900; // 15 minutos em segundos
            const label = document.getElementById('tempoCarLabel');
            const pad2 = (n) => String(n).padStart(2, '0');
            const format = (s) => `${pad2(Math.floor(s/60))}:${pad2(s%60)}`;
            let rest = parseInt(sessionStorage.getItem(KEY), 10);
            // se não existe ou é inválido, reinicia
            if (!Number.isFinite(rest) || rest < 0 || rest > 86400) {
                rest = MAX;
                sessionStorage.setItem(KEY, String(rest));
            }

            function updateUI() {
                if (label) label.textContent = format(rest);
            }
            updateUI();

            setInterval(() => {
                rest = Math.max(0, rest - 1);
                sessionStorage.setItem(KEY, String(rest));
                updateUI();
                if (rest <= 0) {
                    // opcional: redirecionar ou avisar
                    // alert("Seu tempo de reserva expirou.");
                }
            }, 1000);

            // função global p/ resetar
            window.resetTempoCar = function(seconds = MAX) {
                rest = seconds;
                sessionStorage.setItem(KEY, String(rest));
                updateUI();
            };
        })();

        @if (empty(Auth::check()))
            document.addEventListener("DOMContentLoaded", function() {
                // === LOGIN ABERTURA AUTOMÁTICA SE ERRO ===
                @if ($errors->any())
                    const modalLogin = document.getElementById("modalLogin");
                    if (modalLogin) modalLogin.classList.remove("hidden");
                @endif

                // === BOTÃO LOGIN COM LOADER ===
                const form = document.querySelector("#modalLogin form");
                const btnLogin = document.getElementById("btnLogin");
                const btnText = document.getElementById("btnLoginText");
                const btnLoader = document.getElementById("btnLoginLoader");

                if (form) {
                    form.addEventListener("submit", function() {
                        btnLogin.disabled = true;
                        btnLogin.classList.remove("bg-primary-green", "hover:bg-primary-green/90");
                        btnLogin.style.background = "none";

                        btnText.classList.add("hidden");
                        btnLoader.classList.remove("hidden");
                    });
                }

                // === MODAL ESQUECEU A SENHA ===
                const modalForgot = document.getElementById("modalForgotPassword");
                const closeForgot = document.getElementById("closeForgotPassword");
                const forgotLink = document.getElementById("forgotPasswordLink");

                if (forgotLink) {
                    forgotLink.addEventListener("click", function(e) {
                        e.preventDefault();
                        modalForgot.classList.remove("hidden");
                        // Fecha login para não sobrepor
                        const modalLogin = document.getElementById("modalLogin");
                        if (modalLogin) modalLogin.classList.add("hidden");
                    });
                }

                if (closeForgot) {
                    closeForgot.addEventListener("click", function() {
                        modalForgot.classList.add("hidden");
                    });
                }

                // Fecha clicando fora
                if (modalForgot) {
                    modalForgot.addEventListener("click", function(e) {
                        if (e.target === modalForgot) {
                            modalForgot.classList.add("hidden");
                        }
                    });
                }
            });

            // === BOTÃO "ESQUECI A SENHA" COM LOADER ===
            const forgotForm = document.querySelector("#modalForgotPassword form");
            const btnForgot = document.getElementById("btnForgot");
            const btnForgotText = document.getElementById("btnForgotText");
            const btnForgotLoader = document.getElementById("btnForgotLoader");

            if (forgotForm && btnForgot) {
                forgotForm.addEventListener("submit", function() {
                    btnForgot.disabled = true;
                    // remove o fundo como no login
                    btnForgot.classList.remove("bg-primary-green", "hover:bg-primary-green/90");
                    btnForgot.style.background = "none";

                    btnForgotText.classList.add("hidden");
                    btnForgotLoader.classList.remove("hidden");
                });
            }


            document.addEventListener("DOMContentLoaded", function() {
                // ====== ERROS DE LOGIN ======
                @if ($errors->login->any())
                    const modalLogin = document.getElementById("modalLogin");
                    if (modalLogin) modalLogin.classList.remove("hidden");
                @endif

                // ====== ERROS DE ESQUECEU SENHA ======
                @if ($errors->forgot->any())
                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.remove("hidden");

                    Swal.fire({
                        icon: 'error',
                        title: 'Não foi possível enviar',
                        text: '{{ $errors->forgot->first('email') }}',
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });

                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.add("hidden");

                    Swal.fire({
                        icon: 'success',
                        title: 'Verifique seu e-mail',
                        html: ` ... `,
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });
                @endif

                // ====== SUCESSO NO ESQUECEU SENHA ======
                @if (session('status'))
                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.add("hidden");

                    Swal.fire({
                        icon: 'success',
                        title: 'Verifique seu e-mail',
                        html: `
                <div style="text-align:left">
                    <p>Enviamos um link para redefinir sua senha.</p>
                    <p>Confira sua <b>caixa de entrada</b> e também a pasta <b>Spam/Lixo Eletrônico</b>.</p>
                </div>
            `,
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });
                @endif
            });
        @endif
    </script>

    @yield('js')
</body>

</html>
