@extends('site.base')
@section('titulo', 'Central de Ajuda')
@section('content')
    <div class="pt-[64px]">
        <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
            <div class="min-h-screen pt-6 md:pt-10">
                <div class="my-4">
                    <h1 class="font-bold text-2xl md:text-3xl text-primary-green">Perguntas Frequentes</h1>
                </div>

                {{-- Transferir ingresso --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button" aria-expanded="false"
                        data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Como transferir um ingresso?</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>

                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>O comprador que receber o ingresso precisa ter uma conta na {{ env('EMPRESA') }}.<br>
                            1) No app, vá até "Meus Ingressos";<br>
                            2) Clique em "Transferir";<br>
                            3) Digite o e-mail do novo titular;<br>
                            4) Confirme a operação;<br>
                            5) O ingresso será enviado para a conta indicada.</p>
                    </div>
                </div>

                {{-- Cancelar ingresso --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button" aria-expanded="false"
                        data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Como cancelar um ingresso?</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>É possível solicitar reembolso em até 7 (sete) dias corridos após a compra, desde que feito
                            até 48 (quarenta e oito) horas antes do evento. O valor é devolvido com desconto da taxa de
                            serviço. Solicite pelo suporte da {{ env('EMPRESA') }} no WhatsApp.</p>
                    </div>
                </div>

                {{-- Acessar ingresso --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button" aria-expanded="false"
                        data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Como acessar o meu ingresso?</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>1) Baixe o app da {{ env('EMPRESA') }};<br>
                            2) Faça login com o e-mail usado na compra;<br>
                            3) Vá até "Meus Ingressos" e selecione o evento;<br>
                            4) Apresente o ingresso pelo celular ou impresso.</p>
                    </div>
                </div>

                {{-- Ingresso de outra pessoa --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button" aria-expanded="false"
                        data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Comprei um ingresso para mim e para outra pessoa, não estou encontrando o ingresso dela.</span><svg xmlns="http://www.w3.org/2000/svg"
                            width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Se no momento da compra foi informado o e-mail da outra pessoa, o ingresso estará na conta
                            da {{ env('EMPRESA') }} vinculada a esse e-mail.</p>
                    </div>
                </div>

                {{-- Cartão recusado --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button" aria-expanded="false"
                        data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Meu cartão foi recusado</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Os pagamentos são analisados pelo intermediador financeiro. Para evitar recusas:<br>
                            1) Use o nome do titular exatamente como no cartão;<br>
                            2) Informe CPF, e-mail e celular do dono do cartão;<br>
                            3) Evite preenchimento automático;<br>
                            4) Utilize cartão em nome do comprador.</p>
                    </div>
                </div>

                {{-- Compra aprovada no banco, mas recusada --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button"
                        aria-expanded="false" data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Minha compra foi aprovada no banco, mas recebi o e-mail de recusado.</span><svg xmlns="http://www.w3.org/2000/svg"
                            width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Nesse caso, o valor é estornado automaticamente para o banco emissor. O reembolso é integral
                            (ingresso + taxas) e aparecerá na fatura do cartão. Se persistir, contate a bandeira do
                            cartão.</p>
                    </div>
                </div>

                {{-- Status aguardando pagamento --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button"
                        aria-expanded="false" data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Status aguardando pagamento e não consigo realizar o pagamento.</span><svg xmlns="http://www.w3.org/2000/svg"
                            width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Quando o pagamento não é concluído, o ingresso fica como "aguardando pagamento". Nesse caso,
                            é necessário refazer a compra do zero.</p>
                    </div>
                </div>

                {{-- Compra em análise --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button"
                        aria-expanded="false" data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Compra em análise, o que é?</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                            viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Pagamentos podem levar até 6 horas para análise. O resultado será enviado por e-mail. Se for
                            recusado, basta tentar novamente com os dados corretos.</p>
                    </div>
                </div>

                {{-- Meia-entrada --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button"
                        aria-expanded="false" data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Ingresso:meia-entrada</span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                            viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Os benefícios de meia-entrada seguem a legislação e regras da produção. É necessário apresentar
                            documentação exigida no evento. A {{ env('EMPRESA') }} apenas intermedia a venda.</p>
                    </div>
                </div>

                {{-- Política de reembolso --}}
                <div class="rounded-2xl w-full mb-8 bg-[#e9e9e9]">
                    <button onclick="toggleFaq(this)" class="w-full relative h-auto py-4 m-auto flex flex-row bg-[#e9e9e9]   rounded-2xl items-center justify-between z-10 px-6" id="headlessui-disclosure-button-:r2:" type="button"
                        aria-expanded="false" data-headlessui-state=""><span class="text-lg text-[#2c2c2c] font-bold  text-start ">Política de Reembolso e Cancelamento de Ingressos</span><svg xmlns="http://www.w3.org/2000/svg" width="24"
                            height="24" viewBox="0 0 24 24" fill="none" stroke="#2c2c2c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down">
                            <path d="m6 9 6 6 6-6"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-6  text-[#2c2c2c] faq-content hidden">
                        <p>Reembolsos podem ser solicitados em até 7 (sete) dias corridos após a compra, respeitando o
                            limite de 48 horas antes do evento. O valor é devolvido descontando a taxa de serviço. Para
                            solicitar, fale com o suporte da {{ env('EMPRESA') }}.</p>
                    </div>
                </div>

                {{-- Bloco final --}}
                <div class="my-12">
                    <div class="flex flex-col md:flex-row items-center gap-x-8 gap-y-6 md:gap-y-0">
                        {{-- Compradores --}}
                        <div class="bg-green-button rounded-2xl w-full py-8 px-4">
                            <div class="flex flex-col items-center">
                                <h1 class="text-primary-green font-bold text-xl text-center">Ainda com dúvidas?</h1>
                                <p class="text-tertiary-green text-center mt-3">Nossa equipe de suporte está à
                                    disposição.</p>
                                <div class="w-full md:w-[40%] mt-7">
                                    <a target="_blank" href="https://api.whatsapp.com/send?phone=55{{ env('WHATSAPP') }}">
                                        <button type="button" class="bg-primary-green  w-full flex hover:bg-primary-green/90  rounded-full  py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed ">
                                            <div class="flex items-center w-full  justify-center">
                                                <div class=""><span class="text-center text-[#dee6e5]">Fale com a Musa Ticket</span></div>
                                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                                            </div>
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>

                        {{-- Produtores --}}
                        <div class="bg-primary-green rounded-2xl w-full py-8 px-4">
                            <div class="flex flex-col items-center">
                                <h1 class="text-green-light font-bold text-xl text-center">É produtor de eventos?</h1>
                                <p class="text-green-light text-center mt-3">Junte-se aos organizadores que já confiam na
                                    {{ env('EMPRESA') }}.</p>
                                <div class="w-full md:w-[40%] mt-7">
                                    <a target="_blank" href="https://api.whatsapp.com/send?phone=55{{ env('WHATSAPP') }}">
                                        <button type="button" class="bg-green-button  w-full flex hover:bg-green-hover  rounded-full  py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed ">
                                            <div class="flex items-center w-full  justify-center">
                                                <div class=""><span class="text-center text-primary-green">Publique seu evento</span></div>
                                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                                            </div>
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    @include('site.footer')
@endsection

@section('css')
    <style>
        .faq-btn {
            @apply w-full relative py-4 flex flex-row items-center justify-between px-6 bg-[#e9e9e9] rounded-2xl;
        }

        .faq-btn span {
            @apply text-lg text-[#2c2c2c] font-bold text-start;
        }

        .faq-content {
            @apply px-6 pb-6 text-[#2c2c2c];
        }

        .faq-icon {
            transition: transform 0.3s ease;
        }

        .faq-icon.rotate {
            transform: rotate(180deg);
        }
    </style>
@endsection

@section('js')
    <script>
        function toggleFaq(button) {
            const content = button.nextElementSibling;
            const icon = button.querySelector("svg");
            content.classList.toggle("hidden");
            icon.classList.toggle("rotate");
        }
    </script>
@endsection
