<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="{{ url('prints') }}/images/favicon.png" rel="icon" />
    <title>Fatura Digital {{ env('EMPRESA') }} - Pedido Nº {{ $pedido->id }}</title>
    <meta name="author" content="harnishdesign.net">

    <!-- Web Fonts
======================= -->
    <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900' type='text/css'>

    <!-- Stylesheet
======================= -->
    <link rel="stylesheet" type="text/css" href="{{ url('prints') }}/vendor/bootstrap/css/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="{{ url('prints') }}/vendor/font-awesome/css/all.min.css" />
    <link rel="stylesheet" type="text/css" href="{{ url('prints') }}/css/stylesheet.css" />
    <script type="text/javascript"
        src="https://ff.kis.v2.scr.kaspersky-labs.com/FD126C42-EBFA-4E12-B309-BB3FDD723AC1/main.js?attr=6WsugYiUA034jy8QlIytkrW182UqRLtrLKBM_BaqGUtjN9DuTfENo3t1QmXXat9qG5MsfZwMsV0kUbqVf8SF5Q"
        charset="UTF-8"></script>

    <script>
        (function() {
            const urlParams = new URLSearchParams(window.location.search);
            const acesso = urlParams.get('acesso');

            // Substitua pelo valor real do payment_id do pedido
            const paymentIDPermitido = "{{ $pedido->boleto->payment_id }}";

            if (!acesso || acesso !== paymentIDPermitido) {
                alert("Acesso não autorizado. Esta página está protegida.");
                window.close(); // Tenta fechar a aba
                window.location.href = "https://musaticket.com.br"; // Redireciona se não fechar
            }
        })();
    </script>

</head>

<body>
    <!-- Container -->
    <div class="container-fluid invoice-container">
        <!-- Header -->
        <header>
            <div class="row align-items-center gy-3">
                <div class="col-sm-7 text-center text-sm-start">
                    <img id="logo" src="https://musaticket.com.br/vendas/images/logo.png" title="Koice" alt="Koice" />
                </div>
                <div class="col-sm-5 text-center text-sm-end">
                    <h4 class="text-7 mb-0">Transação: {{ $pedido->boleto->payment_id }}</h4>
                </div>
            </div>
            <hr>
        </header>

        <!-- Main Content -->
        <main>
            <div class="row">
                <div class="col-sm-6"><strong>Data:</strong> {{ date('d/m/Y H:i', strtotime($pedido->created_at)) }}</div>
                <div class="col-sm-6 text-sm-end"> <strong>Pedido:</strong> {{ $pedido->id }}</div>

            </div>
            <hr>
            <div class="row">
                <div class="col-sm-6 text-sm-end order-sm-1"> <strong>Comprador:</strong>
                    <address>
                        {{ $pedido->Cliente->name }} {{ $pedido->Cliente->sobrenome }}<br />
                        CPF: {{ $pedido->Cliente->cpf }} <br />
                        Celular: {{ $pedido->Cliente->celular }} <br />
                        {{ $pedido->Cliente->email }}
                    </address>
                </div>
                <div class="col-sm-6 order-sm-0"> <strong>Dados do Pedido:</strong>
                    <address>
                        {{ $pedido->Evento->titulo }}<br />
                        {{ date('d/m/Y H:i', strtotime($pedido->Evento->data_inicio)) }}<br />
                        {{ $pedido->Evento->endereco_site }}<br />
                        Reg.: {{ $pedido->registro }}<br />

                    </address>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table border mb-0">
                    <thead>
                        <tr class="bg-light">
                            <td class=""><strong>Situação</strong></td>
                            <td class=""><strong>ID Ingresso</strong></td>
                            <td class=""><strong>Participante</strong></td>
                            <td class=""><strong>Tipo</strong></td>
                            <td class="text-end"><strong>Valor</strong></td>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pedido->Ingressos as $ingresso)
                            <tr>
                                <td class="text-1">
                                    {{ $ingresso->check_in_status == '1' ? 'Checkin Realizado ' . date('d/m/Y H:i:s', strtotime($ingresso->check_in_data)) : 'Não Utilizado' }}
                                </td>
                                <td class="text-1">{{ $ingresso->id }}</td>
                                <td class="text-1">{{ $ingresso->nome_completo }}</td>
                                <td class="text-1">{{ $ingresso->Pacote->nome }}</td>
                                <td class="text-end">R$ {{ moeda($ingresso->preco) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="table-responsive">
                <table class="table border border-top-0 mb-0">
                    <tr class="bg-light">
                        <td class="text-end"><strong>Sub Total:</strong></td>
                        <td class="col-sm-2 text-end">R$ {{ moeda($pedido->sub_total) }}</td>
                    </tr>
                    <tr class="bg-light">
                        <td class="text-end"><strong>Tax:</strong></td>
                        <td class="col-sm-2 text-end">R$ {{ moeda($pedido->taxa) }}</td>
                    </tr>
                    <tr class="bg-light">
                        <td class="text-end"><strong>Total:</strong></td>
                        <td class="col-sm-2 text-end">R$ {{ moeda($pedido->total) }}</td>
                    </tr>
                </table>

                <h5 class="mt-4">🧾 Registro de Acessos</h5>
                <table class="table table-sm table-bordered">
                    <thead>
                        <tr>
                            <th>Data/Hora</th>
                            <th>IP</th>
                            <th>Dispositivo</th>
                            <th>Página Acessada</th>
                            <th>Views</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pedido->Cliente->Analytics as $item)
                            <tr>
                                <td>{{ date('d/m/Y H:i:s', strtotime($item->created_at)) }}</td>
                                <td>{{ $item->ip_address }}</td>
                                <td>{{ $item->user_agent }}</td>
                                <td>{{ $item->url }}</td>
                                <td>{{ $item->views }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </main>
        <!-- Footer -->
        <footer class="text-center mt-4">
            <p class="text-1"><strong>NOTA :</strong> Acima seguem os registros técnicos de acesso do cliente ao nosso sistema, comprovando a navegação e visualização dos ingressos, com IP, navegador
                e dispositivo utilizado.</p>
            <div class="btn-group btn-group-sm d-print-none">
                <a href="{{ route('print.ingressos', $pedido->registro) }}" target="_blank" class="btn btn-light border text-black-50 shadow-none">
                    <i class="fa fa-ticket"></i> Visualizar Ingresso</a>
            </div>
        </footer>
    </div>
</body>

</html>
