<!doctype html>
<html lang="pt-BR">
<meta name="csrf-token" content="{{ csrf_token() }}">

<head>
    <meta charset="utf-8" />
    <title>Etiqueta 10x4 cm com QR Code</title>
    <style>
        @page {
            size: 100mm 40mm;
            margin: 0;
        }

        html,
        body {
            margin: 0;
            padding: 0;
            width: 100mm;
            height: 40mm;
            background: #fff;
            overflow: hidden;
            font-family: "Segoe UI", Arial, sans-serif;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .label {
            width: 100mm;
            height: 40mm;
            display: flex;
            align-items: center;
            justify-content: flex-start;
            padding: 0 4mm;
            box-sizing: border-box;
            gap: 5mm;
        }

        .qr {
            width: 28mm;
            height: 28mm;
            display: grid;
            place-items: center;
            flex: 0 0 auto;
        }

        .qr canvas,
        .qr img {
            width: 100%;
            height: 100%;
        }

        .info {
            display: flex;
            flex-direction: column;
            justify-content: center;
            line-height: 1.1;
            flex: 1;
            overflow: hidden;
        }

        .nome {
            font-size: 14pt;
            font-weight: 700;
            margin: 0;
            line-height: 1.1em;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            white-space: normal;
        }

        .cargo {
            font-size: 11pt;
            margin: 2px 0 0;
        }

        .empresa {
            font-size: 10pt;
            opacity: 0.8;
            margin: 2px 0 0;
        }

        @media print {
            @page {
                size: 100mm 40mm;
                margin: 0;
            }

            body {
                zoom: 1;
            }

            .label {
                border: none;
                padding: 0 3mm;
            }
        }
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js" defer></script>
</head>

<body>
    <div class="label">
        <div class="qr" id="qrcode"></div>
        <div class="info">
            <h1 class="nome">{{ $dados['nome'] }}</h1>
            <p class="cargo">{{ $dados['cargo'] }}</p>
            <p class="empresa">{{ $dados['empresa'] }}</p>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const el = document.getElementById('qrcode');
            new QRCode(el, {
                text: "{{ $dados['link'] }}",
                width: 280,
                height: 280,
                correctLevel: QRCode.CorrectLevel.H
            });

            // aguarda o QR ser desenhado, depois imprime automaticamente
            setTimeout(() => {
                window.print();

                // fecha a aba automaticamente após imprimir (opcional)
                setTimeout(() => window.close(), 500);
            }, 400);
        });
    </script>
</body>

</html>
