@extends('site.base')
@section('titulo', 'Minhas Compras | Acesse e Baixe Sua Carteira na UCESUB')
@section('description', '')
@section('image', url('site/images/favicon.png'))

@section('content')
    <div class="pt-[64px]">
        <div class="relative bg-primary-white px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">
            <section class="relative py-6 md:py-10 h-full w-full">

                {{-- Cabeçalho --}}
                <div class="w-full md:border-b-2 md:border-gray-light mb-4">
                    <h2 class="font-bold text-2xl md:text-3xl text-primary-green">Minhas Compras</h2>
                    <div class="md:flex -mb-0.5 overflow-x-auto md:overflow-hidden gap-3 mt-6">
                        <h1 data-tab="ativos" class="tab-btn cursor-pointer px-1 md:px-3 py-1 text-primary-green border-primary-green border-b-2 font-bold">
                            Ativos
                        </h1>
                        <h1 data-tab="encerrados" class="tab-btn cursor-pointer px-1 md:px-3 py-1 text-gray-dark border-transparent">
                            Encerrados
                        </h1>
                        <h1 data-tab="cancelados" class="tab-btn cursor-pointer px-1 md:px-3 py-1 text-gray-dark border-transparent">
                            Cancelados
                        </h1>
                        <h1 data-tab="parcelamentos" class="tab-btn cursor-pointer px-1 md:px-3 py-1 text-gray-dark border-transparent">
                            Parcelamentos
                        </h1>
                        <h1 data-tab="pendentes" class="tab-btn cursor-pointer px-1 md:px-3 py-1 text-gray-dark border-transparent">
                            Aguardando pagamento
                        </h1>
                    </div>
                </div>

                {{-- Conteúdo --}}
                <div class="mt-6 p-3 bg-white rounded-2xl relative">

                    {{-- Abas --}}
                    <div id="ativos" class="tab-content flex flex-col gap-y-4">
                        @foreach ($Pedidos->whereIN('status', ['Aprovado', 'Pendente']) as $Pedido)
                            @if ($Pedido->Evento->data_fim > now())
                                <div class="bg-[#F4F3F2] p-4 rounded-2xl min-w-full mb-5 relative">
                                    <div class="flex flex-col md:flex-row">
                                        <div class="w-full">
                                            <div>
                                                <h1 class="font-bold text-[#2c2c2c] text-2xl text-center md:text-start">
                                                    {{ $Pedido->Evento->titulo }}
                                                </h1>
                                                <!-- Data do Evento -->
                                                <div class="flex flex-col items-center md:items-start">
                                                    <div class="flex items-center gap-2 mt-2">

                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                            class="lucide lucide-calendar-days text-gray-dark">
                                                            <path d="M8 2v4"></path>
                                                            <path d="M16 2v4"></path>
                                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                            <path d="M3 10h18"></path>
                                                            <path d="M8 14h.01"></path>
                                                            <path d="M12 14h.01"></path>
                                                            <path d="M16 14h.01"></path>
                                                            <path d="M8 18h.01"></path>
                                                            <path d="M12 18h.01"></path>
                                                            <path d="M16 18h.01"></path>
                                                        </svg>
                                                        <p class="text-base text-gray-dark">
                                                            Válida até: {{ $semana[date('w', strtotime($Pedido->Evento->data_fim))] }}, {{ date('d/m/Y', strtotime($Pedido->Evento->data_fim)) }} às {{ date('H:i', strtotime($Pedido->Evento->data_fim)) }}
                                                        </p>
                                                    </div>
                                                </div>

                                                <!-- Bloco principal -->
                                                <div class="flex flex-col md:flex-row mt-4">
                                                    <!-- QR Code e Status -->
                                                    <div class="flex flex-col items-center md:items-start gap-y-3">
                                                        <div>
                                                            <img src="{{ $Pedido->Evento->banner }}" class="corta-img-cover">
                                                        </div>
                                                        {{-- <div class="{{ $Pedido->status == 'Aprovado' ? 'text-green' : 'text-red-500' }}" style="font-size: 20px; justify-content: center;">
                                                            <p style="text-align: center;">{{ $Pedido->status }}</p>
                                                        </div> --}}
                                                        @if ($Pedido->status == 'Pendente')
                                                            @if (!empty($Pedido->Boleto) && !empty($Pedido->Boleto->payment_id))
                                                                <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-600 text-secondary-white">
                                                                    <a onclick="javascript:Processando()" href="{{ route('confirmar.pagamento', $Pedido->Boleto->payment_id) }}">Confirmar Pagamento</a>
                                                                </div>
                                                            @endif
                                                        @endif
                                                        @if ($Pedido->status == 'Aprovado')
                                                            <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-{{ $status_pagamento[$Pedido->status] }}-600 text-secondary-white text-[12px]">
                                                                @if (empty(Auth::user()->foto))
                                                                    <a href="{{ route('minha.conta') }}" target="_blank">
                                                                        Atualizar Foto
                                                                    </a>
                                                                @else
                                                                    <a href="https://ucesub.com.br/carteira/{{ $Pedido->registro }}/{{ date('Y', strtotime($Pedido->created_at)) }}" target="_blank">
                                                                        Abrir Carteira
                                                                    </a>
                                                                @endif
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <!-- Detalhes -->
                                                    <div class="my-6 md:my-0">
                                                        <div class="flex flex-col gap-2 ml-0 md:ml-4">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]"> ID Pedido:</span> {{ $Pedido->id }} <br>
                                                                <span class="font-bold text-[#2c2c2c]"> Valor:</span> R$ {{ moeda($Pedido->total) }}<br>
                                                                <span class="font-bold text-[#2c2c2c]"> Pagamento:</span> {{ $Pedido->forma_pagamento }}
                                                            </h1>
                                                            <hr class="border border-gray-border">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]">Registro:</span> {{ $Pedido->registro }}<br>
                                                                @if ($Pedido->pdv != 'Manual' || !empty($Pedido->Boleto?->payment_id))
                                                                    <span class="font-bold text-[#2c2c2c]">Cod. Pagamento:</span>
                                                                    {{ $Pedido->Boleto?->payment_id }}<br>
                                                                @endif
                                                                <span class="font-bold text-[#2c2c2c]">Nome:</span> {{ Auth::user()->name }} {{ Auth::user()->sobrenome }}<br>
                                                                <span class="font-bold text-[#2c2c2c]">Data da compra:</span> {{ date('d/m/Y', strtotime($Pedido->created_at)) }} às
                                                                {{ date('H:i', strtotime($Pedido->created_at)) }} <br>
                                                                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{ setUri2(env('WHATSAPP')) }}&text=Olá eu me chamo {{ Auth::user()->name }}, estou no site da {{ env('EMPRESA') }} e preciso de ajuda para meu pedido Nº {{ $Pedido->id }}"
                                                                    target="_blank" class="text-red-500">Solicitar Ajuda</a>
                                                            </h1>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                    <div id="encerrados" class="tab-content hidden flex-col gap-y-4">
                        @foreach ($Pedidos->where('status', 'Aprovado') as $Pedido)
                            @if ($Pedido->Evento->data_fim < now())
                                <div class="bg-[#F4F3F2] p-4 rounded-2xl min-w-full mb-5 relative">
                                    <div class="flex flex-col md:flex-row">
                                        <div class="w-full">
                                            <div>
                                                <h1 class="font-bold text-[#2c2c2c] text-2xl text-center md:text-start">
                                                    {{ $Pedido->Evento->titulo }}
                                                </h1>
                                                <!-- Data do Evento -->
                                                <div class="flex flex-col items-center md:items-start">
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                                                            <path
                                                                d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10" />
                                                            <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6" />
                                                        </svg>
                                                        <p class="text-base text-gray-dark">
                                                            {{ $Pedido->Evento->local }} - {{ $Pedido->Evento->endereco_site }}
                                                        </p>
                                                    </div>
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                            class="lucide lucide-calendar-days text-gray-dark">
                                                            <path d="M8 2v4"></path>
                                                            <path d="M16 2v4"></path>
                                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                            <path d="M3 10h18"></path>
                                                            <path d="M8 14h.01"></path>
                                                            <path d="M12 14h.01"></path>
                                                            <path d="M16 14h.01"></path>
                                                            <path d="M8 18h.01"></path>
                                                            <path d="M12 18h.01"></path>
                                                            <path d="M16 18h.01"></path>
                                                        </svg>
                                                        <p class="text-base text-gray-dark">
                                                            {{ $semana[date('w', strtotime($Pedido->Evento->data_inicio))] }}, {{ date('d/m/Y', strtotime($Pedido->Evento->data_inicio)) }} às {{ date('H:i', strtotime($Pedido->Evento->data_inicio)) }}
                                                        </p>
                                                    </div>
                                                </div>

                                                <!-- Bloco principal -->
                                                <div class="flex flex-col md:flex-row mt-4">
                                                    <!-- QR Code e Status -->
                                                    <div class="flex flex-col items-center md:items-start gap-y-3">
                                                        <div>
                                                            <img src="{{ $Pedido->Evento->banner }}" class="corta-img-cover">
                                                        </div>
                                                        <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-500 text-secondary-white" style="font-size: 12px;">
                                                            Finalizado
                                                        </div>
                                                        @if ($Pedido->status == 'Aprovado')
                                                            <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-500 text-secondary-white" style="font-size: 12px;">
                                                                <a href="{{ route('print.ingressos', $Pedido->registro) }}" target="_blank">
                                                                    Ver Ticket
                                                                </a>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <!-- Detalhes -->
                                                    <div class="my-6 md:my-0">
                                                        <div class="flex flex-col gap-2 ml-0 md:ml-4">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]"> ID Pedido:</span> {{ $Pedido->id }} <br>
                                                                <span class="font-bold text-[#2c2c2c]"> Valor:</span> R$ {{ moeda($Pedido->total) }}<br>
                                                                <span class="font-bold text-[#2c2c2c]"> Pagamento:</span> {{ $Pedido->forma_pagamento }}
                                                            </h1>
                                                            <hr class="border border-gray-border">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]">Registro:</span> {{ $Pedido->registro }}<br>
                                                                @if ($Pedido->pdv != 'Manual')
                                                                    <span class="font-bold text-[#2c2c2c]">Cod. Pagamento:</span> {{ $Pedido->Boleto->payment_id }}<br>
                                                                @endif
                                                                <span class="font-bold text-[#2c2c2c]">Data da compra:</span> {{ date('d/m/Y', strtotime($Pedido->created_at)) }} às
                                                                {{ date('H:i', strtotime($Pedido->created_at)) }} <br>
                                                            </h1>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                    <div id="cancelados" class="tab-content hidden flex-col gap-y-4">
                        @foreach ($Pedidos->where('status', 'Cancelado') as $Pedido)
                            <div class="bg-[#F4F3F2] p-4 rounded-2xl min-w-full mb-5 relative">
                                <div class="flex flex-col md:flex-row">
                                    <div class="w-full">
                                        <div>
                                            <h1 class="font-bold text-[#2c2c2c] text-2xl text-center md:text-start">
                                                {{ $Pedido->Evento->titulo }}
                                            </h1>
                                            <!-- Data do Evento -->
                                            <div class="flex flex-col items-center md:items-start">
                                                <div class="flex items-center gap-2 mt-2">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                                                        <path
                                                            d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10" />
                                                        <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6" />
                                                    </svg>
                                                    <p class="text-base text-gray-dark">
                                                        {{ $Pedido->Evento->local }} - {{ $Pedido->Evento->endereco_site }}
                                                    </p>
                                                </div>
                                                <div class="flex items-center gap-2 mt-2">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="lucide lucide-calendar-days text-gray-dark">
                                                        <path d="M8 2v4"></path>
                                                        <path d="M16 2v4"></path>
                                                        <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                        <path d="M3 10h18"></path>
                                                        <path d="M8 14h.01"></path>
                                                        <path d="M12 14h.01"></path>
                                                        <path d="M16 14h.01"></path>
                                                        <path d="M8 18h.01"></path>
                                                        <path d="M12 18h.01"></path>
                                                        <path d="M16 18h.01"></path>
                                                    </svg>
                                                    <p class="text-base text-gray-dark">
                                                        {{ $semana[date('w', strtotime($Pedido->Evento->data_inicio))] }}, {{ date('d/m/Y', strtotime($Pedido->Evento->data_inicio)) }} às {{ date('H:i', strtotime($Pedido->Evento->data_inicio)) }}
                                                    </p>
                                                </div>
                                            </div>

                                            <!-- Bloco principal -->
                                            <div class="flex flex-col md:flex-row mt-4">
                                                <!-- QR Code e Status -->
                                                <div class="flex flex-col items-center md:items-start gap-y-3">
                                                    <div>
                                                        <img src="{{ $Pedido->Evento->banner }}" class="corta-img-cover">
                                                    </div>
                                                    <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-500 text-secondary-white">
                                                        {{ $Pedido->status }}
                                                    </div>
                                                </div>
                                                <!-- Detalhes -->
                                                <div class="my-6 md:my-0">
                                                    <div class="flex flex-col gap-2 ml-0 md:ml-4">
                                                        <h1 class="text-gray-dark text-base">
                                                            <span class="font-bold text-[#2c2c2c]"> ID Pedido:</span> {{ $Pedido->id }} <br>
                                                            <span class="font-bold text-[#2c2c2c]"> Valor:</span> R$ {{ moeda($Pedido->total) }}<br>
                                                            <span class="font-bold text-[#2c2c2c]"> Pagamento:</span> {{ $Pedido->forma_pagamento }}
                                                        </h1>
                                                        <hr class="border border-gray-border">
                                                        <h1 class="text-gray-dark text-base">
                                                            <span class="font-bold text-[#2c2c2c]">Registro:</span> {{ $Pedido->registro }}<br>
                                                            @if ($Pedido->pdv != 'Manual')
                                                                <span class="font-bold text-[#2c2c2c]">Cod. Pagamento:</span> {{ $Pedido->Boleto->payment_id }}<br>
                                                            @endif
                                                            <span class="font-bold text-[#2c2c2c]">Data da compra:</span> {{ date('d/m/Y', strtotime($Pedido->created_at)) }} às
                                                            {{ date('H:i', strtotime($Pedido->created_at)) }} <br>
                                                        </h1>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div id="parcelamentos" class="tab-content hidden flex-col gap-y-4">

                    </div>

                    <div id="pendentes" class="tab-content hidden flex-col gap-y-4">
                        @foreach ($Pedidos->where('status', 'Pendente') as $Pedido)
                            @if ($Pedido->Evento->data_fim > now())
                                <div class="bg-[#F4F3F2] p-4 rounded-2xl min-w-full mb-5 relative">
                                    <div class="flex flex-col md:flex-row">
                                        <div class="w-full">
                                            <div>
                                                <h1 class="font-bold text-[#2c2c2c] text-2xl text-center md:text-start">
                                                    {{ $Pedido->Evento->titulo }}
                                                </h1>
                                                <!-- Data do Evento -->
                                                <div class="flex flex-col items-center md:items-start">
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                                                            <path
                                                                d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10" />
                                                            <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6" />
                                                        </svg>
                                                        <p class="text-base text-gray-dark">
                                                            {{ $Pedido->Evento->local }} - {{ $Pedido->Evento->endereco_site }}
                                                        </p>
                                                    </div>
                                                    <div class="flex items-center gap-2 mt-2">

                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round" class="lucide lucide-calendar-days text-gray-dark">
                                                            <path d="M8 2v4"></path>
                                                            <path d="M16 2v4"></path>
                                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                                            <path d="M3 10h18"></path>
                                                            <path d="M8 14h.01"></path>
                                                            <path d="M12 14h.01"></path>
                                                            <path d="M16 14h.01"></path>
                                                            <path d="M8 18h.01"></path>
                                                            <path d="M12 18h.01"></path>
                                                            <path d="M16 18h.01"></path>
                                                        </svg>
                                                        <p class="text-base text-gray-dark">
                                                            {{ $semana[date('w', strtotime($Pedido->Evento->data_inicio))] }}, {{ date('d/m/Y', strtotime($Pedido->Evento->data_inicio)) }} às {{ date('H:i', strtotime($Pedido->Evento->data_inicio)) }}
                                                        </p>
                                                    </div>
                                                </div>

                                                <!-- Bloco principal -->
                                                <div class="flex flex-col md:flex-row mt-4">
                                                    <!-- QR Code e Status -->
                                                    <div class="flex flex-col items-center md:items-start gap-y-3">
                                                        <div>
                                                            <img src="{{ $Pedido->Evento->banner }}" class="corta-img-cover">
                                                        </div>
                                                        <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-{{ $status_pagamento[$Pedido->status] }}-600 text-secondary-white" style="font-size: 12px;">
                                                            {{ $Pedido->status }}
                                                        </div>
                                                        @if ($Pedido->status == 'Pendente')
                                                            <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-600 text-secondary-white" style="font-size: 12px;">
                                                                @if (!empty($Pedido->Boleto) && !empty($Pedido->Boleto->payment_id))
                                                                    <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-red-600 text-secondary-white" style="font-size: 12px;">
                                                                        <a onclick="javascript:Processando()" href="{{ route('confirmar.pagamento', $Pedido->Boleto->payment_id) }}">Confirmar Pagamento</a>
                                                                    </div>
                                                                @else
                                                                    <a target="_blank"
                                                                        href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{ setUri2(env('WHATSAPP')) }}&text=Olá eu me chamo {{ Auth::user()->name }}, estou no site da {{ env('EMPRESA') }} e preciso de ajuda para meu pedido Nº {{ $Pedido->id }}">Falar
                                                                        com suporte</a>
                                                                @endif
                                                            </div>
                                                        @endif
                                                        @if ($Pedido->status == 'Aprovado')
                                                            <a href="{{ route('print.ingressos', $Pedido->registro) }}" target="_blank" style="font-size: 12px;">
                                                                <div class="rounded-full w-[80%] md:w-full text-center py-1 bg-{{ $status_pagamento[$Pedido->status] }}-600 text-secondary-white" style="font-size: 12px;">
                                                                    Emitir Ingresso
                                                                </div>
                                                            </a>
                                                        @endif
                                                    </div>
                                                    <!-- Detalhes -->
                                                    <div class="my-6 md:my-0">
                                                        <div class="flex flex-col gap-2 ml-0 md:ml-4">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]"> ID Pedido:</span> {{ $Pedido->id }} <br>
                                                                <span class="font-bold text-[#2c2c2c]"> Valor:</span> R$ {{ moeda($Pedido->total) }}<br>
                                                                <span class="font-bold text-[#2c2c2c]"> Pagamento:</span> {{ $Pedido->forma_pagamento }}
                                                            </h1>
                                                            <hr class="border border-gray-border">
                                                            <h1 class="text-gray-dark text-base">
                                                                <span class="font-bold text-[#2c2c2c]">Registro:</span> {{ $Pedido->registro }}<br>
                                                                @if ($Pedido->pdv != 'Manual')
                                                                    <span class="font-bold text-[#2c2c2c]">Cod. Pagamento:</span> {{ $Pedido->Boleto->payment_id }}<br>
                                                                @endif
                                                                <span class="font-bold text-[#2c2c2c]">Data da compra:</span> {{ date('d/m/Y', strtotime($Pedido->created_at)) }} às
                                                                {{ date('H:i', strtotime($Pedido->created_at)) }} <br>
                                                                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{ setUri2(env('WHATSAPP')) }}&text=Olá eu me chamo {{ Auth::user()->name }}, estou no site da {{ env('EMPRESA') }} e preciso de ajuda para meu pedido Nº {{ $Pedido->id }}"
                                                                    target="_blank" class="text-red-500">Solicitar Ajuda</a>
                                                            </h1>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                </div>
            </section>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                // remove ativo
                document.querySelectorAll('.tab-btn').forEach(el => {
                    el.classList.remove('text-primary-green', 'border-primary-green', 'border-b-2', 'font-bold');
                    el.classList.add('text-gray-dark', 'border-transparent');
                });

                // esconde conteúdo
                document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));

                // ativa tab clicada
                btn.classList.add('text-primary-green', 'border-primary-green', 'border-b-2', 'font-bold');
                btn.classList.remove('text-gray-dark', 'border-transparent');

                document.getElementById(btn.dataset.tab).classList.remove('hidden');
            });
        });

        @if (session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: '{{ session('success') }}',
                confirmButtonText: 'OK',
                confirmButtonColor: '#16a34a' // Verde Tailwind (bg-green-600)
            });
        @endif

        @if (session('error'))
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: '{{ session('error') }}',
                confirmButtonText: 'Fechar',
                confirmButtonColor: '#dc2626' // Vermelho Tailwind (bg-red-600)
            });
        @endif

        function Processando() {
            var timerInterval;
            Swal.fire({
                title: "Consultando seu pagamento...",
                html: "Aguarde... <b></b>",
                timer: 10000,
                timerProgressBar: true,
                didOpen: function() {
                    Swal.showLoading();
                    var b = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(function() {
                        var left = Swal.getTimerLeft ? Swal.getTimerLeft() : 0;
                        if (b) {
                            b.textContent = Math.ceil(left / 1000) + "s";
                        }
                    }, 100);
                },
                willClose: function() {
                    clearInterval(timerInterval);
                }
            });
        }
    </script>
@endsection
@section('js')
    <script>
        function Cancelar(id) {

        }
    </script>
@endsection
@section('css')
    <style>
        @keyframes pulse {
            0% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.6);
            }

            70% {
                transform: scale(1.05);
                box-shadow: 0 0 15px 5px rgba(255, 255, 255, 0);
            }

            100% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
            }
        }

        .pulse {
            animation: pulse 1.5s infinite;
        }
    </style>
@endsection
