@extends('cliente.base')
@section('titulo','Área do Cliente')
@section('content')
<div class="main-content">
    <div class="row">
        <div class="col-xl-12">
            <div class="main-content-title-profile mb-50">
                <div class="author-area">
                    <div class="author-img">
                        @php
                            $foto = Auth::user()->foto;
                        @endphp
                        <img src="{{ !empty($foto) ? url("storage/{$foto}") : url('site/asset/user.png')}}" alt>
                    </div>
                    <div class="author-content">
                        <span>{{$saudacao}},</span>
                        <h4>{{Auth::user()->name}}</h4>
                    </div>
                </div>
            </div>
            <div class="tour-facilites-section mb-120 mt-50">
                <div class="container">
                    <div class="row">
                        <div class="flex-wrap gap-4 col-lg-12 d-flex flex-column align-items-center justify-content-between mb-60">
                            <div class="text-center section-title">
                                <h3>Próximos Eventos</h3>
                            </div>
                            <ul class="nav nav-tabs" id="facilitesTab" role="tablist">
                                @foreach ($categorias as $k => $categoria)
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="{{ $categoria->url }}-tab" data-bs-toggle="tab" data-bs-target="#{{ $categoria->url }}" type="button" role="tab" aria-controls="{{ $categoria->url }}" aria-selected="false">
                                            <img src="{{ url("storage/{$categoria->ico}") }}" width="20">
                                            {{ $categoria->titulo }}
                                        </button>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tab-content" id="facilitesTabContent">
                                <div class="tab-pane fade show active" id="{{ $categoria->url }}" role="tabpanel" aria-labelledby="{{ $categoria->url }}-tab">
                                    <div class="row g-4">
                                        @foreach ($eventos as $evento)
                                            <div class="col-lg-4 col-md-6">
                                                <div class="package-card">
                                                    <div class="package-card-img-wrap">
                                                        <a href="{{ route('site.evento', [$evento->url, $evento->id]) }}" class="card-img">
                                                            <img src="{{ $evento->banner }}" alt>
                                                        </a>
                                                        <div class="batch">
                                                            <span class="date">
                                                                <i class="bi bi-calendar3" style="margin-right: 5px;"></i> {{ $semana[date('w', strtotime($evento->data_inicio))] }}, {{ date('d', strtotime($evento->data_inicio)) }} {{ substr($mes[date('m', strtotime($evento->data_inicio))], 0, 3) }}
                                                            </span>
                                                            <div class="location">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                                                                    <path
                                                                        d="M8.99939 0C5.40484 0 2.48047 2.92437 2.48047 6.51888C2.48047 10.9798 8.31426 17.5287 8.56264 17.8053C8.79594 18.0651 9.20326 18.0646 9.43613 17.8053C9.68451 17.5287 15.5183 10.9798 15.5183 6.51888C15.5182 2.92437 12.5939 0 8.99939 0ZM8.99939 9.79871C7.19088 9.79871 5.71959 8.32739 5.71959 6.51888C5.71959 4.71037 7.19091 3.23909 8.99939 3.23909C10.8079 3.23909 12.2791 4.71041 12.2791 6.51892C12.2791 8.32743 10.8079 9.79871 8.99939 9.79871Z">
                                                                    </path>
                                                                </svg>
                                                                <ul class="location-list">
                                                                    <li><a href="javascript:void(0)">{{ $evento->local }}</a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="package-card-content">
                                                        <div class="card-content-top">
                                                            <h5><a href="{{ route('site.evento', [$evento->url, $evento->id]) }}">{{ $evento->titulo }}</a></h5>
                                                            <div class="location-area">
                                                                <ul class="location-list scrollTextAni">
                                                                    <li><i class="bi bi-geo-alt"></i> {{ $evento->endereco_site }}</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                        <div class="card-content-bottom">
                                                            <div class="price-area">
                                                                <h6>A parti de</h6>
                                                                <span>R$ {{ moeda($evento->pacoteMaisBarato()->preco) }} </span>
                                                                <p>(+ R$ {{ moeda(porcentagem(env('TAXA'), $evento->pacoteMaisBarato()->preco)) }} TAXA)</p>
                                                            </div>
                                                            <a href="{{ route('site.evento', [$evento->url, $evento->id]) }}" class="primary-btn2">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-ticket-perforated" viewBox="0 0 16 16">
                                                                    <path d="M4 4.85v.9h1v-.9zm7 0v.9h1v-.9zm-7 1.8v.9h1v-.9zm7 0v.9h1v-.9zm-7 1.8v.9h1v-.9zm7 0v.9h1v-.9zm-7 1.8v.9h1v-.9zm7 0v.9h1v-.9z" />
                                                                    <path d="M1.5 3A1.5 1.5 0 0 0 0 4.5V6a.5.5 0 0 0 .5.5 1.5 1.5 0 1 1 0 3 .5.5 0 0 0-.5.5v1.5A1.5 1.5 0 0 0 1.5 13h13a1.5 1.5 0 0 0 1.5-1.5V10a.5.5 0 0 0-.5-.5 1.5 1.5 0 0 1 0-3A.5.5 0 0 0 16 6V4.5A1.5 1.5 0 0 0 14.5 3zM1 4.5a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 .5.5v1.05a2.5 2.5 0 0 0 0 4.9v1.05a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-1.05a2.5 2.5 0 0 0 0-4.9z" />
                                                                </svg> Comprar Agora
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
