<div class="row">
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Nº Transação:</strong></p>
        <p>{{ empty($pedido->Boleto->id) ? 'Indisponível' : $pedido->Boleto->id }}</p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Pedido:</strong></p>
        <p>{{ $pedido->id }} - {{ $pedido->registro }}</p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Data do pedido:</strong></p>
        <p>{{ date('d/m/Y', strtotime($pedido->created_at)) }} às {{ date('H:i', strtotime($pedido->created_at)) }}</p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Valor total:</strong></p>
        <p>R$ {{ moeda($pedido->total) }}</p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Situação:</strong></p>
        <div class="iso-bootstrap">
            <span class="badge bg-{{ $status_pagamento[$pedido->status] }} badge-django">{{ $pedido->status }}</span>
            @if ($pedido->status == 'Aprovado')
                <a href="{{ route('print.ingressos', $pedido->registro) }}" target="_blank" class="excluir-pedido">
                    <span class="badge bg-success badge-django">Ingresso</span>
                </a>
            @endif
        </div>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Forma de pagamento:</strong></p>
        <p>{{ $pedido->forma_pagamento }}</p>
    </div>
    <div class="col-md-6 text-muted">
        <p class="mb-1"><strong>Evento:</strong></p>
        <p>{{ $pedido->Evento->titulo }}</p>
    </div>
    <div class="col-md-12 text-muted">
        <p class="mb-1"><strong>Comprador:</strong></p>
        <p>{{ $pedido->Cliente->name }} {{ $pedido->Cliente->sobrenome }} - {{ $pedido->Cliente->email }}</p>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <h4>Ingressos</h4>
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <th scope="col">Nome completo / E-mail</th>
                        <th scope="col">Tipo</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Taxa</th>
                        <th scope="col">Total</th>
                    </tr>
                </thead>
                <tbody style="font-size: 12px;">
                    @foreach ($pedido->IngressosCliente as $ingresso)
                        <tr>
                            <td>{{ $ingresso->nome_completo }}<br>{{ $ingresso->email }}</td>
                            <td>{{ $ingresso->Pacote->nome }}</td>
                            <td>R$ {{ moeda($ingresso->preco) }}</td>
                            <td>R$ {{ moeda($ingresso->taxa) }}</td>
                            <td>R$ {{ moeda($ingresso->preco + $ingresso->taxa) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>Total</td>
                        <td>R$ {{ moeda($pedido->total) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<div id="divParticipantEdit" class="row mb-4" style="display:none;">
    <div class="col-md-12">
        <hr>
        <h4>Editar participante</h4>
        <div id="participantEditBody">
        </div>
    </div>
</div>
<script>
    $(document).on('click', '.excluir-pedido', function() {
        let pedidoId = $(this).data('id');

        $.ajax({
            url: '{{ route('pedido.destroy') }}',
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                id: pedidoId
            },
            success: function(response) {
                // Fechar o modal
                $('#meuModal').modal('hide');

                // Remover visualmente o ingresso/pedido
                $('#pedido-' + pedidoId).fadeOut();

                // Exibir mensagem ou feedback se quiser
                console.log('Pedido excluído com sucesso.');
            },
            error: function() {
                alert('Erro ao excluir o pedido.');
            }
        });
    });
</script>
