@extends('carteira.base')
@section('titulo', 'Carteira')

@section('content')
    @if ($pedido)
        <div class="appHeader bg-primary text-light">
            <div class="pageTitle">DOCUMENTO VÁLIDO</div>
        </div>

        <div id="appCapsule">
            <div class="section mt-2">
                <div class="card-block mb-2" style="background-color: transparent;">
                    <div class="carteira-wrapper">

                        <div class="campo nome-principal">
                            {{ $ingresso->nome_completo }}
                        </div>

                        <!-- IMAGEM BASE -->
                        <img src="https://ucesub.com.br/storage/carteira/{{ date('Y') }}.png" class="carteira-base" alt="Carteira Estudantil">

                        <!-- FOTO -->
                        <div class="campo foto">
                            <img src="{{ $ingresso->foto }}">
                        </div>

                        <!-- DADOS -->
                        <div class="campo dados">
                            <div>CPF: {{ $ingresso->cpf }}</div>
                            <div>Data nasc.: {{ date('d/m/Y', strtotime($cliente->nascimento)) }}</div>
                            <div>Instituição: {{ $ingresso->instituicao_ensino }}</div>
                            <div>Nível de Ensino: {{ $ingresso->nivel_ensino }}</div>
                            <div>Curso: {{ $ingresso->curso }}</div>
                        </div>

                        <!-- QR CODE -->
                        <div class="campo qrcode">
                            <img src="{{ $qrcode }}">
                            <div class="codigo">
                                <small>CÓD. DE USO</small><br>
                                <strong>{{ $ingresso->registro }}</strong>
                            </div>
                        </div>


                    </div>
                </div>
            </div>

            <div class="section" style="margin-top: 80px;">
                <div class="section-title">Certificado de Atributo</div>
                <div class="card">
                    <div class="card-body" style="font-size: 8px; text-align: justify;">
                        {{ $certificado }}
                    </div>
                </div>
            </div>
        </div>
    @else
        <div class="appHeader bg-danger text-light">
            <div class="pageTitle">DOCUMENTO INVÁLIDO</div>
        </div>
    @endif
@endsection

@section('css')
    <style>
        .campo.nome-principal {
            left: 9%;
            top: 24%;
            width: 70%;
            font-size: 12px;
            text-transform: uppercase;
            color: #111827;
            font-weight: bold;
        }

        .carteira-wrapper {
            position: relative;
            width: 100%;
            max-width: 720px;
            margin: auto;
        }

        /* IMAGEM BASE */
        .carteira-base {
            width: 100%;
            display: block;
            border-radius: 16px;
        }

        /* CAMPOS SOBRE A IMAGEM */
        .campo {
            position: absolute;
            font-family: Arial, Helvetica, sans-serif;
            color: #1f2937;
        }

        /* FOTO */
        .campo.foto {
            left: 9%;
            top: 38%;
            width: 100px;
            aspect-ratio: 3 / 4;
        }

        .campo.foto img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 6px;
        }

        /* DADOS */
        .campo.dados {
            left: 36%;
            top: 40%;
            width: 38%;
            font-size: clamp(11px, 1.6vw, 14px);
            line-height: 1.4;
        }

        .campo.dados .nome {
            font-weight: bold;
            font-size: 12px;
            margin-bottom: 8px;
            text-transform: uppercase;
        }

        /* QR CODE */
        .campo.qrcode {
            right: 12px;
            top: 32%;
            width: 18%;
            text-align: center;
        }

        .campo.qrcode img {
            width: 60px;
            height: auto;
        }

        .campo.qrcode .codigo {
            margin-top: 6px;
            font-size: 11px;
        }

        /* VALIDADE */
        .campo.validade {
            left: 40%;
            bottom: 12%;
            font-size: clamp(12px, 2vw, 16px);
            font-weight: 600;
        }

        /* ANO */
        .campo.ano {
            right: 8%;
            bottom: 10%;
            font-size: clamp(28px, 6vw, 54px);
            font-weight: 800;
            color: #1f4ea8;
        }
    </style>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        @if ($pedido)
            Swal.fire({
                title: "Sucesso!",
                text: "Documento Válido",
                icon: "success"
            });
        @else
            Swal.fire({
                title: "Atenção!",
                text: "Documento Inválido",
                icon: "error"
            });
        @endif
    </script>
@endsection
