@extends('site.base')
@section('titulo', 'Recuperar Senha | Musa Ticket')
@section('description','Esqueceu sua senha? Recupere o acesso à sua conta da Musa Ticket de forma rápida e segura. Basta informar seu e-mail e siga os passos.')
@section('url',route('login'))
@section('image',url('site/images/favicon.png'))
@section('content')
    <div id="wrapper">
        <div class="auth py-5">
            <div class="container">
                <div class="row">
                    <div class="col-xl-5 col-lg-7 col-md-9 col-sm-11 mx-auto">
                        <div class="card">
                            <div class="card-body p-sm-5">
                                <h4><span class="text-primary">Recupere sua conta</span></h4>
                                <p class="fs-6">Escolha uma nova senha para continuar.</p>
                                @if (session('status'))
                                    <div class="alert alert-success">
                                        <strong>{{ session('status') }}</strong>
                                    </div>
                                @endif

                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            @foreach ($errors->all() as $error)
                                                <li><strong>{{ $error }}</strong></li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="{{ route('password.store') }}">
                                    @csrf
                                    <input type="hidden" name="token" value="{{ $request->route('token') }}">
                                    <div class="mb-3">
                                        <label for="username" class="form-label fw-medium">E-mail</label>
                                        <input name="email" type="text" id="username" class="form-control" value="{{ old('email', $request->email) }}">
                                    </div>
                                    <div class="mb-2">
                                        <label for="password" class="form-label fw-medium">Senha</label>
                                        <input name="password" type="password" id="password" class="form-control">
                                    </div>
                                    <div class="mb-2">
                                        <label for="password_confirmation" class="form-label fw-medium">Confirme a Senha</label>
                                        <input name="password_confirmation" type="password" id="password_confirmation" class="form-control">
                                    </div>

                                    <div class="mb-5">
                                        <input type="submit" class="btn btn-primary w-100" value="Atualizar">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


{{-- @extends('site.base')
@section('titulo', 'Crie uma nova senha')
@section('content')
<div id="content">
    <div class="container mt-8 mb-6">
        <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="{{ route('password.store') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $request->route('token') }}">
            <h3 class="title-divider"><span>Login</span></h3>
            <p class="text-muted text-center">Informe abaixo seu e-mail e senha.</p>
            <div class="form-group">
                <input type="email" name="email" class="form-control email" value="{{old('email', $request->email)}}" required="required">
                @error('email')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
            <div class="form-group">
                <input type="password" name="password" class="form-control password" placeholder="Senha" required="required">
                @error('password')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
            <div class="form-group">
                <input type="password" name="password_confirmation" class="form-control password" placeholder="Senha" required="required">
            </div>
            <button type="submit" id="loginBtn" class="btn btn-primary btn-lg btn-block">Atualizar</button>
        </form>
    </div>
</div>
<div id="loader" style="display: none;"></div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            $("#loginBtn").click(function() {
                $('#loader').show();
                document.getElementById("loginForm").submit();
            });
            $("#recuperar").click(function() {
                $('#loader').show();
                document.getElementById("formRecoverPassword").submit();
            });
        });
    </script>
@endsection --}}

{{-- <x-guest-layout>
    <form method="POST" action="{{ route('password.store') }}">
        @csrf

        <!-- Password Reset Token -->
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        <!-- Email Address -->
        <div>
            <x-input-label for="email" :value="__('Email')" />
            <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email', $request->email)" required autofocus autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="mt-4">
            <x-input-label for="password" :value="__('Password')" />
            <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="new-password" />
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="mt-4">
            <x-input-label for="password_confirmation" :value="__('Confirm Password')" />

            <x-text-input id="password_confirmation" class="block mt-1 w-full"
                                type="password"
                                name="password_confirmation" required autocomplete="new-password" />

            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="flex items-center justify-end mt-4">
            <x-primary-button>
                {{ __('Recuperar') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout> --}}
