@extends('site.base')
@section('titulo', 'Recuperar Senha | Musa Ticket')
@section('description','Esqueceu sua senha? Recupere o acesso à sua conta da Musa Ticket de forma rápida e segura. Basta informar seu e-mail e siga os passos.')
@section('url',route('password.request'))
@section('image',url('site/images/favicon.png'))
@section('content')
<div id="wrapper">
    <div class="auth py-5">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-lg-7 col-md-9 col-sm-11 mx-auto">
                    <div class="card">
                        <div class="card-body p-sm-5">

                            <h4><span class="text-primary">Recuperação da conta</span></h4>
                            @if (session('status'))
                                <div class="alert alert-success">
                                    <strong>{{ session('status') }}</strong>
                                </div>
                            @endif

                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul class="mb-0">
                                        @foreach ($errors->all() as $error)
                                            <li><strong>{{ $error }}</strong></li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="{{ route('password.email') }}">
                                @csrf
                                <div class="mb-3">
                                    <label for="email" class="form-label fw-medium">Digite seu E-mail</label>
                                    <input name="email" type="email" id="email" class="form-control">
                                </div>
                                <div class="mb-5">
                                    <input type="submit" class="btn btn-primary w-100" value="Enviar">
                                </div>
                                <p>Possui uma conta? <br><a href="{{ route('login') }}" class="fw-medium external">Voltar e logar!</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')

@endsection
