@extends('app.base')
@section('content')
    <!-- loader -->
    <div id="loader">
        <img src="{{ url('app') }}/assets/img/loading-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Meu perfil
        </div>
    </div>
    <div id="appCapsule">

        <div class="section mt-3 text-center">
            <div class="avatar-section">
                <a href="#">
                    @if (!empty(Auth::user()->foto))
                        <img src="{{ url('app') }}/assets/img/account.png" alt="avatar" class="imaged w100 rounded">
                    @else
                        <img src="{{ url('app') }}/assets/img/account.png" alt="avatar" class="imaged w100 rounded">
                    @endif
                    <span class="button">
                        <ion-icon name="camera-outline"></ion-icon>
                    </span>
                </a>
            </div>
        </div>

        <div class="listview-title mt-1">Thema</div>
        <ul class="listview image-listview text inset no-line">
            <li>
                <div class="item">
                    <div class="in">
                        <div>
                            Modo Noturno
                        </div>
                        <div class="form-check form-switch  ms-2">
                            <input class="form-check-input dark-mode-switch" type="checkbox" id="darkmodeSwitch">
                            <label class="form-check-label" for="darkmodeSwitch"></label>
                        </div>
                    </div>
                </div>
            </li>
        </ul>

        <div class="listview-title mt-1">Configurações</div>
        <ul class="listview image-listview text inset">
            <li>
                <a href="{{ route('perfil.edit') }}" class="item">
                    <div class="in">
                        <div>Dados Pessoais</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="{{ route('perfil.edit.password') }}" class="item">
                    <div class="in">
                        <div>Segurança</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="javascript:void(0)" onclick="Sair()" class="item">
                    <div class="in">
                        <div>Deslogar</div>
                    </div>
                </a>
            </li>
        </ul>
    </div>
    @include('app.menu')
    <form action="{{ route('logout') }}" id="sair" method="post">@csrf</form>

@endsection
@push('js')
    <script src="{{ url('admin') }}/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
    <script src="{{ url('admin') }}/js/plugins-init/sweetalert.init.js"></script>
    <script>
        function Sair() {
             swal("Aguarde...", "Você será direcionado...", "success");
                document.getElementById("sair").submit();
        }
    </script>
@endpush
