<div class="appBottomMenu">
    <a href="{{ route('app.home') }}" class="item {{ Route::is('app.home') ? 'active' : '' }}">
        <div class="col">
            <ion-icon name="home-outline"></ion-icon>
            <strong>Home</strong>
        </div>
    </a>
    <a href="javascript:void(0)" class="item" data-bs-toggle="modal" data-bs-target="#InvestirStore">
        <div class="col">
            <ion-icon name="cash-outline"></ion-icon>
            <strong>Investir</strong>
        </div>
    </a>
    <a href="{{ route('investimentos') }}" class="item {{ Route::is('investimentos') ? 'active' : '' }}">
        <div class="col">
            <ion-icon name="diamond-outline"></ion-icon>
            <strong>Investimentos</strong>
        </div>
    </a>
    <a href="{{ route('extrato') }}" class="item {{ Route::is('extrato') ? 'active' : '' }}">
        <div class="col">
            <ion-icon name="swap-vertical-outline"></ion-icon>
            <strong>Extrato</strong>
        </div>
    </a>
    <a href="{{ route('app.perfil') }}" class="item {{ Route::is('perfil') ? 'active' : '' }}">
        <div class="col">
            <ion-icon name="person-outline"></ion-icon>
            <strong>Perfil</strong>
        </div>
    </a>
</div>


<!-- Deposit Action Sheet -->
<div class="modal fade action-sheet" id="InvestirStore" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Investimentos</h5>
            </div>
            <div class="modal-body">
                <div class="action-sheet-content">
                    <form action="{{ route('deposito.store') }}" method="post" id="formDeposito">
                        @csrf
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="pacote_id">Selecione um pacote</label>
                                <select class="form-control custom-select" id="pacote_id" name="pacote_id">
                                    @foreach ($pacotes as $pacote)
                                        <option value="{{ $pacote->id }}">R$ {{ moeda($pacote->valor) }}, rende
                                            {{ moeda(porcentagem($pacote->rendimento, $pacote->valor)) }} em
                                            {{ $pacote->dias }} dias</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <button type="submit" class="btn btn-primary btn-block btn-lg"
                                id="btnDepositar">Depositar</button>
                        </div>

                        <div class="form-group basic" id="spinnerWrapper" style="display: none;">
                            <button type="button" class="btn btn-primary btn-block btn-lg" disabled>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                Processando...
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- * Deposit Action Sheet -->

<!-- Send Action Sheet -->
<div class="modal fade action-sheet" id="SolicitarSaque" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Solicitar Saque</h5>
            </div>
            <div class="modal-body">
                <div class="action-sheet-content">
                    <div class="alert alert-danger mb-1" role="alert">
                        Por segurança, os saques só serão realizados para contas bancárias de mesma titularidade.
                    </div>
                    <form>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="tipo_chave">Tipo de Chave</label>
                                <select class="form-control custom-select" id="tipo_chave">
                                    <option value="CPF">CPF</option>
                                    <option value="E-mail">E-mail</option>
                                    <option value="Celular">Celular</option>
                                    <option value="Chave Aleatória">Chave Aleatória</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="pix">Chave</label>
                                <input type="text" class="form-control" id="pix">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <label class="label">Valor</label>
                            <div class="input-group mb-2">
                                <span class="input-group-text">R$</span>
                                <input type="tel" class="form-control preco" id="valor_input"
                                    value="{{ moeda(Auth::user()->saldo) }}">
                            </div>
                        </div>

                        <div class="form-group basic" id="BotaoSaqueStore">
                            <button type="button" onclick="SaqueStore()"
                                class="btn btn-primary btn-block btn-lg">Solicitar</button>
                        </div>

                        <div class="form-group basic d-none" id="BotaoSaqueStoreDisabled">
                            <button type="button" class="btn btn-primary btn-block btn-lg" disabled>
                                <span class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                Processando...
                            </button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- * Send Action Sheet -->

@push('js')
    <script>
        const inputsValores = document.querySelectorAll('.preco');
        inputsValores.forEach(function(inputValor) {
            inputValor.addEventListener('input', function(event) {
                // Pega o valor do input e remove tudo que não é número
                let valor = inputValor.value.replace(/\D/g, '');

                // Formata o valor como dinheiro
                if (valor) {
                    valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                        style: 'currency',
                        currency: 'BRL'
                    });
                } else {
                    valor = '';
                }

                // Atualiza o valor no input
                inputValor.value = valor;
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('formDeposito');
            const btnDepositar = document.getElementById('btnDepositar');
            const spinnerWrapper = document.getElementById('spinnerWrapper');

            form.addEventListener('submit', function() {
                btnDepositar.style.display = 'none'; // esconde botão principal
                spinnerWrapper.style.display = 'block'; // mostra botão com loading
            });


        });


        function SaqueStore() {
            $("#BotaoSaqueStore").addClass('d-none');
            $("#BotaoSaqueStoreDisabled").removeClass('d-none');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('saque.store') }}",
                method: 'POST',
                data: {
                    tipo_chave: $("#tipo_chave").val(),
                    pix: $("#pix").val(),
                    valor: $("#valor_input").val(),
                },
                success: function(result) {
                    $("#BotaoSaqueStore").removeClass('d-none');
                    $("#BotaoSaqueStoreDisabled").addClass('d-none');
                    $("#SolicitarSaque").modal('hide');

                    // Define texto do toast dinamicamente
                    if (result.status === true || result.success === 'success') {
                        $("#toast-success .text").text(result.text);
                        toastbox('toast-success', 3000);
                    } else {
                        $("#toast-error .text").text(result.text || "Ocorreu um erro.");
                        toastbox('toast-error', 3000);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao processar saque:', error);
                    $("#toast-error .text").text("Erro interno no servidor.");
                    toastbox('toast-error', 3000);
                    $("#BotaoSaqueStore").removeClass('d-none');
                    $("#BotaoSaqueStoreDisabled").addClass('d-none');
                }
            });
        }
    </script>
@endpush
