@extends('app.base')
@section('content')
    <!-- loader -->
    <div id="loader">
        <img src="{{ url('app') }}/assets/img/loading-icon.png" alt="icon" class="loading-icon">
    </div>
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="{{ route('perfil') }}" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                @if (!empty(Auth::user()->foto))
                    <img src="assets/img/sample/avatar/avatar1.jpg" alt="image" class="imaged rounded w32">
                @else
                    <img src="{{ url('app') }}/assets/img/account.png" alt="image" class="imaged rounded w32">
                @endif
            </a>
        </div>
        <div class="pageTitle">
            Meus Investimentos
        </div>
        {{-- <div class="right">
            <a href="app-notifications.html" class="headerButton">
                <ion-icon class="icon md hydrated" name="notifications-outline" role="img"></ion-icon>
                <span class="badge badge-danger">8</span>
            </a>
        </div> --}}
    </div>

    <!-- App Capsule -->
    <div id="appCapsule">


        <!-- Wallet -->
        <div class="section full gradientSection">
            <div class="in">
                <h5 class="title mb-2">Total Investido</h5>
                <h1 class="total">R$
                    {{ moeda(Auth::user()->Investimentos->where('status', 'Ativo')->sum('investimento')) }}</h1>
                <h4 class="caption">
                    <span
                        class="iconbox text-{{ Auth::user()->Extrato->where('tipo', 'rendimento')->sum('valor') > Auth::user()->Investimentos->where('status', 'Ativo')->sum('investimento') ? 'success' : 'danger' }}">
                        <ion-icon
                            name="trending-{{ Auth::user()->Extrato->where('tipo', 'rendimento')->sum('valor') > Auth::user()->Investimentos->where('status', 'Ativo')->sum('investimento') ? 'up' : 'down' }}-outline"></ion-icon>
                    </span>
                    R$ {{ moeda(Auth::user()->Extrato->where('tipo', 'rendimento')->sum('valor')) }}
                </h4>
                <div class="wallet-inline-button mt-5">
                    <a href="#" class="item" data-bs-toggle="modal" data-bs-target="#InvestirStore">
                        <div class="iconbox">
                            <ion-icon name="arrow-up-outline"></ion-icon>
                        </div>
                        <strong>Investir</strong>
                    </a>
                    <a href="#" class="item" data-bs-toggle="modal" data-bs-target="#SolicitarSaque">
                        <div class="iconbox">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                        </div>
                        <strong>Sacar</strong>
                    </a>
                    <a href="{{ route('extrato') }}" class="item">
                        <div class="iconbox">
                            <ion-icon name="swap-vertical-outline"></ion-icon>
                        </div>
                        <strong>Extrato</strong>
                    </a>
                </div>
            </div>
        </div>
        <!-- * Wallet -->

        <!-- Portfolio -->
        <div class="section mt-4">
            <div class="section-heading">
                <h2 class="title">Meus Rendimentos</h2>
            </div>
            <div class="card">
                <ul class="listview flush transparent no-line image-listview detailed-list mt-1 mb-1">
                    @foreach (Auth::user()->Investimentos->where('status', 'Ativo') as $investimento)
                        @php
                            $valorInvestido = $investimento->investimento;
                            $valorPago = $investimento->Rendimentos->where('status', 'paga')->sum('valor');
                            $percentualRecuperado =
                                $valorInvestido > 0 ? round(($valorPago / $valorInvestido) * 100, 2) : 0;
                        @endphp

                        <li>
                            <div class="item">
                                <div class="icon-box text-success">
                                    <ion-icon name="trending-up-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    <div>
                                        <strong>{{ $investimento->Pacote->nome }}</strong>
                                        <div class="text-small text-secondary">R$ {{ moeda($valorInvestido) }}</div>
                                    </div>
                                    <div class="text-end">
                                        <strong>R$ {{ moeda($valorPago) }}</strong>
                                        <div class="text-small">
                                            <span class="badge badge-success">
                                                <ion-icon name="arrow-up-outline"></ion-icon>
                                                {{ $percentualRecuperado }}%
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
        <!-- Portfolio -->
    </div>
    <!-- * App Capsule -->
    @include('app.menu')
@endsection
@section('js')
@endsection
