@extends('app.base')
@section('content')
    <!-- loader -->
    <div id="loader">
        <img src="{{ url('app') }}/assets/img/loading-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            {{-- <a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a> --}}
        </div>
        <div class="pageTitle">
            {{ env('EMPRESA') }}
        </div>
        <div class="right">
            <a href="https://chat.whatsapp.com/JLi511fak6T74Cq1dsY4SN" class="headerButton">
                <ion-icon class="icon" name="logo-whatsapp"></ion-icon>
            </a>
            <a href="{{ route('app.perfil') }}" class="headerButton">
                <ion-icon class="icon" name="person-circle-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">

        <!-- Wallet Card -->
        <div class="section wallet-card-section pt-1">
            <div class="wallet-card">
                <!-- Balance -->
                <div class="balance">
                    <div class="left">
                        <span class="title">Saldo</span>
                        <h1 class="total">R$ {{ moeda(Auth::user()->saldo) }}</h1>
                    </div>
                    <div class="right">
                        <a href="#" class="button" data-bs-toggle="modal" data-bs-target="#InvestirStore">
                            <ion-icon name="add-outline"></ion-icon>
                        </a>
                    </div>
                </div>
                <!-- * Balance -->
                <!-- Wallet Footer -->
                <div class="wallet-footer">
                    <div class="item">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#InvestirStore">
                            <div class="icon-wrapper bg-success">
                                <ion-icon name="cash-outline"></ion-icon>
                            </div>
                            <strong>Depósito</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#SolicitarSaque">
                            <div class="icon-wrapper bg-danger">
                                <ion-icon name="wallet-outline"></ion-icon>
                            </div>
                            <strong>Retirada</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="app-cards.html">
                            <div class="icon-wrapper bg-info">
                                <ion-icon name="diamond-outline"></ion-icon>
                            </div>
                            <strong>Investimentos</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="{{ route('extrato') }}">
                            <div class="icon-wrapper bg-warning">
                                <ion-icon name="swap-vertical"></ion-icon>
                            </div>
                            <strong>Extrato</strong>
                        </a>
                    </div>
                </div>
                <!-- * Wallet Footer -->
            </div>
        </div>
        <!-- Wallet Card -->

        <div class="section mt-2" style="margin-bottom: 100px;">
            <div class="section-heading">
                <h2 class="title">Seu Hot Link</h2>
            </div>
            <div class="form-group boxed">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="hotlink"
                        value="https://sttrading.site/register/{{ Auth::user()->id }}">
                </div>
            </div>
        </div>

        <!-- Withdraw Action Sheet -->
        <div class="modal fade action-sheet" id="withdrawActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Withdraw Money</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">
                            <form>
                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="account2d">From</label>
                                        <select class="form-control custom-select" id="account2d">
                                            <option value="0">Savings (*** 5019)</option>
                                            <option value="1">Investment (*** 6212)</option>
                                            <option value="2">Mortgage (*** 5021)</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="text11d">To</label>
                                        <input type="email" class="form-control" id="text11d" placeholder="Enter IBAN">
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount</label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addonb1">$</span>
                                        <input type="text" class="form-control" placeholder="Enter an amount"
                                            value="100">
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <button type="button" class="btn btn-primary btn-block btn-lg"
                                        data-bs-dismiss="modal">Withdraw</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Withdraw Action Sheet -->



        <!-- Stats -->
        <div class="section">
            <div class="row mt-2">
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Depósitos</div>
                        <div class="value text-success">R$
                            {{ moeda(Auth::user()->Extrato->where('tipo', 'entrada')->sum('valor')) }}</div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Saques</div>
                        <div class="value text-danger">R$
                            {{ moeda(Auth::user()->Extrato->where('tipo', 'saque')->sum('valor')) }}</div>
                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Total Investido</div>
                        <div class="value">R$
                            {{ moeda(Auth::user()->Investimentos->where('status', 'Ativo')->sum('investimento')) }}
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Rendimentos</div>
                        <div class="value">R$
                            {{ moeda(Auth::user()->Extrato->where('tipo', 'rendimento')->sum('valor')) }}</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Stats -->

        <div class="section mt-2">
            <div class="section-title">Últimas Transações</div>
            <div class="card">
                <ul class="listview flush transparent no-line image-listview detailed-list mt-1 mb-1">
                    @foreach (Auth::user()->Extrato as $item)
                        <li>
                            <a href="#" class="item">
                                <div class="icon-box bg-{{ $color_extrato[$item->tipo] }}">
                                    <ion-icon name="{{ $ico_extrato[$item->tipo] }}"></ion-icon>
                                </div>
                                <div class="in">
                                    <div>
                                        <strong>{{ $item->ref }}</strong>
                                        <div class="text-small text-secondary">{{ $item->tipo }}</div>
                                    </div>
                                    <div class="text-end">
                                        <strong>R$ {{ moeda($item->valor) }}</strong>
                                        <div class="text-small">
                                            {{ CountTime($item->created_at) }}
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach

                    {{-- <!-- Compra de Produto -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-danger">
                                <ion-icon name="cart-outline"></ion-icon>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>Compra de Produto</strong>
                                    <div class="text-small text-secondary">Loja Virtual</div>
                                </div>
                                <div class="text-end">
                                    <strong>R$ 259,90</strong>
                                    <div class="text-small">
                                        08 de Maio, 2025
                                    </div>
                                </div>
                            </div>
                        </a>
                    </li>

                    <!-- Rendimento -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-primary">
                                <ion-icon name="trending-up-outline"></ion-icon>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>Rendimento</strong>
                                    <div class="text-small text-secondary">Operações da semana</div>
                                </div>
                                <div class="text-end">
                                    <strong>R$ 375,00</strong>
                                    <div class="text-small">
                                        05 de Maio, 2025
                                    </div>
                                </div>
                            </div>
                        </a>
                    </li>

                    <!-- Saque -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-warning">
                                <ion-icon name="cash-outline"></ion-icon>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>Saque</strong>
                                    <div class="text-small text-secondary">Conta Bradesco</div>
                                </div>
                                <div class="text-end">
                                    <strong>R$ 600,00</strong>
                                    <div class="text-small">
                                        02 de Maio, 2025
                                    </div>
                                </div>
                            </div>
                        </a>
                    </li> --}}

                </ul>
            </div>
        </div>

        <!-- Saving Goals -->
        <div class="section mt-4 mb-5">
            <div class="section-heading">
                <h2 class="title">Meus Investimentos</h2>
                <a href="app-savings.html" class="link">Ver tudo</a>
            </div>
            <div class="goals">
                @foreach (Auth::user()->Investimentos->where('status', 'Ativo') as $investimento)
                    @php
                        $total = $investimento->Rendimentos->count();
                        $pagos = $investimento->Rendimentos->where('status', 'paga')->count();
                        $percentual = $total > 0 ? round(($pagos / $total) * 100) : 0;
                    @endphp
                    <div class="item">
                        <div class="in">
                            <div>
                                <h4>{{ $investimento->Pacote->nome }}</h4>
                                <p>{{ $pagos }}/{{ $total }} pagos</p>
                            </div>
                            <div class="price">R$ {{ moeda($investimento->investimento * 2) }}</div>
                        </div>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" style="width: {{ $percentual }}%;"
                                aria-valuenow="{{ $percentual }}" aria-valuemin="0" aria-valuemax="100">
                                {{ $percentual }}%
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <!-- * Saving Goals -->


        <!-- app footer -->
        <div class="appFooter">
            <div class="footer-title">
                Copyright © {{ env('EMPRESA') }} {{ date('Y') }}. Todos os direitos reservados.
            </div>
            Lopak Tecnologia
        </div>
        <!-- * app footer -->

    </div>
    <!-- * App Capsule -->


    <!-- App Bottom Menu -->
    @include('app.menu')
    <!-- * App Bottom Menu -->

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <!-- profile box -->
                    <div class="profileBox pt-2 pb-2">
                        <div class="image-wrapper">
                            <img src="{{ url('site') }}/assets/img/sample/avatar/avatar1.jpg" alt="image"
                                class="imaged  w36">
                        </div>
                        <div class="in">
                            <strong>Sebastian Doe</strong>
                            <div class="text-muted">4029209</div>
                        </div>
                        <a href="#" class="btn btn-link btn-icon sidebar-close" data-bs-dismiss="modal">
                            <ion-icon name="close-outline"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->
                    <!-- balance -->
                    <div class="sidebar-balance">
                        <div class="listview-title">Balance</div>
                        <div class="in">
                            <h1 class="amount">$ 2,562.50</h1>
                        </div>
                    </div>
                    <!-- * balance -->

                    <!-- action group -->
                    <div class="action-group">
                        <a href="index.html" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="add-outline"></ion-icon>
                                </div>
                                Deposit
                            </div>
                        </a>
                        <a href="index.html" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="arrow-down-outline"></ion-icon>
                                </div>
                                Withdraw
                            </div>
                        </a>
                        <a href="index.html" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="arrow-forward-outline"></ion-icon>
                                </div>
                                Send
                            </div>
                        </a>
                        <a href="app-cards.html" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="card-outline"></ion-icon>
                                </div>
                                My Cards
                            </div>
                        </a>
                    </div>
                    <!-- * action group -->

                    <!-- menu -->
                    <div class="listview-title mt-1">Menu</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="index.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="pie-chart-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Overview
                                    <span class="badge badge-primary">10</span>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="app-pages.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="document-text-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Pages
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="app-components.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="apps-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Components
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="app-cards.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="card-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    My Cards
                                </div>
                            </a>
                        </li>
                    </ul>
                    <!-- * menu -->

                    <!-- others -->
                    <div class="listview-title mt-1">Others</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="app-settings.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="settings-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Settings
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="component-messages.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="chatbubble-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Support
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="app-login.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="log-out-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Log out
                                </div>
                            </a>
                        </li>


                    </ul>
                    <!-- * others -->

                    <!-- send money -->
                    <div class="listview-title mt-1">Solicitar Saque</div>
                    <ul class="listview image-listview flush transparent no-line">
                        <li>
                            <a href="#" class="item">
                                <img src="{{ url('site') }}/assets/img/sample/avatar/avatar2.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Artem Sazonov</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="item">
                                <img src="{{ url('site') }}/assets/img/sample/avatar/avatar4.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Sophie Asveld</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="item">
                                <img src="{{ url('site') }}/assets/img/sample/avatar/avatar3.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Kobus van de Vegte</div>
                                </div>
                            </a>
                        </li>
                    </ul>
                    <!-- * send money -->

                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->



    <div id="toast-success" class="toast-box toast-top bg-success">
        <div class="in">
            <div class="text">
                Operação realizada com sucesso!
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>

    <div id="toast-error" class="toast-box toast-top bg-danger">
        <div class="in">
            <div class="text">
                Operação realizada com sucesso!
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
@endsection
@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var hotlinkInput = document.getElementById('hotlink');
            hotlinkInput.addEventListener('click', function() {
                this.select();
                document.execCommand('copy');
                window.getSelection().removeAllRanges();

                // Exibir toast de sucesso (você já tem um `#toast-success`)
                const toast = document.getElementById('toast-success');
                if (toast) {
                    toast.querySelector('.text').textContent = 'Link copiado com sucesso!';
                    toastbox('toast-success', 3000);
                }
            });
        });
    </script>
@endpush
