@extends('app.base')
@section('content')
    <!-- loader -->
    <div id="loader">
        <img src="{{ url('app') }}/assets/img/loading-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Extrato
        </div>

    </div>
    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2">
            <div class="section-title">Esta Semana</div>
            <div class="card">
                <ul class="listview flush transparent no-line image-listview detailed-list mt-1 mb-1">
                    @foreach ($extratos as $extrato)
                        <li>
                            <a href="#" class="item">
                                <div class="icon-box bg-{{ $color_extrato[$extrato->tipo] }}">
                                    <ion-icon name="{{ $ico_extrato[$extrato->tipo] }}"></ion-icon>
                                </div>
                                <div class="in">
                                    <div>
                                        <strong>{{ ucfirst($extrato->ref) }}</strong>
                                        <div class="text-small text-secondary">{{ ucfirst($extrato->tipo) }}</div>
                                    </div>
                                    <div class="text-end">
                                        <strong>R$ {{ moeda($extrato->valor) }}</strong>
                                        <div class="text-small">
                                            {{ \Carbon\Carbon::parse($extrato->created_at)->translatedFormat('l, d \d\e F \d\e Y') }}
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
    @include('app.menu')
@endsection
@section('js')
@endsection
