@extends('app.base')
@section('content')
    <!-- loader -->
    <div id="loader">
        <img src="{{ url('app') }}/assets/img/loading-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Editar meus dados
        </div>

    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">
        <div class="section mt-2 mb-2">
            <div class="card">
                <div class="card-body">
                    <form id="formPerfilUpdate">
                        @csrf
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="name">Nome</label>
                                <input type="text" class="form-control" id="name" name="name"
                                    value="{{ Auth::user()->name }}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle" role="img" class="md hydrated"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email">E-mail</label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="{{ Auth::user()->email }}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle" role="img" class="md hydrated"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="cpf">CPF</label>
                                <input type="tel" class="form-control" id="cpf" name="cpf" oninput="mascaraCPF(this)"
                                    value="{{ Auth::user()->cpf }}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle" role="img" class="md hydrated"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="celular">Celular</label>
                                <input type="tel" class="form-control" id="celular" name="celular" oninput="mascaraCelular(this)"
                                    value="{{ Auth::user()->celular }}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle" role="img" class="md hydrated"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic" id="Atualizar">
                            <button type="button" onclick="UpdatePerfil()"
                                class="btn btn-primary btn-block btn-lg">Atualizar</button>
                        </div>

                        <div class="form-group basic d-none" id="ProcessarUpdate">
                            <button type="button" class="btn btn-primary btn-block btn-lg" disabled>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                Processando...
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
    @include('app.menu')
    <!-- Toast de sucesso -->
    <div id="toast-success" class="toast-box toast-top bg-success">
        <div class="in">
            <div class="text">Atualizado com sucesso!</div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>

    <!-- Toast de erro -->
    <div id="toast-error" class="toast-box toast-top bg-danger">
        <div class="in">
            <div class="text">Erro ao atualizar.</div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        function mascaraCPF(input) {
            let value = input.value.replace(/\D/g, '');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            input.value = value;
        }

        function mascaraCelular(input) {
            let value = input.value.replace(/\D/g, '');
            value = value.replace(/^(\d{2})(\d)/g, '($1) $2');
            value = value.replace(/(\d{5})(\d{1,4})$/, '$1-$2');
            input.value = value;
        }

        $(document).ready(function() {
            $('#cpf').mask('000.000.000-00');
            $('#celular').mask('(00) 00000-0000');
        });

        function UpdatePerfil() {
            $("#Atualizar").addClass('d-none');
            $("#ProcessarUpdate").removeClass('d-none');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('perfil.update') }}",
                method: 'POST',
                data: {
                    name: $("#name").val(),
                    email: $("#email").val(),
                    cpf: $("#cpf").val(),
                    celular: $("#celular").val(),
                },
                success: function(result) {
                    $("#Atualizar").removeClass('d-none');
                    $("#ProcessarUpdate").addClass('d-none');

                    // Define texto do toast dinamicamente
                    if (result.status === true || result.success === 'success') {
                        $("#toast-success .text").text(result.text);
                        toastbox('toast-success', 3000);
                    } else {
                        $("#toast-error .text").text(result.text || "Ocorreu um erro.");
                        toastbox('toast-error', 3000);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao processar saque:', error);
                    $("#toast-error .text").text("Erro interno no servidor.");
                    toastbox('toast-error', 3000);
                    $("#Atualizar").removeClass('d-none');
                    $("#ProcessarUpdate").addClass('d-none');
                }
            });
        }
    </script>
@endsection
