@extends('admin.base.base')
@section('titulo', 'Relatório de Vendas por Tipo de Ingresso - ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <form action="#" method="post">
                        @csrf
                        <input type="hidden" name="tipo" value="nfe">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="box-title">Relatório de Vendas por Tipo de Ingresso</h4>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label">Início</label>
                                            <input type="date" id="inicio" name="inicio" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label">Fim</label>
                                            <input type="date" id="fim" name="fim" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label">Tipos de ingressos</label>
                                            <select class="form-select" id="tipo_ingresso" name="tipo_ingresso">
                                                <option value="">Todos</option>
                                                <option value="Pagos">Pagos</option>
                                                <option value="Gratuitos">Gratuitos</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label">Formas de Pagamento</label>
                                            <select class="form-select" id="forma_pagamento" name="forma_pagamento">
                                                <option value="">Todas</option>
                                                <option value="PIX">PIX</option>
                                                <option value="CC">CC</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="box-footer text-end">
                                    <button type="button" class="btn btn-warning me-1 btn-sm" id="btn-limpar">
                                        <i class="ti-trash"></i> Limpar filtro
                                    </button>
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="ti-save-alt"></i> Filtrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th class="sorting">Tipo de ingresso</th>
                                                <th class="sorting">Quantidade</th>
                                            </tr>
                                        </thead>
                                        <tbody id="pedidos-list">
                                            @php $totalVendidosPacotes = 0; @endphp

                                            @forelse ($Evento->Pacotes as $pacote)
                                                @php
                                                    $porPacote = max(1, (int) $pacote->qtd_ingressos); // ingressos que formam 1 pacote
                                                    $ingressosVendidos = (int) $pacote->ingressos_vendidos_count;

                                                    // vendidos em unidades de pacote (inteiro)
                                                    $vendidosPacotes = intdiv($ingressosVendidos, $porPacote);

                                                    // Se preferir proporcional com casas decimais, use:
                                                    // $vendidosPacotes = $ingressosVendidos / $porPacote;

                                                    $totalVendidosPacotes += $vendidosPacotes;
                                                @endphp
                                                <tr role="row" class="odd" style="cursor:pointer">
                                                    <td>{{ $pacote->nome }}</td>
                                                    <td>{{ $vendidosPacotes }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="2">Nenhum pacote com vendas.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td>Total</td>
                                                <td>{{ $totalVendidosPacotes }}</td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')

@endsection
