@extends('admin.base.base')
@section('titulo', 'Histórico de Transações')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="row p-10">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">ID, Payment ID, Cliente, CPF, Email</label>
                                        <input type="text" id="s" class="form-control" placeholder="ID, Payment ID, Cliente, CPF, Email">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Inicio</label>
                                        <input type="date" id="inicio" class="form-control" placeholder="Inicio">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Fim</label>
                                        <input type="date" id="fim" class="form-control" placeholder="Fim">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <button onclick="javascript:Filtrar()" type="button" class="btn btn-primary btn-sm" style="margin-top: 30px">
                                        <i class="ti-save-alt"></i> Filtrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table id="example" class="table table-center table-hover datatable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>ID</th>
                                                <th>Cliente</th>
                                                <th>Payment ID</th>
                                                <th>Pedido</th>
                                                <th>Status</th>
                                                <th>Valor</th>
                                                <th class="text-end"></th>
                                            </tr>
                                        </thead>
                                        <tr id="progress" class="d-none">
                                            <td colspan="6">
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-success progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0"
                                                        aria-valuemax="100" style="width: 100%">
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tbody id="result_pagamentos">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')
<script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>
    <script>
        let loadingInterval = null;

        function Filtrar() {
            let $progress = $("#progress");
            let $progressBar = $progress.find('.progress-bar');

            // Garante que a barra reinicie do zero e que animações antigas sejam canceladas
            clearInterval(loadingInterval);
            $progress.removeClass('d-none');
            $progressBar.css('width', '0%').attr('aria-valuenow', 0);

            let percentage = 0;
            loadingInterval = setInterval(() => {
                percentage += Math.floor(Math.random() * 10) + 5; // 5~15% por incremento
                if (percentage >= 90) {
                    clearInterval(loadingInterval);
                } else {
                    $progressBar.css('width', percentage + '%').attr('aria-valuenow', percentage);
                }
            }, 200);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('filtrar.pagamentos') }}",
                method: 'POST',
                data: {
                    inicio: $("#inicio").val(),
                    fim: $("#fim").val(),
                    s: $("#s").val(),
                },
                success: function(result) {
                    clearInterval(loadingInterval);
                    $progressBar.css('width', '100%').attr('aria-valuenow', 100);
                    setTimeout(() => {
                        $progress.addClass('d-none');
                        $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                        $("#result_pagamentos").html(result);
                    }, 300);
                },
                error: function() {
                    clearInterval(loadingInterval);
                    $progress.addClass('d-none');
                    $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                    alert('Erro ao buscar pagamentos');
                }
            });
        }
    </script>

@endsection
