@extends('admin.base.base')
@section('titulo', 'Repasses ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-md-flex justify-content-between align-items-center">
                                    <div>
                                        <button data-bs-toggle="modal" data-bs-target="#modal-center" class="btn btn-danger btn-sm" type="button">Adicionar</button>
                                    </div>
                                </div>
                                <table id="ingressos" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting">Data</th>
                                            <th class="sorting">Valor</th>
                                            <th class="sorting">Obs</th>
                                            <th class="sorting">Comprovante</th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_ingressos">
                                        @foreach ($Evento->Repasses as $item)
                                            <tr>
                                                <td>{{ date('d/m/Y H:i', strtotime($item->created_at)) }}</td>
                                                <td>R$ {{ moeda($item->valor) }}</td>
                                                <td>{{ $item->observacoes }}</td>
                                                <td>
                                                    <a href="{{ $item->comprovante }}" target="_blank" class="btn btn-primary btn-sm" type="button">Abrir</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal center-modal fade" id="modal-center" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cancelar Pedido</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('repasse.store') }}" enctype="multipart/form-data" method="post">
                    @csrf
                    <input type="hidden" value="{{ $Evento->id }}" name="evento_id">
                    <input type="hidden" value="{{ $Evento->produtor_id }}" name="user_id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label">Observações</label>
                            <textarea rows="5" class="form-control" placeholder="Observações" name="observacoes"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label">valor</label>
                            <input type="text" name="valor" class="form-control preco" placeholder="R$">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Comprovante de Pagamento</label>
                            <label class="file">
                                <input type="file" id="comprovante_pagamento" name="comprovante_pagamento">
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">Fechar</button>
                        <button type="submit" class="btn btn-primary btn-sm float-end">Confirmar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('css')
    <style>

    </style>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/jquery.peity/jquery.peity.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/data-table.js"></script>
    <script src="{{ url('admin') }}/src/js/pages/app-ticket.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        const inputsValores = document.querySelectorAll('.preco');
        inputsValores.forEach(function(inputValor) {
            inputValor.addEventListener('input', function(event) {
                // Pega o valor do input e remove tudo que não é número
                let valor = inputValor.value.replace(/\D/g, '');

                // Formata o valor como dinheiro
                if (valor) {
                    valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                        style: 'currency',
                        currency: 'BRL'
                    });
                } else {
                    valor = '';
                }

                // Atualiza o valor no input
                inputValor.value = valor;
            });
        });
    </script>
@endsection
