@extends('admin.base.base')
@section('titulo', $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="invoice printableArea">
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex justify-content-between align-items-center bb-1 py-2">
                            <div class="text-start">
                                <a href="{{ route('historico.transacoes', $Evento) }}" class="btn btn-primary btn-sm">
                                    <span><i class="fa fa-print"></i> Histórico de Transações</span>
                                </a>
                            </div>
                            <div class="text-end">
                                @if ($Pedido->status == 'Cancelado' && !empty($Pedido->Cancelamento))
                                    <button class="btn btn-danger btn-sm" type="button">
                                        <span><i class="fa fa-times"></i> Venda Cancelada</span>
                                    </button>
                                    <a target="_blank" href="{{ url("storage/{$Pedido->Cancelamento->comprovante_pagamento}") }}" class="btn btn-info btn-sm" type="button">
                                        <span><i class="fa fa-times"></i> Comprovante de Pagamento</span>
                                    </a>
                                    <a target="_blank" href="{{ url("storage/{$Pedido->Cancelamento->comprovante_estorno}") }}" class="btn btn-info btn-sm" type="button">
                                        <span><i class="fa fa-times"></i> Comprovante de Estorno</span>
                                    </a>
                                @else
                                    <button data-bs-toggle="modal" data-bs-target="#modal-center" class="btn btn-danger btn-sm" type="button">
                                        <span><i class="fa fa-times"></i> Cancelar</span>
                                    </button>
                                @endif


                                @if ($Pedido->status == 'Pendente' || $Pedido->status == 'Cancelado')
                                    <button onclick="javascript:Aprovar({{ $Pedido->id }})" class="btn btn-success btn-sm" type="button">
                                        <span><i class="fa fa-times"></i> Aprovar Pedido</span>
                                    </button>
                                @endif

                                <a href="{{ route('print.carteira', $Pedido) }}" class="btn btn-success btn-sm" target="_blank">
                                    <span><i class="fa fa-print"></i> Carteira</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="page-header">
                            <h2 class="d-inline"><span class="fs-25">Transação Nº {{ $Pedido->id }}</span></h2>
                            <div class="pull-right text-end">
                                <h3>{{ date('d/m/Y', strtotime($Pedido->created_at)) }} às {{ date('H:i', strtotime($Pedido->created_at)) }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row invoice-info">
                    <div class="col-md-6 invoice-col">
                        <strong>Cliente</strong>
                        <address>
                            <strong class="text-blue fs-18">{{ $Pedido->Cliente->name }} {{ $Pedido->Cliente->sobrenome }}</strong><br>
                            <strong class="d-inline">{{ $Pedido->Cliente->cpf }}</strong><br>
                            <strong>{{ $Pedido->Cliente->celular }} </strong>
                            <strong>{{ $Pedido->Cliente->email }}</strong>
                        </address>
                    </div>
                    <!-- /.col -->
                    <div class="col-md-6 invoice-col text-end">
                        <strong>Pedido</strong>
                        <address>
                            <strong class="text-blue fs-24">{{ $Pedido->registro }}</strong><br>
                            <span class="badge badge-pill badge-{{ $status_pagamento[$Pedido->status] }}">{{ $Pedido->status }}</span>
                        </address>
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-12 invoice-col mb-15">
                        <div class="invoice-details row no-margin">
                            <div class="col-md-6 col-lg-2"><b>Pagmento </b>#{{ $Pedido->Boleto->id }}</div>
                            <div class="col-md-6 col-lg-2"><b>Payment ID:</b> {{ $Pedido->Boleto->payment_id }}</div>
                            <div class="col-md-6 col-lg-2"><b>Vencimento:</b> {{ date('d/m/Y', strtotime($Pedido->Boleto->vencimento)) }}</div>
                            <div class="col-md-6 col-lg-2"><b>Data Pago:</b> {{ date('d/m/Y', strtotime($Pedido->Boleto->data_pago)) }}</div>
                            <div class="col-md-6 col-lg-2"><b>Status:</b> {{ $status_boleto[$Pedido->Boleto->status] }}</div>
                        </div>
                    </div>
                    <!-- /.col -->
                </div>
                <div class="row">
                    <div class="col-12 table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th>#</th>
                                    <th>Estudante</th>
                                    <th>Tipo</th>
                                    <th class="text-end">Valor</th>
                                    <th class="text-end">Taxa</th>
                                    <th class="text-end">Total</th>
                                </tr>
                                @foreach ($Pedido->Ingressos as $ingresso)
                                    <tr>
                                        <td>{{ $ingresso->id }}</td>
                                        <td>
                                            {{ $ingresso->nome_completo }}<br>
                                            {{ $ingresso->email }} <br>
                                            {{ $ingresso->instituicao_ensino }} <br>
                                            {{ $ingresso->curso }} <br>
                                            {{ $ingresso->matricula }}

                                        </td>
                                        <td>{{ $ingresso->Pacote->nome }}</td>
                                        <td class="text-end">R$ {{ moeda($ingresso->preco) }}</td>
                                        <td class="text-end">R$ {{ moeda($ingresso->taxa) }}</td>
                                        <td class="text-end">R$ {{ moeda($ingresso->preco + $ingresso->taxa) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.col -->
                </div>
                <div class="row">
                    <div class="col-12 text-end">
                        <div>
                            <p>Sub - Total: R$ {{ moeda($Pedido->sub_total) }}</p>
                            <p>Tax ({{ env('TAXA') }}%) : R$ {{ moeda($Pedido->taxa) }}</p>
                            <p>Forma Pagamento: {{ $Pedido->forma_pagamento }}</p>
                        </div>
                        <div class="total-payment">
                            <h3><b>Total :</b>R$ {{ moeda($Pedido->total) }}</h3>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>


    <div class="modal center-modal fade" id="modal-center" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cancelar Pedido</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('pedido.cancelamento', $Pedido->id) }}" enctype="multipart/form-data" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label">Motivo</label>
                            <textarea rows="5" class="form-control" placeholder="Motivo" name="motivo"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Comprovante de Pagamento</label>
                            <label class="file">
                                <input type="file" id="comprovante_pagamento" name="comprovante_pagamento">
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Comprovante de Estorno</label>
                            <label class="file">
                                <input type="file" id="comprovante_estorno" name="comprovante_estorno">
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">Fechar</button>
                        <button type="submit" class="btn btn-primary btn-sm float-end">Confirmar e Cancelar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('css')

@endsection
@section('js')
    <script>
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif

        function Aprovar(id) {
            swal({
                title: "Atenção",
                text: "Confirma o recebimento do pedido?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('aprovar.pedido') }}",
                        method: 'POST',
                        data: {
                            id: id
                        },
                        success: function(result) {
                            swal("Sucesso", "Pagamento atualizado", "success");
                            setTimeout(() => {
                                location.reload(true);
                            }, 1000);
                        },
                        error: function(xhr, status, error) {
                            console.error("Erro na requisição:", error);
                            swal("Ops!!!", "Não foi possível atualizar o status. Tente novamente.", "error");
                        }
                    });

                } else {
                    swal("Cancelado", "Nenhuma ação foi executada", "error");
                }
            });


        }
    </script>
@endsection
