@extends('admin.base.base')
@section('titulo', 'Nova Carteira')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-12">
                        {{-- ⚠️ ADICIONAR O CAMPO HIDDEN AQUI --}}
                        <form id="CarteiraStore" action="{{ route('carteira.store') }}" method="post" enctype="multipart/form-data">
                            @csrf

                            {{-- NOVO CAMPO HIDDEN PARA O DADO BASE64 CORTADO --}}
                            {{-- <input type="hidden" name="cropped_image_data" id="cropped_image_data"> --}}

                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-user"></i> Dados da carteira</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-12">
                                                <label class="form-label" for="imageInput">
                                                    <img id="imagePreview" src="{{ url('site/images/sem-foto.jpeg') }}" data-bs-toggle="modal" data-bs-target="#modal-center" width="150" style="border-radius: 20px; cursor: pointer;">
                                                    <br>
                                                    Clique para anexar Foto, tamanho máximo 8Mb
                                                </label>
                                                {{-- O input file original pode continuar hidden, pois a imagem é enviada via Base64 --}}
                                                <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                                <br>
                                                <button id="modalShow" type="button" class="waves-effect waves-light btn btn-info btn-xs">
                                                    <i class="glyphicon glyphicon-upload"></i> Selecionar uma foto
                                                </button>
                                                <button type="button" class="waves-effect waves-light btn btn-info btn-xs" id="openCameraButton">
                                                    <i class="glyphicon glyphicon-camera"></i> Tire uma foto
                                                </button>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Tipo de Carteira</label>
                                                    <select class="form-select" name="pacote_id">
                                                        @foreach ($Evento->pacotes->sortByDesc('id') as $pacote)
                                                            <option value="{{ $pacote->id }}">
                                                                {{ $pacote->nome }} - R$ {{ moeda($pacote->preco) }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Forma de Pagamento</label>
                                                    <select class="form-select" name="forma_pagamento">
                                                        <option value="PIX">PIX</option>
                                                        <option value="Dinheiro">Dinheiro</option>
                                                        <option value="Link de Pagamento">Link de Pagamento</option>
                                                        <option value="Cortesia">Cortesia</option>
                                                        <option value="Cartão de Crédito">Cartão de Crédito</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nome Completo</label>
                                                    <input name="name" value="{{ old('name') }}" type="text" class="form-control" placeholder="Nome Completo">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">CPF</label>
                                                    <input id="cpf" name="cpf" value="{{ old('cpf') }}" type="tel" class="form-control" placeholder="CPF">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nível de Ensino</label>
                                                    <select class="form-select" name="nivel_ensino">
                                                        <option value="Fundamental">Fundamental</option>
                                                        <option value="Médio">Médio</option>
                                                        <option value="Superior">Superior</option>
                                                        <option value="Técnico">Técnico</option>
                                                        <option value="Pós Graduação">Pós Graduação</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">E-mail</label>
                                                    <input name="email" value="{{ old('email') }}" type="text" class="form-control" placeholder="E-mail">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Celular</label>
                                                    <input id="celular" name="celular" value="{{ old('celular') }}" type="text" class="form-control" placeholder="Celular">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Data de Nascimento</label>
                                                    <input id="nascimento" name="nascimento" value="{{ old('nascimento') }}" type="text" class="form-control" placeholder="Data de Nascimento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Instituição</label>
                                                    <input name="instituicao_ensino" value="{{ old('instituicao_ensino') }}" type="text" class="form-control" placeholder="Instituição">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Curso</label>
                                                    <input name="curso" value="{{ old('curso') }}" type="text" class="form-control" placeholder="Curso">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Ano</label>
                                                    <select class="form-select" name="vigencia">
                                                        <option value="2026">2026</option>
                                                        <option value="2025">2025</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Cód. de Uso</label>
                                                    <input name="cod_uso" value="{{ gerarlETRARegistro(6) }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary btn-sm" id="submitButton">
                                                    <i class="fa fa-check"></i> Publicar
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>

    {{-- MODAL PARA RECORTAR IMAGEM (CROPPING MODAL) --}}
    <div class="modal center-modal fade" id="modal-center" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Recortar Imagem</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div id="modalImage" style="max-width: 100%;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" id="cropButton" class="btn btn-primary">Cortar</button>
                </div>
            </div>
        </div>
    </div>

    {{-- MODAL PARA CAPTURAR FOTO (CAMERA MODAL) --}}
    <div class="modal center-modal fade" id="cameraModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Capturar Foto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" id="closeCamera"></button>
                </div>
                <div class="modal-body text-center">
                    <video id="cameraPreview" autoplay playsinline style="width: 100%; max-height: 400px;"></video>
                    <canvas id="capturedCanvas" style="display: none;"></canvas>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal" id="closeModalButton">Fechar</button>
                    <button type="button" id="captureButton" class="btn btn-primary">Capturar</button>
                </div>
            </div>
        </div>
    </div>
    <div id="loader"></div>
@endsection

@section('js')
    {{-- Seus imports de JS... --}}
    <script src="{{ url('assets/vendor_plugins/iCheck/icheck.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/formatter/formatter.js') }}"></script>
    <script src="{{ url('assets/vendor_components/formatter/jquery.formatter.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/formatter.js"></script>

    <script src="{{ url('assets/vendor_components/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/editor.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.6/jquery.inputmask.min.js"></script>

    <!-- CSS do Cropper -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" />
    <!-- JS do Cropper -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {

            /* ======================================================
             * SWEET ALERT
             * ====================================================== */
            @if (session('success'))
                swal("Sucesso", "{{ session('success') }}", "success");
            @endif

            @if ($errors->any())
                swal("Atenção!", "{{ $errors->first() }}", "error");
            @endif


            /* ======================================================
             * SUBMIT COM LOADING
             * ====================================================== */
            const form = document.getElementById("CarteiraStore");
            const submitButton = document.getElementById("submitButton");

            submitButton.addEventListener("click", function(e) {
                e.preventDefault();
                submitButton.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Processando...';
                submitButton.disabled = true;
                form.submit();
            });


            /* ======================================================
             * INPUT MASK
             * ====================================================== */
            $('#cpf').inputmask('999.999.999-99');
            $('#celular').inputmask('(99)99999-9999');
            $('#nascimento').inputmask('99/99/9999');


            /* ======================================================
             * VARIÁVEIS GERAIS
             * ====================================================== */
            let cropper = null;
            let cameraStream = null;

            const imageInput = document.getElementById('imageInput');
            const imagePreview = document.getElementById('imagePreview');
            const modalShow = document.getElementById('modalShow');
            const openCameraButton = document.getElementById('openCameraButton');
            const cropButton = document.getElementById('cropButton');
            const modalImage = document.getElementById('modalImage');
            const croppedImageDataInput = document.getElementById('cropped_image_data');

            const croppingModalElement = document.getElementById('modal-center');
            const cameraModalElement = document.getElementById('cameraModal');


            /* ======================================================
             * MODAIS (INSTÂNCIAS ÚNICAS)
             * ====================================================== */
            const croppingModal = new bootstrap.Modal(croppingModalElement, {
                backdrop: 'static',
                keyboard: false
            });

            const cameraModal = new bootstrap.Modal(cameraModalElement, {
                backdrop: 'static',
                keyboard: false
            });


            /* ======================================================
             * FUNÇÃO: INICIAR CROP
             * ====================================================== */
            function initCropper(imageSource) {
                modalImage.innerHTML = '';

                const img = document.createElement('img');
                img.src = imageSource;
                img.style.maxWidth = '100%';

                modalImage.appendChild(img);

                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }

                cropper = new Cropper(img, {
                    aspectRatio: 3 / 4,
                    viewMode: 2,
                    autoCropArea: 1
                });

                croppingModal.show();
            }


            /* ======================================================
             * SELECIONAR FOTO (UPLOAD)
             * ====================================================== */
            modalShow.addEventListener('click', () => imageInput.click());

            imageInput.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (!file) return;

                const reader = new FileReader();
                reader.onload = e => initCropper(e.target.result);
                reader.readAsDataURL(file);
            });


            /* ======================================================
             * CORTAR IMAGEM
             * ====================================================== */
            cropButton.addEventListener('click', function() {
                if (!cropper) return;

                const canvas = cropper.getCroppedCanvas({
                    width: 600,
                    height: 800
                });

                canvas.toBlob((blob) => {
                    const file = new File([blob], 'foto.jpg', {
                        type: 'image/jpeg'
                    });

                    const dataTransfer = new DataTransfer();
                    dataTransfer.items.add(file);

                    imageInput.files = dataTransfer.files;

                    imagePreview.src = URL.createObjectURL(file);

                    croppingModal.hide();
                }, 'image/jpeg', 0.9);


                imagePreview.src = base64;
                croppedImageDataInput.value = base64;

                croppingModal.hide();
            });


            /* ======================================================
             * LIMPEZA AO FECHAR MODAL DE CORTE
             * ====================================================== */
            $('#modal-center').on('hidden.bs.modal', function() {
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });


            /* ======================================================
             * ABRIR CÂMERA
             * ====================================================== */
            openCameraButton.addEventListener('click', function() {
                cameraModal.show();

                navigator.mediaDevices.getUserMedia({
                    video: {
                        facingMode: 'user'
                    }
                }).then(stream => {
                    cameraStream = stream;
                    const video = document.getElementById('cameraPreview');
                    video.srcObject = stream;
                    video.play();
                }).catch(err => {
                    alert('Erro ao acessar a câmera: ' + err.message);
                });
            });


            /* ======================================================
             * CAPTURAR FOTO DA CÂMERA
             * ====================================================== */
            document.getElementById('captureButton').addEventListener('click', function() {
                const video = document.getElementById('cameraPreview');
                const canvas = document.getElementById('capturedCanvas');
                const ctx = canvas.getContext('2d');

                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;
                ctx.drawImage(video, 0, 0);

                const imageData = canvas.toDataURL('image/jpeg', 0.9);

                stopCamera();
                cameraModal.hide();

                initCropper(imageData);
            });


            /* ======================================================
             * PARAR CÂMERA AO FECHAR MODAL
             * ====================================================== */
            function stopCamera() {
                if (cameraStream) {
                    cameraStream.getTracks().forEach(track => track.stop());
                    cameraStream = null;
                }
            }

            $('#cameraModal').on('hidden.bs.modal', function() {
                stopCamera();
            });


            /* ======================================================
             * GARANTIA ABSOLUTA: LIMPA BACKDROP
             * ====================================================== */
            $('.modal').on('hidden.bs.modal', function() {
                $('.modal-backdrop').remove();
                $('body').removeClass('modal-open');
                $('body').css('overflow', '');
            });

        });
    </script>

@endsection
