@extends('admin.base.base')
@section('titulo', 'Histórico de Transações - ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Hoje</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                {{ moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->isToday();
                                        })->sum('sub_total'),
                                ) }}
                            </p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Últimos 7 dias</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                {{ moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->greaterThanOrEqualTo(now()->subDays(7));
                                        })->sum('sub_total'),
                                ) }}
                            </p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-12">
                        <div class="box box-body">
                            <h6>
                                <span class="text-uppercase">Vendas Últimos 30 dias</span>
                            </h6>
                            <br>
                            <p class="fs-26">R$
                                {{ moeda(
                                    $Evento->Pedidos->where('status', 'Aprovado')->filter(function ($pedido) {
                                            return $pedido->created_at->greaterThanOrEqualTo(now()->subDays(30));
                                        })->sum('sub_total'),
                                ) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="form-group">
                                    <label class="form-label">Filtrar por tipo de transação</label>
                                    <select class="form-select" style="width: 350px;" id="filtrar">
                                        <option>Selecione</option>
                                        <option value="Aprovado">Pagamento Aprovado</option>
                                        <option value="Pendente">Pagamento Pendente</option>
                                        <option value="Cancelados">Pagamento Cancelados</option>
                                        <option value="Manual">Adicionados Manualmente</option>
                                        <option value="Site">PDV Musa</option>
                                    </select>
                                </div>
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th class="sorting">Nº DO PEDIDO</th>
                                                <th class="sorting">COMPRADOR</th>
                                                <th class="sorting">DATA DA VENDA</th>
                                                <th class="sorting">PREÇO DO PRODUTOR</th>
                                                <th class="sorting">PREÇO DA VENDA</th>
                                                <th class="sorting">TOTAL DA VENDA</th>
                                                <th class="sorting">STATUS</th>
                                            </tr>
                                        </thead>
                                        <tbody id="pedidos-list">
                                            @include('admin.evento.ajax.pedidos')
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td>Pagos {{ count($Evento->Pedidos->where('status', 'Aprovado')) }}</td>
                                                <td>
                                                    Pendentes {{ count($Evento->Pedidos->where('status', 'Pendente')) }} <br>
                                                    Cancelados {{ count($Evento->Pedidos->where('status', 'Cancelado')) }}
                                                </td>
                                                <td>Total</td>
                                                <td>R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('sub_total')) }}</td>
                                                <td>R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('taxa')) }}</td>
                                                <td>R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('total')) }}</td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                    <div id="loading" style="text-align: center; display: none;">
                                        <p>Carregando...</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')
    <script>
        let page = 1;
        let loading = false;
        let filtro = '';

        function loadMoreData(page) {
            loading = true;
            $("#loading").show();

            $.ajax({
                url: "{{ route('historico.transacoes', $Evento) }}",
                data: {
                    page: page,
                    filtro: filtro
                },
                type: "GET",
                success: function(data) {
                    if (data.trim() === "") {
                        $("#loading").html("<p>Não há mais registros.</p>");
                        return;
                    }

                    $("#pedidos-list").append(data);
                    $("#loading").hide();
                    loading = false;
                },
                error: function(xhr, status, error) {
                    console.error("Erro ao carregar mais dados: ", error);
                    $("#loading").hide();
                    loading = false;
                }
            });
        }

        $(window).scroll(function() {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 100 && !loading) {
                page++;
                loadMoreData(page);
            }
        });

        $(document).ready(function() {
            $("#filtrar").change(function() {
                filtro = $(this).val();
                page = 1;
                $("#pedidos-list").html(""); // Limpa a lista
                loadMoreData(page); // Recarrega com o filtro
            });
        });
    </script>

@endsection
