@extends('admin.base.base')
@section('titulo', 'E-mail Marketing')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-12">
                        <form action="{{ route('email.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="evento_id" value="{{ $Evento->id }}">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myLargeModalLabel">Escrever mensagem</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Destinatários</label>
                                            <select name="destinatarios" class="form-select" data-placeholder="Grupos" style="width: 100%;" tabindex="-1" aria-hidden="true">
                                                <option value="Clientes Musa">Clientes Musa</option>
                                                <option value="Meus Clientes">Meus Clientes</option>
                                                <option value="Compradores deste evento">Compradores deste evento</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <input name="assunto" id="assunto" class="form-control" placeholder="Assunto:">
                                    </div>
                                    <div class="form-group">
                                        <input name="link_final" class="form-control" value="{{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}">
                                    </div>
                                    <div class="form-group">
                                        <textarea name="msg" id="msg-editor" class="textarea" placeholder="Sua mensagem aqui" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                    </div>
                                    <div id="image-container">
                                        <!-- As imagens selecionadas serão exibidas aqui -->
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <div class="pull-right">
                                        <button type="submit" class="btn btn-success" id="EmailStore">
                                            <span class="indicator-resposta" id="indicator-email-store">
                                                <i class="fa fa-envelope-o"></i> Enviar
                                            </span>
                                            <span class="indicator-progress d-none" id="indicator-progress-email-store">
                                                Aguarde enviando... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                            </span>
                                        </button>
                                    </div>
                                    <button type="button" class="btn btn-danger text-start pull-left" data-bs-dismiss="modal">Fechar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-tagsinput/dist/bootstrap-tagsinput.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/select2/dist/js/select2.full.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_components/moment/min/moment.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/timepicker/bootstrap-timepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/iCheck/icheck.min.js') }}"></script>
    <script src="{{ url('admin/src/js/pages/advanced-form-element.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
    <script src="{{ url('admin/src/js/pages/mailbox.js') }}"></script>
    <script src="{{ url('admin/src/js/pages/form-compose.js') }}"></script>
    <script src="{{ url('assets/vendor_components/sweetalert/sweetalert.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js') }}"></script>

    <script>
        $(document).ready(function() {
            CKEDITOR.replace('msg-editor');
            $('.textarea').wysihtml5();

            document.getElementById('file-input').addEventListener('change', function(e) {
                const files = e.target.files;
                const container = document.getElementById('image-container');

                Array.from(files).forEach(file => {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        img.style = "width: 90px; height: 90px; object-fit: cover; object-position: center; margin:5px;";
                        container.appendChild(img);
                    };
                    reader.readAsDataURL(file);
                });
            });

            document.getElementById('image-container').addEventListener('click', function(e) {
                if (e.target.tagName === 'IMG') {
                    e.target.remove(); // Remove a imagem clicada
                }
            });
            $(document).ready(function() {
                $("#EmailStore").click(function() {
                    $("#indicator-email-store").addClass('d-none');
                    $("#indicator-progress-email-store").removeClass('d-none');
                });
                $("#refresh1").click(function() {
                    $("#indicator-refresh1").addClass('d-none');
                    $("#indicator-progress-refresh1").removeClass('d-none');
                    window.location.reload();
                });
                $("#refresh2").click(function() {
                    $("#indicator-refresh2").addClass('d-none');
                    $("#indicator-progress-refresh2").removeClass('d-none');
                    window.location.reload();
                });
            });
        });
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif
        @if (session('error'))
            swal(
                "Atenção",
                "{{ session('error') }}",
                "error"
            );
        @endif
    </script>

@endsection
