@extends('admin.base.base')
@section('titulo', 'Editar Carteira')

@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">

                @include('admin.evento.include.info')

                <div class="row">
                    <div class="col-12">

                        <form id="CarteiraStore" action="{{ route('carteira.update', $carteira->id) }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">

                                        <h4 class="box-title text-info mb-0">
                                            <i class="glyphicon glyphicon-user"></i> Dados da carteira
                                        </h4>

                                        <hr class="my-15">

                                        {{-- ID PEDIDO / PAYMENT --}}
                                        <div class="row mb-3">
                                            <div class="col-md-6">
                                                <strong>ID do Pedido:</strong> {{ $carteira->id }}
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Payment ID: </strong>
                                                {{ $carteira->Boleto->payment_id ?? '' }}
                                                <br>
                                                <div class="col-12 mt-3">
                                                    <a href="{{ route('print.carteira', $carteira) }}" target="_blank" class="btn btn-primary btn-sm">
                                                        <i class="fa fa-print"></i> Imprimir
                                                    </a>
                                                    <a href="{{ route('validar.carteira', $carteira->registro) }}" target="_blank" class="btn btn-success btn-sm">
                                                        <i class="fa fa-check"></i> Validar
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">

                                            {{-- FOTO --}}
                                            <div class="col-lg-12">
                                                <label for="imageInput">
                                                    <img id="imagePreview" src="{{ $ingresso->foto }}" width="150" style="border-radius:20px;cursor:pointer" data-bs-toggle="modal" data-bs-target="#modal-center">
                                                    <br> Clique para anexar Foto
                                                </label>

                                                <input type="file" name="image" id="imageInput" hidden accept="image/*">

                                                <br>
                                                <button type="button" id="modalShow" class="btn btn-info btn-xs">
                                                    Selecionar foto
                                                </button>
                                                <button type="button" id="openCameraButton" class="btn btn-info btn-xs">
                                                    Tirar foto
                                                </button>
                                            </div>

                                            {{-- PACOTE --}}
                                            <div class="col-lg-6">
                                                <label>Tipo de Carteira</label>
                                                <select name="pacote_id" class="form-select">
                                                    @foreach ($Evento->pacotes as $pacote)
                                                        <option value="{{ $pacote->id }}" {{ $ingresso->pacote_id == $pacote->id ? 'selected' : '' }}>
                                                            {{ $pacote->nome }} - R$ {{ moeda($pacote->preco) }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            {{-- PAGAMENTO --}}
                                            <div class="col-lg-6">
                                                <label>Forma de Pagamento</label>
                                                <select name="forma_pagamento" class="form-select">
                                                    @foreach (['PIX', 'Dinheiro', 'Link de Pagamento', 'Cortesia', 'Cartão de Crédito'] as $fp)
                                                        <option value="{{ $fp }}" {{ $carteira->forma_pagamento == $fp ? 'selected' : '' }}>
                                                            {{ $fp }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            {{-- NOME --}}
                                            <div class="col-lg-6">
                                                <label>Nome Completo</label>
                                                <input type="text" name="name" value="{{ $ingresso->nome_completo }}" class="form-control">
                                            </div>

                                            {{-- CPF --}}
                                            <div class="col-lg-6">
                                                <label>CPF</label>
                                                <input type="text" id="cpf" name="cpf" value="{{ $ingresso->cpf }}" class="form-control">
                                            </div>
                                            <div class="col-lg-6">
                                                <label>Data de Nascimento</label>
                                                <input id="nascimento" name="nascimento" value="{{ date('d/m/Y', strtotime($ingresso->nascimento)) }}" type="text" class="form-control" placeholder="Data de Nascimento">
                                            </div>

                                            {{-- NIVEL --}}
                                            <div class="col-lg-6">
                                                <label>Nível de Ensino</label>
                                                <select name="nivel_ensino" class="form-select">
                                                    @foreach (['Fundamental', 'Médio', 'Superior', 'Técnico', 'Pós Graduação'] as $nivel)
                                                        <option value="{{ $nivel }}" {{ ($ingresso->nivel_ensino ?? '') == $nivel ? 'selected' : '' }}>
                                                            {{ $nivel }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            {{-- EMAIL --}}
                                            <div class="col-lg-6">
                                                <label>E-mail</label>
                                                <input type="email" name="email" value="{{ $ingresso->email }}" class="form-control">
                                            </div>

                                            {{-- CELULAR --}}
                                            <div class="col-lg-6">
                                                <label>Celular</label>
                                                <input type="text" id="celular" name="celular" value="{{ $ingresso->celular }}" class="form-control">
                                            </div>

                                            {{-- INSTITUIÇÃO --}}
                                            <div class="col-lg-6">
                                                <label>Instituição</label>
                                                <input type="text" name="instituicao_ensino" value="{{ $ingresso->instituicao_ensino ?? '' }}" class="form-control">
                                            </div>

                                            {{-- CURSO --}}
                                            <div class="col-lg-6">
                                                <label>Curso</label>
                                                <input type="text" name="curso" value="{{ $ingresso->curso ?? '' }}" class="form-control">
                                            </div>

                                            {{-- CÓDIGO --}}
                                            <div class="col-lg-6">
                                                <label>Cód. de Uso</label>
                                                <input type="text" class="form-control" value="{{ $carteira->registro }}" readonly>
                                            </div>

                                            <div class="col-12 mt-3">
                                                <button type="submit" class="btn btn-primary btn-sm" id="submitButton">
                                                    <i class="fa fa-save"></i> Atualizar
                                                </button>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </section>
        </div>
    </div>

    {{-- MODAL PARA RECORTAR IMAGEM --}}
    <div class="modal center-modal fade" id="modal-center" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Recortar Imagem</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div id="modalImage" style="max-width: 100%;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" id="cropButton" class="btn btn-primary">Cortar</button>
                </div>
            </div>
        </div>
    </div>

    {{-- MODAL DA CÂMERA --}}
    <div class="modal center-modal fade" id="cameraModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Capturar Foto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <video id="cameraPreview" autoplay playsinline style="width:100%"></video>
                    <canvas id="capturedCanvas" style="display:none"></canvas>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" id="captureButton" class="btn btn-primary">Capturar</button>
                </div>
            </div>
        </div>
    </div>


@endsection
@section('js')

    {{-- InputMask --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.6/jquery.inputmask.min.js"></script>

    {{-- Cropper --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {

            /* ======================================================
             * SWEET ALERT
             * ====================================================== */
            @if (session('success'))
                swal("Sucesso", "{{ session('success') }}", "success");
            @endif

            @if ($errors->any())
                swal("Atenção!", "{{ $errors->first() }}", "error");
            @endif

            /* ======================================================
             * SUBMIT COM LOADING (ANTI DUPLO CLICK)
             * ====================================================== */
            const form = document.getElementById("CarteiraStore");
            const submitButton = document.getElementById("submitButton");

            if (form && submitButton) {
                submitButton.addEventListener("click", function(e) {
                    e.preventDefault();
                    submitButton.disabled = true;
                    submitButton.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Processando...';
                    form.submit();
                });
            }

            /* ======================================================
             * INPUT MASK
             * ====================================================== */
            if (window.$) {
                $('#cpf').inputmask('999.999.999-99');
                $('#celular').inputmask('(99)99999-9999');
                $('#nascimento').inputmask('99/99/9999');
            }

            /* ======================================================
             * VARIÁVEIS
             * ====================================================== */
            let cropper = null;
            let cameraStream = null;

            const imageInput = document.getElementById('imageInput');
            const imagePreview = document.getElementById('imagePreview');
            const modalShow = document.getElementById('modalShow');
            const openCameraButton = document.getElementById('openCameraButton');
            const cropButton = document.getElementById('cropButton');
            const modalImage = document.getElementById('modalImage');

            const cropModalEl = document.getElementById('modal-center');
            const cameraModalEl = document.getElementById('cameraModal');

            if (!cropModalEl || !cameraModalEl) return;

            const cropModal = new bootstrap.Modal(cropModalEl, {
                backdrop: 'static',
                keyboard: false
            });

            const cameraModal = new bootstrap.Modal(cameraModalEl, {
                backdrop: 'static',
                keyboard: false
            });

            /* ======================================================
             * INIT CROP
             * ====================================================== */
            function initCropper(imageSrc) {
                if (!modalImage) return;

                modalImage.innerHTML = '';

                const img = document.createElement('img');
                img.src = imageSrc;
                img.style.maxWidth = '100%';

                modalImage.appendChild(img);

                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }

                cropper = new Cropper(img, {
                    aspectRatio: 3 / 4,
                    viewMode: 2,
                    autoCropArea: 1
                });

                cropModal.show();
            }

            /* ======================================================
             * UPLOAD IMAGEM
             * ====================================================== */
            if (modalShow && imageInput) {
                modalShow.addEventListener('click', () => imageInput.click());

                imageInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    if (!file) return;

                    const reader = new FileReader();
                    reader.onload = ev => initCropper(ev.target.result);
                    reader.readAsDataURL(file);
                });
            }

            /* ======================================================
             * CORTAR IMAGEM
             * ====================================================== */
            if (cropButton) {
                cropButton.addEventListener('click', function() {
                    if (!cropper || !imageInput || !imagePreview) return;

                    const canvas = cropper.getCroppedCanvas({
                        width: 600,
                        height: 800
                    });

                    canvas.toBlob(blob => {
                        if (!blob) return;

                        const file = new File([blob], 'foto.jpg', {
                            type: 'image/jpeg'
                        });

                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(file);

                        // 🔥 isso é o que realmente importa
                        imageInput.files = dataTransfer.files;
                        imagePreview.src = URL.createObjectURL(file);

                        cropModal.hide();
                    }, 'image/jpeg', 0.9);
                });

            }

            /* ======================================================
             * LIMPAR CROP AO FECHAR
             * ====================================================== */
            cropModalEl.addEventListener('hidden.bs.modal', function() {
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });

            /* ======================================================
             * ABRIR CÂMERA
             * ====================================================== */
            if (openCameraButton) {
                openCameraButton.addEventListener('click', async function() {
                    try {
                        cameraModal.show();

                        cameraStream = await navigator.mediaDevices.getUserMedia({
                            video: {
                                facingMode: 'user'
                            }
                        });

                        const video = document.getElementById('cameraPreview');
                        if (video) {
                            video.srcObject = cameraStream;
                            video.play();
                        }

                    } catch (err) {
                        alert('Erro ao acessar a câmera');
                        cameraModal.hide();
                    }
                });
            }

            /* ======================================================
             * CAPTURAR FOTO
             * ====================================================== */
            const captureButton = document.getElementById('captureButton');
            if (captureButton) {
                captureButton.addEventListener('click', function() {
                    const video = document.getElementById('cameraPreview');
                    const canvas = document.getElementById('capturedCanvas');
                    if (!video || !canvas) return;

                    const ctx = canvas.getContext('2d');
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    ctx.drawImage(video, 0, 0);

                    const imageData = canvas.toDataURL('image/jpeg', 0.9);
                    stopCamera();
                    cameraModal.hide();
                    initCropper(imageData);
                });
            }

            /* ======================================================
             * PARAR CÂMERA
             * ====================================================== */
            function stopCamera() {
                if (cameraStream) {
                    cameraStream.getTracks().forEach(track => track.stop());
                    cameraStream = null;
                }
            }

            cameraModalEl.addEventListener('hidden.bs.modal', stopCamera);

            /* ======================================================
             * LIMPAR BACKDROP (SEGURANÇA)
             * ====================================================== */
            document.addEventListener('hidden.bs.modal', function() {
                document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
                document.body.classList.remove('modal-open');
                document.body.style.overflow = '';
            });

        });
    </script>
@endsection
