@extends('admin.base.base')
@section('titulo', 'Cupons de desconto ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">

                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Cupons de desconto</h4>
                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modal-novo-cupom" class="btn-rounded btn btn-warning mt-10 mt-md-0 btn-sm float-end">Criar Cupom</a>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Vendas</th>
                                                <th scope="col">Total</th>
                                                <th scope="col">Cupom</th>
                                                <th scope="col">Desconto</th>
                                                <th scope="col">Link</th>
                                                <th scope="col">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_cupons">
                                            @foreach ($Evento->Cupons->where('status', '1') as $cupom)
                                                <tr id="colaborador{{ $cupom->id }}">
                                                    <td>{{ $cupom->Pedidos->count() }} <br></td>
                                                    <td>R$ {{ moeda($cupom->Pedidos->sum('sub_total')) }}</td>
                                                    <td>{{ $cupom->cupom }}</td>
                                                    <td>{{ $cupom->desconto }}%</td>
                                                    <td>
                                                        <a href="javascript:void(0)" class="copiar-link" data-link="{{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}">
                                                            Copiar Link
                                                        </a>
                                                    </td>
                                                    <td>
                                                        @php
                                                            $texto =
                                                                "🎉 Garanta já seu ingresso com {$cupom->desconto}% OFF usando o cupom {$cupom->cupom} para o evento {$Evento->titulo} 👉 clique aqui para comprar: " .
                                                                env('BASE_SITE') .
                                                                "/evento/{$Evento->url}/{$Evento->id}/{$cupom->cupom}";
                                                            $urlWhatsapp = 'https://api.whatsapp.com/send?text=' . urlencode($texto);
                                                        @endphp
                                                        <a class="m-5" href="{{ $urlWhatsapp }}" target="_blank" title="Compartilhar no WhatsApp">
                                                            <img src="{{ url('images/zap-verde.png') }}" width="20">
                                                        </a>

                                                        <a class="m-5" href="javascript:void(0)" onclick="javacript:Editar({{ $cupom->id }})">
                                                            <i class="glyphicon glyphicon-pencil"></i>
                                                        </a>
                                                        <a class="text-danger m-5" href="javascript:void(0)" onclick="javacript:Dell({{ $cupom->id }})">
                                                            <i class="glyphicon glyphicon-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="modal fade modal-novo-cupom" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar Cupom</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Cupom</label>
                                <input type="text" class="form-control" placeholder="Ex.: VIP10" id="cupom">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Desconto (digite apenas 10 para 10%)</label>
                                <input type="text" class="form-control" id="desconto">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button type="button" class="btn btn-danger text-start btn-rounded btn-sm" data-bs-dismiss="modal">Fechar</button>
                    <button onclick="javascript:AddCupom({{ $Evento->id }})" type="button" class="btn btn-primary float-end btn-rounded btn-sm" data-bs-dismiss="modal">Adicionar</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade modal-colaborador" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_colaborador">
        </div>
    </div>
@endsection
@section('css')
    <style>
        .select2-container {
            z-index: 9999 !important;
            /* Valor alto para garantir que ficará acima do modal */
        }

        .select2-dropdown {
            z-index: 10000 !important;
            /* Garantir que o dropdown também tenha um z-index alto */
        }
    </style>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-tagsinput/dist/bootstrap-tagsinput.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/select2/dist/js/select2.full.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/input-mask/jquery.inputmask.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/input-mask/jquery.inputmask.extensions.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/moment/min/moment.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/timepicker/bootstrap-timepicker.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/iCheck/icheck.min.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/advanced-form-element.js"></script>
    <script>
        function AddCupom(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('cupom.create.store') }}",
                method: 'POST',
                data: {
                    evento_id: id,
                    cupom: $("#cupom").val(),
                    desconto: $("#desconto").val(),
                },
                success: function(result) {
                    console.log(result);

                    if (result == 'error') {
                        swal("Atenção", "O cupom informado já esta em uso", "error");
                    } else {
                        $("#result_cupons").html(result);
                        $(".modal-novo-cupom").modal('hide');
                    }

                    const links = document.querySelectorAll('.copiar-link');
                    links.forEach(function(link) {
                        link.addEventListener('click', function() {
                            const url = this.getAttribute('data-link');

                            navigator.clipboard.writeText(url).then(() => {
                                alert('Link copiado com sucesso!');
                            }).catch(err => {
                                console.error('Erro ao copiar link: ', err);
                                alert('Erro ao copiar o link.');
                            });
                        });
                    });

                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function ColaboradorUpdate(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('colaborador.update') }}",
                method: 'POST',
                data: {
                    id: id,
                    nivel: $("#nivel_update").val(),
                    pacotes: $("#pacotes_update").val(),
                },
                success: function(result) {
                    if (result == 'error') {
                        swal("Atenção", "O email informado não foi encontrato", "error");
                    } else {
                        $("#result_cupons").html(result);
                        $(".modal-colaborador").modal('hide');
                    }

                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function Editar(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('colaborador.show') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_colaborador").html(result);
                    $(".modal-colaborador").modal('show');

                    $('.select2').select2();
                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function Dell(id) {
            swal({
                title: "Atenção!",
                text: "Deseja desativar este cupom?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{ route('cupom.destroy') }}",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#colaborador" + id).hide();
                            swal("Deletado!", "Cupom desativado", "success");
                        },
                        error: function(xhr, status, error) {
                            alert("Não foi possível atualizar o status. Tente novamente.");
                        }
                    });
                } else {
                    swal("Cancelado", "O colaborador ainda esta na equipe.", "error");
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            const links = document.querySelectorAll('.copiar-link');
            links.forEach(function(link) {
                link.addEventListener('click', function() {
                    const url = this.getAttribute('data-link');

                    navigator.clipboard.writeText(url).then(() => {
                        alert('Link copiado com sucesso!');
                    }).catch(err => {
                        console.error('Erro ao copiar link: ', err);
                        alert('Erro ao copiar o link.');
                    });
                });
            });
        });
    </script>
@endsection
