@extends('admin.base.base')
@section('titulo', $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-lg-12 col-12">
                        <div class="box">
                            <div class="box-body">
                                <div id="cortesias">
                                    <div class="row cortesia-item">
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label>Pacote</label>
                                                <select class="form-select" name="pacote_id">
                                                    @foreach ($Evento->Pacotes as $item)
                                                        <option value="{{ $item->id }}" {{ $item->preco == '0' ? 'selected' : '' }}>{{ $item->nome }} R$ {{ moeda($item->preco) }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group">
                                                <label>Nome Completo</label>
                                                <input type="text" class="form-control" name="nome_completo[]">
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group">
                                                <label>Email</label>
                                                <input type="email" class="form-control" name="email[]">
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group">
                                                <label>CPF</label>
                                                <input type="cel" class="form-control cpf" name="cpf[]">
                                            </div>
                                        </div>
                                        <div class="col-1 d-flex align-items-center">
                                            <a href="javascript:void(0)" onclick="addIngresso()" class="btn btn-circle btn-success btn-xs me-2" data-bs-toggle="tooltip" title="Adicionar">
                                                <i class="ti-plus"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 col-12">
                    <div class="box">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="button" onclick="javascript:GerarIngressos()" class="btn btn-primary btn-sm"> <i class="fa fa-check"></i> Gerar Ingressos</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('.cpf').mask('000.000.000-00');
        });

        // Detecta pressionamento da tecla Enter nos inputs dentro de #cortesias
        $(document).on('keydown', '#cortesias input', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault(); // evita submissão do formulário
                addIngresso();
            }
        });

        function DelIngresso(el) {
            // Conta quantos blocos existem
            var total = $('.cortesia-item').length;

            // Se houver mais de 1, pode remover
            if (total > 1) {
                $(el).closest('.cortesia-item').remove();
            } else {
                Swal.fire("Atenção", "É necessário manter pelo menos uma linha!", "warning");
            }
        }


        // Reaplica a máscara nos novos campos adicionados
        function addIngresso() {
            var newItem = `
        <div class="row cortesia-item mt-2">
            <div class="col-2">
                <div class="form-group">
                    <label>Pacote</label>
                    <select class="form-select" name="pacote_id">
                        @foreach ($Evento->Pacotes as $item)
                            <option value="{{ $item->id }}" {{ $item->preco == '0' ? 'selected' : '' }}>{{ $item->nome }} R$ {{ moeda($item->preco) }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-3">
                <div class="form-group">
                    <label>Nome Completo</label>
                    <input type="text" class="form-control" name="nome_completo[]">
                </div>
            </div>
            <div class="col-3">
                <div class="form-group">
                    <label>Email</label>
                    <input type="text" class="form-control" name="email[]">
                </div>
            </div>
            <div class="col-3">
                <div class="form-group">
                    <label>CPF</label>
                    <input type="text" class="form-control cpf" name="cpf[]">
                </div>
            </div>
            <div class="col-1 d-flex align-items-center">
                <a href="javascript:void(0)" onclick="DelIngresso(this)" class="btn btn-circle btn-danger btn-xs me-2" data-bs-toggle="tooltip" title="Remover">
                    <i class="ti-minus"></i>
                </a>
            </div>
        </div>
    `;

            $('#cortesias').append(newItem);
            $('.cpf').mask('000.000.000-00');

            // Foca automaticamente no último nome_completo adicionado
            $('#cortesias .cortesia-item:last input[name="nome_completo[]"]').focus();
        }


        function GerarIngressos() {
            var audio = new Audio('{{ url('audio/fail.mp3') }}');
            audio.play();
            Swal.fire({
                title: 'Continuar e gerar os ingressos?',
                text: "Essa ação poderá ser desfeita!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, gerar!',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    mostrarLoaderSwal();

                    // Coleta todos os dados
                    let dados = {
                        evento_id: {{ $Evento->id }},
                        pacotes: [],
                        nomes: [],
                        emails: [],
                        cpfs: []
                    };

                    // Loop pelos campos
                    $('#cortesias .cortesia-item').each(function() {
                        const pacote = $(this).find('select[name="pacote_id"]').val();
                        const nome = $(this).find('input[name="nome_completo[]"]').val();
                        const email = $(this).find('input[name="email[]"]').val();
                        const cpf = $(this).find('input[name="cpf[]"]').val();

                        dados.pacotes.push(pacote);
                        dados.nomes.push(nome);
                        dados.emails.push(email);
                        dados.cpfs.push(cpf);
                    });

                    // Envia os dados via AJAX
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('participante.store') }}",
                        method: 'POST',
                        data: dados,
                        success: function(result) {
                            Swal.close();

                            Swal.fire('Sucesso', 'Ingressos gerados com sucesso!', 'success');

                            // Remove todas as linhas exceto a primeira
                            $('#cortesias .cortesia-item').not(':first').remove();

                            // Limpa os campos da primeira linha
                            const primeira = $('#cortesias .cortesia-item').first();
                            primeira.find('input').val('');
                            primeira.find('select').prop('selectedIndex', 0);

                            // Reaplica a máscara
                            $('.cpf').mask('000.000.000-00');

                            // Coloca o foco novamente no primeiro campo
                            primeira.find('input[name="nome_completo[]"]').focus();
                        },
                        error: function(xhr) {
                            Swal.fire('Erro', 'Não foi possível gerar os ingressos.', 'error');
                        }
                    });
                }
            });
        }



        function mostrarLoaderSwal() {
            Swal.fire({
                title: "Aguarde",
                html: "Gerando ingresso(s)... <b></b>",
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 10000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        if (Swal.getTimerLeft() !== null) {
                            timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                        }
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                }
            });
        }
    </script>

@endsection
