@extends('admin.base.base')
@section('titulo', 'Participantes ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')

                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <table id="tickets" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting">CheckIn</th>
                                            <th class="sorting">Participante</th>
                                            <th class="sorting">Data Check-in</th>
                                            <th class="sorting">Tipo</th>
                                            <th class="sorting">Nº Ingresso</th>
                                            <th class="sorting">Nº Pedido</th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_ingressos">
                                        @foreach ($Evento->Ingressos->where('status', '1') as $item)
                                            <tr role="row" class="odd">
                                                <td class="center">
                                                    @if ($item->check_in_status == '0')
                                                        <button onclick="javascript:CheckIn({{ $item->id }})" type="button" class="waves-effect waves-light btn btn-secondary btn-flat mb-5 btn-sm">Fazer Check-in</button>
                                                    @else
                                                        <button onclick="javascript:Error({{ $item->id }})" type="button" class="waves-effect waves-light btn btn-success mb-5 btn-sm" style="width: 100px">
                                                            <i class="glyphicon glyphicon-ok"></i>
                                                        </button>
                                                    @endif
                                                </td>
                                                <td>{{ $item->nome_completo }}</td>
                                                <td>{{ !empty($item->check_in_data) ? date('d/m/Y H:i', strtotime($item->check_in_data)) : '' }}</td>
                                                <td>{{ $item->Pacote->nome }}</td>
                                                <td>{{ $item->registro }}</td>
                                                <td>{{ $item->Pedido->registro }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('css')

@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/jquery.peity/jquery.peity.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/data-table.js"></script>
    <script src="{{ url('admin') }}/src/js/pages/app-ticket.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function CheckIn(id) {
            Swal.fire({
                title: 'Confirmar Check-In?',
                text: "Tem certeza que deseja realizar o check-in deste ingresso?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Sim, confirmar',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    mostrarLoaderSwal();

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('checkIn.store') }}",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            Swal.close();
                            $("#result_ingressos").html(result);
                        },
                        error: function(xhr) {
                            Swal.fire('Erro', 'Não foi possível realizar o check-in.', 'error');
                        }
                    });
                }
            });
        }

        function mostrarLoaderSwal() {
            Swal.fire({
                title: "Aguarde",
                html: "Realizando Check-In... <b></b>",
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 10000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        if (Swal.getTimerLeft() !== null) {
                            timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                        }
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                }
            });
        }

        function Error(id) {
            Swal.fire('Atenção!', 'Check-In já foi realizado.', 'error');
        }
    </script>

@endsection
