<div class="modal-content transparent-modal">

    <div class="modal-body center">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <!DOCTYPE html>
<html lang="pt-BR">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Musa Ticket</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                margin: 0;
            }

            .ticket {
                width: 380px;
                height: 600px;
                border: 1px solid black;
                padding: 20px;
                text-align: center;
                position: relative;
                background-image: url('{{ url('site/assets/img/ingresso.jpg') }}');
                background-size: contain;
                background-repeat: no-repeat;
                background-position: center;
            }

            .logo {
                width: 100px;
                margin-bottom: 10px;
                z-index: 2;
                position: relative;
            }

            h2,
            h3,
            p {
                margin: 5px 0;
                z-index: 2;
                position: relative;
            }

            .price {
                font-size: 24px;
                font-weight: bold;
                margin-top: 20px;
                z-index: 2;
                position: relative;
            }

            .info-qr-container {
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: absolute;
                /* Posiciona o contêiner de forma absoluta */
                bottom: 20px;
                /* Define a margem inferior de 20px */
                left: 40px;
                right: 40px;
                z-index: 2;
            }

            .price-info {
                text-align: left;
            }

            .qr-code img {
                width: 100px;
            }

            .person-info {
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                margin-top: 30px;
            }

            .titulo1 {
                font-size: 25px;
                font-weight: bold;
            }

            .text {
                font-size: 16px;
                font-weight: 600
            }

            .evento{
                margin-top: 20px;
            }
        </style>
    </head>

    <body>
        <div class="ticket">
            <img src="{{ url('site/assets/img/favicon.png') }}" alt="Musa Logo" class="logo">
            <h2>Musa Ticket</h2>
            <p>ID: {{ $ingresso->code_barras }}</p>
            <p>CNPJ: {{ env('CNPJ') }}</p>
            <div class="evento">
                <h3 class="titulo1">{{ $ingresso->Evento->titulo }}</h3>
                <p class="text">
                    {{ $semana[date('w',strtotime($ingresso->Evento->data_inicio))] }}, {{date('d',strtotime($ingresso->Evento->data_inicio))}} de {{ $mes[date('m',strtotime($ingresso->Evento->data_inicio))] }} de {{date('Y',strtotime($ingresso->Evento->data_inicio))}} às {{date('H:i',strtotime($ingresso->Evento->data_inicio))}} <br>
                    {{ $ingresso->Evento->local }} <br>
                    {{ $ingresso->Evento->endereco }}, {{ $ingresso->Evento->numero }}, {{ $ingresso->Evento->bairro }}, {{ $ingresso->Evento->cidade }}-{{ $ingresso->Evento->estado }}
                </p>
            </div>
            <div class="person-info">
                <h3 class="titulo1">{{$ingresso->nome_completo}}</h3>
                <p class="text">
                    CPF: {{$ingresso->cpf}}
                </p>
            </div>
            <div class="info-qr-container">
                <div class="price-info">
                    <div class="price">R$  {{ moeda($ingresso->Pacote->preco) }}</div>
                    <p>{{ $ingresso->Pacote->nome }}</p>
                    <p>Cód.: {{ $ingresso->registro }}</p>
                </div>
                <div class="qr-code">
                    {!! $qr !!}
                </div>
            </div>
        </div>
    </body>
</html>
</div>
<div class="modal-footer modal-footer-uniform">
  <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">Close</button>
  <a href="{{ route('site.ingresso',[$ingresso->id,$ingresso->code_barras]) }}" class="btn btn-primary float-end btn-sm">Abrir</a>
  <button type="button" class="btn btn-primary float-end btn-sm">Compartilhar</button>
</div>
</div>
